/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.client;

import java.util.ArrayList;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteDataStreamer;
import org.apache.ignite.cache.CachePeekMode;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.processors.datastreamer.DataStreamerImpl;
import org.apache.ignite.lang.IgniteFuture;
import org.apache.ignite.lang.IgniteUuid;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.junit.Test;

public class IgniteDataStreamerTest
extends GridCommonAbstractTest {
    public static final String CACHE_NAME = "UUID_CACHE";
    public static final int DATA_SIZE = 3;
    public static final long WAIT_TIMEOUT = 30000L;
    private boolean client = false;

    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(igniteInstanceName);
        if (this.client) {
            cfg.setClientMode(true);
        }
        return cfg;
    }

    protected void beforeTestsStarted() throws Exception {
        super.beforeTestsStarted();
        this.startGrids(2);
        this.client = true;
        this.startGrid("client");
    }

    protected void afterTest() throws Exception {
        super.afterTest();
        this.grid("client").destroyCache(CACHE_NAME);
        this.awaitPartitionMapExchange();
    }

    private <K, V> CacheConfiguration<K, V> cacheConfiguration(Class<K> key, Class<V> value) {
        CacheConfiguration ccfg = new CacheConfiguration(CACHE_NAME);
        ccfg.setIndexedTypes(new Class[]{key, value});
        return ccfg;
    }

    @Test
    public void testStreamerIgniteUuid() throws Exception {
        IgniteEx client = this.grid("client");
        IgniteCache cache = client.createCache(this.cacheConfiguration(IgniteUuid.class, Integer.class));
        try (IgniteDataStreamer streamer = client.dataStreamer(CACHE_NAME);){
            IgniteDataStreamerTest.assertTrue((String)("Expecting " + DataStreamerImpl.class.getName()), (boolean)(streamer instanceof DataStreamerImpl));
            ((DataStreamerImpl)streamer).maxRemapCount(0);
            ArrayList<IgniteFuture> futs = new ArrayList<IgniteFuture>();
            for (int i = 0; i < 3; ++i) {
                IgniteFuture fut = streamer.addData((Object)IgniteUuid.randomUuid(), (Object)i);
                futs.add(fut);
            }
            streamer.flush();
            for (IgniteFuture fut : futs) {
                Object res = fut.get(30000L);
                if (!log.isDebugEnabled()) continue;
                log.debug(String.valueOf(res));
            }
            IgniteDataStreamerTest.assertTrue((cache.size(new CachePeekMode[]{CachePeekMode.ALL}) == 3 ? 1 : 0) != 0);
        }
    }
}

