/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.ttl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.cache.Cache;
import javax.cache.configuration.FactoryBuilder;
import javax.cache.expiry.Duration;
import javax.cache.expiry.ExpiryPolicy;
import javax.cache.expiry.TouchedExpiryPolicy;
import javax.cache.integration.CacheLoaderException;
import javax.cache.integration.CacheWriterException;
import javax.cache.integration.CompletionListener;
import javax.cache.integration.CompletionListenerFuture;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteDataStreamer;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.CachePeekMode;
import org.apache.ignite.cache.CacheRebalanceMode;
import org.apache.ignite.cache.CacheWriteSynchronizationMode;
import org.apache.ignite.cache.eviction.EvictionPolicy;
import org.apache.ignite.cache.eviction.lru.LruEvictionPolicy;
import org.apache.ignite.cache.query.Query;
import org.apache.ignite.cache.query.SqlQuery;
import org.apache.ignite.cache.query.annotations.QuerySqlField;
import org.apache.ignite.cache.store.CacheStoreAdapter;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.lang.IgniteBiInClosure;
import org.apache.ignite.testframework.GridTestUtils;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public abstract class CacheTtlAbstractSelfTest
extends GridCommonAbstractTest {
    private static final int DEFAULT_PAGE_SIZE = 4096;
    @Parameterized.Parameter
    public Boolean useSmallValues;
    private static final int MAX_CACHE_SIZE = 5;
    private static final int SIZE = 11;
    private static final long DEFAULT_TIME_TO_LIVE = 2000L;

    @Parameterized.Parameters(name="useSmallValues = {0}")
    public static List<Object[]> parameters() {
        ArrayList<Object[]> params = new ArrayList<Object[]>(2);
        params.add(new Object[]{Boolean.FALSE});
        params.add(new Object[]{Boolean.TRUE});
        return params;
    }

    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(igniteInstanceName);
        CacheConfiguration ccfg = new CacheConfiguration("default");
        ccfg.setCacheMode(this.cacheMode());
        ccfg.setAtomicityMode(this.atomicityMode());
        LruEvictionPolicy plc = new LruEvictionPolicy();
        plc.setMaxSize(5);
        ccfg.setEvictionPolicy((EvictionPolicy)plc);
        ccfg.setOnheapCacheEnabled(true);
        if (this.useSmallValues.booleanValue()) {
            ccfg.setIndexedTypes(new Class[]{Integer.class, TestValue.class});
        }
        ccfg.setBackups(2);
        ccfg.setWriteSynchronizationMode(CacheWriteSynchronizationMode.FULL_SYNC);
        ccfg.setRebalanceMode(CacheRebalanceMode.SYNC);
        ccfg.setCacheStoreFactory(CacheTtlAbstractSelfTest.singletonFactory((Object)new CacheStoreAdapter(){

            public void loadCache(IgniteBiInClosure clo, Object ... args) {
                for (int i = 0; i < 11; ++i) {
                    clo.apply((Object)i, (Object)new TestValue(i, CacheTtlAbstractSelfTest.this.useSmallValues));
                }
            }

            public Object load(Object key) throws CacheLoaderException {
                return new TestValue((Integer)key, CacheTtlAbstractSelfTest.this.useSmallValues);
            }

            public void write(Cache.Entry entry) throws CacheWriterException {
            }

            public void delete(Object key) throws CacheWriterException {
            }
        }));
        ccfg.setExpiryPolicyFactory(FactoryBuilder.factoryOf((Serializable)new TouchedExpiryPolicy(new Duration(TimeUnit.MILLISECONDS, 2000L))));
        cfg.setCacheConfiguration(new CacheConfiguration[]{ccfg});
        return cfg;
    }

    protected abstract CacheAtomicityMode atomicityMode();

    protected abstract CacheMode cacheMode();

    protected abstract int gridCount();

    protected void beforeTest() throws Exception {
        this.startGrids(this.gridCount());
    }

    protected void afterTest() throws Exception {
        this.stopAllGrids();
    }

    protected void waitAndCheckExpired(IgniteCache<?, ?> cache) throws IgniteCheckedException {
        boolean awaited = GridTestUtils.waitForCondition(() -> cache.size(new CachePeekMode[0]) == 0, (long)TimeUnit.SECONDS.toMillis(3000L));
        CacheTtlAbstractSelfTest.assertTrue((String)"Failed to wait for expiration", (boolean)awaited);
    }

    @Test
    public void testDefaultTimeToLiveLoadCache() throws Exception {
        IgniteCache cache = this.jcache(0);
        cache.loadCache(null, new Object[0]);
        this.checkSizeBeforeLive(11);
        this.waitAndCheckExpired(cache);
        this.checkSizeAfterLive();
    }

    @Test
    public void testDefaultTimeToLiveLoadAll() throws Exception {
        this.defaultTimeToLiveLoadAll(false);
        this.defaultTimeToLiveLoadAll(true);
    }

    private void defaultTimeToLiveLoadAll(boolean replaceExisting) throws Exception {
        IgniteCache cache = this.jcache(0);
        CompletionListenerFuture fut = new CompletionListenerFuture();
        HashSet<Integer> keys = new HashSet<Integer>();
        for (int i = 0; i < 11; ++i) {
            keys.add(i);
        }
        cache.loadAll(keys, replaceExisting, (CompletionListener)fut);
        fut.get();
        this.checkSizeBeforeLive(11);
        this.waitAndCheckExpired(cache);
        this.checkSizeAfterLive();
    }

    @Test
    public void testDefaultTimeToLiveStreamerAdd() throws Exception {
        int i;
        try (IgniteDataStreamer streamer = this.ignite(0).dataStreamer("default");){
            for (i = 0; i < 11; ++i) {
                streamer.addData((Object)i, (Object)new TestValue(i, this.useSmallValues));
            }
        }
        this.checkSizeBeforeLive(11);
        this.waitAndCheckExpired(this.ignite(0).cache("default"));
        this.checkSizeAfterLive();
        streamer = this.ignite(0).dataStreamer("default");
        var2_2 = null;
        try {
            streamer.allowOverwrite(true);
            for (i = 0; i < 11; ++i) {
                streamer.addData((Object)i, (Object)new TestValue(i, this.useSmallValues));
            }
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
        finally {
            if (streamer != null) {
                if (var2_2 != null) {
                    try {
                        streamer.close();
                    }
                    catch (Throwable throwable) {
                        var2_2.addSuppressed(throwable);
                    }
                } else {
                    streamer.close();
                }
            }
        }
        this.checkSizeBeforeLive(11);
        this.waitAndCheckExpired(this.ignite(0).cache("default"));
        this.checkSizeAfterLive();
    }

    @Test
    public void testDefaultTimeToLivePut() throws Exception {
        IgniteCache cache = this.jcache(0);
        Integer key = 0;
        cache.put((Object)key, (Object)new TestValue(key, this.useSmallValues));
        this.checkSizeBeforeLive(1);
        this.waitAndCheckExpired(cache);
        this.checkSizeAfterLive();
    }

    @Test
    public void testDefaultTimeToLivePutAll() throws Exception {
        IgniteCache cache = this.jcache(0);
        HashMap<Integer, TestValue> entries = new HashMap<Integer, TestValue>();
        for (int i = 0; i < 11; ++i) {
            entries.put(i, new TestValue(i, this.useSmallValues));
        }
        cache.putAll(entries);
        this.checkSizeBeforeLive(11);
        this.waitAndCheckExpired(cache);
        this.checkSizeAfterLive();
    }

    @Test
    public void testDefaultTimeToLivePreload() throws Exception {
        if (this.cacheMode() == CacheMode.LOCAL) {
            return;
        }
        IgniteCache cache = this.jcache(0);
        HashMap<Integer, TestValue> entries = new HashMap<Integer, TestValue>();
        for (int i = 0; i < 11; ++i) {
            entries.put(i, new TestValue(i, this.useSmallValues));
        }
        cache.putAll(entries);
        this.startGrid(this.gridCount());
        this.checkSizeBeforeLive(11, this.gridCount() + 1);
        this.waitAndCheckExpired(cache);
        this.checkSizeAfterLive(this.gridCount() + 1);
    }

    @Test
    public void testTimeToLiveTtl() throws Exception {
        long time = 4000L;
        IgniteCache cache = this.jcache(0).withExpiryPolicy((ExpiryPolicy)new TouchedExpiryPolicy(new Duration(TimeUnit.MILLISECONDS, time)));
        for (int i = 0; i < 11; ++i) {
            cache.put((Object)i, (Object)new TestValue(i, this.useSmallValues));
        }
        this.checkSizeBeforeLive(11);
        Thread.sleep(2500L);
        this.checkSizeBeforeLive(11);
        this.waitAndCheckExpired(cache);
        this.checkSizeAfterLive();
    }

    private void checkSizeBeforeLive(int size) throws Exception {
        this.checkSizeBeforeLive(size, this.gridCount());
    }

    private void checkSizeBeforeLive(int size, int gridCnt) throws Exception {
        for (int i = 0; i < gridCnt; ++i) {
            IgniteCache cache = this.jcache(i);
            log.info("Size [node=" + i + ", " + cache.localSize(new CachePeekMode[]{CachePeekMode.PRIMARY, CachePeekMode.BACKUP, CachePeekMode.NEAR}) + ']');
            CacheTtlAbstractSelfTest.assertEquals((String)("Unexpected size, node: " + i), (int)size, (int)cache.localSize(new CachePeekMode[]{CachePeekMode.PRIMARY, CachePeekMode.BACKUP, CachePeekMode.NEAR}));
            for (int key = 0; key < size; ++key) {
                CacheTtlAbstractSelfTest.assertNotNull((Object)cache.localPeek((Object)key, new CachePeekMode[0]));
            }
            if (!this.useSmallValues.booleanValue()) continue;
            CacheTtlAbstractSelfTest.assertFalse((boolean)cache.query((Query)new SqlQuery(TestValue.class, "1 = 1")).getAll().isEmpty());
        }
    }

    private void checkSizeAfterLive() throws Exception {
        this.checkSizeAfterLive(this.gridCount());
    }

    private void checkSizeAfterLive(int gridCnt) throws Exception {
        for (int i = 0; i < gridCnt; ++i) {
            IgniteCache cache = this.jcache(i);
            log.info("Size [node=" + i + ", heap=" + cache.localSize(new CachePeekMode[]{CachePeekMode.ONHEAP}) + ", offheap=" + cache.localSize(new CachePeekMode[]{CachePeekMode.OFFHEAP}) + ']');
            CacheTtlAbstractSelfTest.assertEquals((int)0, (int)cache.localSize(new CachePeekMode[0]));
            CacheTtlAbstractSelfTest.assertEquals((int)0, (int)cache.localSize(new CachePeekMode[]{CachePeekMode.OFFHEAP}));
            if (this.useSmallValues.booleanValue()) {
                CacheTtlAbstractSelfTest.assertEquals((int)0, (int)cache.query((Query)new SqlQuery(TestValue.class, "1 = 1")).getAll().size());
            }
            for (int key = 0; key < 11; ++key) {
                CacheTtlAbstractSelfTest.assertNull((Object)cache.localPeek((Object)key, new CachePeekMode[0]));
            }
        }
    }

    public static class TestValue {
        @QuerySqlField
        public final int intPayload;
        public final byte[] data;

        public TestValue(int key, boolean useSmallValues) {
            this.intPayload = key;
            this.data = useSmallValues ? new byte[128] : new byte[20480];
        }
    }
}

