/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence.db;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.cache.QueryEntity;
import org.apache.ignite.cache.QueryIndex;
import org.apache.ignite.cache.QueryIndexType;
import org.apache.ignite.cache.affinity.AffinityFunction;
import org.apache.ignite.cache.affinity.rendezvous.RendezvousAffinityFunction;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.DataRegionConfiguration;
import org.apache.ignite.configuration.DataStorageConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.visor.verify.ValidateIndexesClosure;
import org.apache.ignite.internal.visor.verify.VisorValidateIndexesJobResult;
import org.apache.ignite.testframework.GridTestUtils;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.junit.Test;

public class IndexingMultithreadedLoadContinuousRestartTest
extends GridCommonAbstractTest {
    private static final String CACHE_NAME = "test-cache-name";
    private static final int RESTARTS = 5;
    private static final int THREADS = 5;
    private static final int LOAD_LOOP = 5000;
    private static final int KEY_BOUND = 1000;

    protected IgniteConfiguration getConfiguration(String gridName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(gridName);
        QueryEntity qryEntity = new QueryEntity();
        qryEntity.setKeyType(UserKey.class.getName());
        qryEntity.setValueType(UserValue.class.getName());
        qryEntity.setTableName("USER_TEST_TABLE");
        qryEntity.setKeyFields(new HashSet<String>(Arrays.asList("a", "b", "c")));
        LinkedHashMap<String, String> fields = new LinkedHashMap<String, String>();
        fields.put("a", "java.lang.Integer");
        fields.put("b", "java.lang.Integer");
        fields.put("c", "java.lang.Integer");
        fields.put("x", "java.lang.Integer");
        fields.put("y", "java.lang.Integer");
        fields.put("z", "java.lang.Integer");
        qryEntity.setFields(fields);
        QueryIndex idx1 = new QueryIndex();
        idx1.setName("IDX_1");
        idx1.setIndexType(QueryIndexType.SORTED);
        LinkedHashMap<String, Boolean> idxFields = new LinkedHashMap<String, Boolean>();
        idxFields.put("a", false);
        idxFields.put("b", false);
        idxFields.put("c", false);
        idx1.setFields(idxFields);
        QueryIndex idx2 = new QueryIndex();
        idx2.setName("IDX_2");
        idx2.setIndexType(QueryIndexType.SORTED);
        idxFields = new LinkedHashMap();
        idxFields.put("x", false);
        idx2.setFields(idxFields);
        QueryIndex idx3 = new QueryIndex();
        idx3.setName("IDX_3");
        idx3.setIndexType(QueryIndexType.SORTED);
        idxFields = new LinkedHashMap();
        idxFields.put("y", false);
        idx3.setFields(idxFields);
        QueryIndex idx4 = new QueryIndex();
        idx4.setName("IDX_4");
        idx4.setIndexType(QueryIndexType.SORTED);
        idxFields = new LinkedHashMap();
        idxFields.put("z", false);
        idx4.setFields(idxFields);
        qryEntity.setIndexes(Arrays.asList(idx1, idx2, idx3, idx4));
        cfg.setCacheConfiguration(new CacheConfiguration[]{new CacheConfiguration().setAffinity((AffinityFunction)new RendezvousAffinityFunction(false, 32)).setName(CACHE_NAME).setQueryEntities(Collections.singleton(qryEntity))});
        cfg.setDataStorageConfiguration(new DataStorageConfiguration().setDefaultDataRegionConfiguration(new DataRegionConfiguration().setPersistenceEnabled(true).setInitialSize(0xC800000L).setMaxSize(0xC800000L)));
        return cfg;
    }

    protected void beforeTest() throws Exception {
        super.beforeTest();
        this.cleanPersistenceDir();
    }

    protected void afterTest() throws Exception {
        super.afterTest();
        this.cleanPersistenceDir();
    }

    @Test
    public void test() throws Exception {
        for (int i = 0; i < 5; ++i) {
            final IgniteEx ignite = this.startGrid(0);
            ignite.cluster().active(true);
            this.forceCheckpoint();
            ValidateIndexesClosure clo = new ValidateIndexesClosure(() -> false, Collections.singleton(CACHE_NAME), 0, 0, false, true);
            ignite.context().resource().injectGeneric((Object)clo);
            VisorValidateIndexesJobResult res = clo.call();
            IndexingMultithreadedLoadContinuousRestartTest.assertFalse((boolean)res.hasIssues());
            IgniteInternalFuture fut = GridTestUtils.runMultiThreadedAsync((Runnable)new Runnable(){

                @Override
                public void run() {
                    int i;
                    IgniteCache cache = ignite.cache(IndexingMultithreadedLoadContinuousRestartTest.CACHE_NAME);
                    try {
                        for (i = 0; i < 5000; ++i) {
                            ThreadLocalRandom r = ThreadLocalRandom.current();
                            Integer keySeed = r.nextInt(1000);
                            UserKey key = new UserKey(keySeed.intValue());
                            if (r.nextBoolean()) {
                                cache.put((Object)key, (Object)new UserValue(r.nextLong()));
                                continue;
                            }
                            cache.remove((Object)key);
                        }
                        ignite.close();
                    }
                    catch (Exception e) {
                        log.warning("Failed to update cache after " + i + " loop cycles", (Throwable)e);
                    }
                }
            }, (int)5, (String)"loader");
            fut.get();
            ignite.close();
        }
    }

    private static class UserValue {
        private int x;
        private int y;
        private int z;

        public UserValue(int x, int y, int z) {
            this.x = x;
            this.y = y;
            this.z = z;
        }

        public UserValue(long seed) {
            this.x = (int)(seed % 6991L);
            this.y = (int)(seed % 18679L);
            this.z = (int)(seed % 31721L);
        }

        public String toString() {
            return "UserValue{x=" + this.x + ", y=" + this.y + ", z=" + this.z + '}';
        }
    }

    private static class UserKey {
        private int a;
        private int b;
        private int c;

        public UserKey(int a, int b, int c) {
            this.a = a;
            this.b = b;
            this.c = c;
        }

        public UserKey(long seed) {
            this.a = (int)(seed % 17L);
            this.b = (int)(seed % 257L);
            this.c = (int)(seed % 3001L);
        }

        public String toString() {
            return "UserKey{a=" + this.a + ", b=" + this.b + ", c=" + this.c + '}';
        }
    }
}

