/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.mvcc;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.cache.CacheWriteSynchronizationMode;
import org.apache.ignite.cache.affinity.Affinity;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.TestRecordingCommunicationSpi;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.IgniteCacheProxy;
import org.apache.ignite.internal.processors.cache.KeyCacheObject;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtTxQueryEnlistResponse;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.GridDhtForceKeysRequest;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.GridDhtForceKeysResponse;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.GridDhtPartitionSupplyMessage;
import org.apache.ignite.internal.processors.cache.mvcc.CacheMvccAbstractTest;
import org.apache.ignite.internal.processors.cache.mvcc.MvccUpdateVersionAware;
import org.apache.ignite.internal.processors.cache.mvcc.MvccUtils;
import org.apache.ignite.internal.processors.cache.mvcc.MvccVersion;
import org.apache.ignite.internal.processors.cache.mvcc.MvccVersionAware;
import org.apache.ignite.internal.processors.cache.persistence.CacheDataRow;
import org.apache.ignite.internal.processors.cache.tree.mvcc.data.MvccDataRow;
import org.apache.ignite.internal.util.lang.GridCursor;
import org.apache.ignite.lang.IgniteBiInClosure;
import org.apache.ignite.lang.IgniteBiTuple;
import org.apache.ignite.lang.IgniteInClosure;
import org.apache.ignite.plugin.extensions.communication.Message;
import org.apache.ignite.testframework.junits.GridAbstractTest;
import org.apache.ignite.transactions.Transaction;
import org.apache.ignite.transactions.TransactionConcurrency;
import org.apache.ignite.transactions.TransactionIsolation;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public abstract class CacheMvccBackupsAbstractTest
extends CacheMvccAbstractTest {
    private final long txLongTimeout = this.getTestTimeout() / 4L;

    @Test
    public void testBackupsCoherenceSimple() throws Exception {
        SqlFieldsQuery qry;
        int i;
        this.disableScheduledVacuum = true;
        this.ccfg = this.cacheConfiguration(this.cacheMode(), CacheWriteSynchronizationMode.FULL_SYNC, 2, 10).setIndexedTypes(new Class[]{Integer.class, Integer.class});
        int KEYS_CNT = 5000;
        this.startGrids(3);
        IgniteEx node0 = this.grid(0);
        IgniteEx node1 = this.grid(1);
        IgniteEx node2 = this.grid(2);
        this.client = true;
        IgniteEx client = this.startGrid();
        this.awaitPartitionMapExchange();
        IgniteCache clientCache = client.cache("default");
        IgniteCache cache0 = node0.cache("default");
        IgniteCache cache1 = node1.cache("default");
        IgniteCache cache2 = node2.cache("default");
        try (Transaction tx = client.transactions().txStart(TransactionConcurrency.PESSIMISTIC, TransactionIsolation.REPEATABLE_READ);){
            tx.timeout(this.txLongTimeout);
            for (i = 0; i < 2500; i += 2) {
                qry = new SqlFieldsQuery("INSERT INTO Integer (_key, _val) values (" + i + ',' + i * 2 + "), (" + (i + 1) + ',' + (i + 1) * 2 + ')');
                clientCache.query(qry).getAll();
            }
            tx.commit();
        }
        tx = client.transactions().txStart(TransactionConcurrency.PESSIMISTIC, TransactionIsolation.REPEATABLE_READ);
        var11_11 = null;
        try {
            tx.timeout(this.txLongTimeout);
            for (i = 0; i < 10; ++i) {
                qry = new SqlFieldsQuery("DELETE from Integer WHERE _key = " + i);
                clientCache.query(qry).getAll();
            }
            for (i = 10; i < 5001; ++i) {
                qry = new SqlFieldsQuery("UPDATE Integer SET _val=" + i * 10 + " WHERE _key = " + i);
                clientCache.query(qry).getAll();
            }
            tx.commit();
        }
        catch (Throwable i2) {
            var11_11 = i2;
            throw i2;
        }
        finally {
            if (tx != null) {
                if (var11_11 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable i2) {
                        var11_11.addSuppressed(i2);
                    }
                } else {
                    tx.close();
                }
            }
        }
        Map<KeyCacheObject, List<CacheDataRow>> vers0 = this.allVersions(cache0);
        List res0 = this.getAll(cache0, "Integer");
        this.stopGrid(0);
        this.awaitPartitionMapExchange();
        Map<KeyCacheObject, List<CacheDataRow>> vers1 = this.allVersions(cache1);
        this.assertVersionsEquals(vers0, vers1);
        List res1 = this.getAll(cache1, "Integer");
        CacheMvccBackupsAbstractTest.assertEqualsCollections((Collection)res0, (Collection)res1);
        try (Transaction tx = client.transactions().txStart(TransactionConcurrency.PESSIMISTIC, TransactionIsolation.REPEATABLE_READ);){
            SqlFieldsQuery qry2;
            int i3;
            tx.timeout(this.txLongTimeout);
            for (i3 = 10; i3 < 20; ++i3) {
                qry2 = new SqlFieldsQuery("DELETE from Integer WHERE _key = " + i3);
                clientCache.query(qry2).getAll();
            }
            for (i3 = 20; i3 < 5001; ++i3) {
                qry2 = new SqlFieldsQuery("UPDATE Integer SET _val=" + i3 * 100 + " WHERE _key = " + i3);
                clientCache.query(qry2).getAll();
            }
            tx.commit();
        }
        vers1 = this.allVersions(cache1);
        res1 = this.getAll(cache2, "Integer");
        this.stopGrid(1);
        this.awaitPartitionMapExchange();
        Map<KeyCacheObject, List<CacheDataRow>> vers2 = this.allVersions(cache2);
        this.assertVersionsEquals(vers1, vers2);
        List res2 = this.getAll(cache2, "Integer");
        CacheMvccBackupsAbstractTest.assertEqualsCollections((Collection)res1, (Collection)res2);
    }

    @Ignore(value="https://issues.apache.org/jira/browse/IGNITE-10104")
    @Test
    public void testBackupsCoherenceWithLargeOperations() throws Exception {
        SqlFieldsQuery qry;
        this.disableScheduledVacuum = true;
        this.ccfg = this.cacheConfiguration(this.cacheMode(), CacheWriteSynchronizationMode.FULL_SYNC, 1, 10).setIndexedTypes(new Class[]{Integer.class, Integer.class});
        int KEYS_CNT = 5000;
        this.startGrids(2);
        IgniteEx node1 = this.grid(0);
        IgniteEx node2 = this.grid(1);
        this.client = true;
        IgniteEx client = this.startGrid();
        this.awaitPartitionMapExchange();
        IgniteCache clientCache = client.cache("default");
        IgniteCache cache1 = node1.cache("default");
        IgniteCache cache2 = node2.cache("default");
        StringBuilder insert = new StringBuilder("INSERT INTO Integer (_key, _val) values ");
        boolean first = true;
        for (int key = 0; key < 5000; ++key) {
            if (!first) {
                insert.append(',');
            } else {
                first = false;
            }
            insert.append('(').append(key).append(',').append(key * 10).append(')');
        }
        String qryStr = insert.toString();
        try (Transaction tx = client.transactions().txStart(TransactionConcurrency.PESSIMISTIC, TransactionIsolation.REPEATABLE_READ);){
            tx.timeout(this.txLongTimeout);
            qry = new SqlFieldsQuery(qryStr);
            clientCache.query(qry).getAll();
            tx.commit();
        }
        qryStr = "SELECT * FROM Integer WHERE _key >= 2500 FOR UPDATE";
        tx = client.transactions().txStart(TransactionConcurrency.PESSIMISTIC, TransactionIsolation.REPEATABLE_READ);
        var12_13 = null;
        try {
            tx.timeout(this.txLongTimeout);
            qry = new SqlFieldsQuery(qryStr);
            clientCache.query(qry).getAll();
            tx.commit();
        }
        catch (Throwable qry2) {
            var12_13 = qry2;
            throw qry2;
        }
        finally {
            if (tx != null) {
                if (var12_13 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable qry2) {
                        var12_13.addSuppressed(qry2);
                    }
                } else {
                    tx.close();
                }
            }
        }
        qryStr = "DELETE FROM Integer WHERE _key >= 2500";
        tx = client.transactions().txStart(TransactionConcurrency.PESSIMISTIC, TransactionIsolation.REPEATABLE_READ);
        var12_13 = null;
        try {
            tx.timeout(this.txLongTimeout);
            qry = new SqlFieldsQuery(qryStr);
            clientCache.query(qry).getAll();
            tx.commit();
        }
        catch (Throwable qry3) {
            var12_13 = qry3;
            throw qry3;
        }
        finally {
            if (tx != null) {
                if (var12_13 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable qry3) {
                        var12_13.addSuppressed(qry3);
                    }
                } else {
                    tx.close();
                }
            }
        }
        Map<KeyCacheObject, List<CacheDataRow>> cache1Vers = this.allVersions(cache1);
        List res1 = this.getAll(cache1, "Integer");
        this.stopGrid(0);
        this.awaitPartitionMapExchange();
        Map<KeyCacheObject, List<CacheDataRow>> cache2Vers = this.allVersions(cache2);
        this.assertVersionsEquals(cache1Vers, cache2Vers);
        List res2 = this.getAll(cache2, "Integer");
        CacheMvccBackupsAbstractTest.assertEqualsCollections((Collection)res1, (Collection)res2);
    }

    @Test
    public void testBackupsCoherenceWithInFlightBatchesOverflow() throws Exception {
        this.testSpi = true;
        this.disableScheduledVacuum = true;
        this.ccfg = this.cacheConfiguration(this.cacheMode(), CacheWriteSynchronizationMode.FULL_SYNC, 1, 1024).setIndexedTypes(new Class[]{Integer.class, Integer.class});
        int KEYS_CNT = 30000;
        this.startGrids(2);
        IgniteEx node1 = this.grid(0);
        IgniteEx node2 = this.grid(1);
        this.client = true;
        IgniteEx client = this.startGrid();
        this.awaitPartitionMapExchange();
        IgniteCache clientCache = client.cache("default");
        IgniteCache cache1 = node1.cache("default");
        IgniteCache cache2 = node2.cache("default");
        AtomicInteger keyGen = new AtomicInteger();
        Affinity affinity = CacheMvccBackupsAbstractTest.affinity((IgniteCache)clientCache);
        ClusterNode cNode1 = node1.localNode();
        ClusterNode cNode2 = node2.localNode();
        StringBuilder insert = new StringBuilder("INSERT INTO Integer (_key, _val) values ");
        for (int i = 0; i < 30000; ++i) {
            Integer key;
            if (i > 0) {
                insert.append(',');
            }
            Integer n = key = i < 15000 ? this.keyForNode(affinity, keyGen, cNode1) : this.keyForNode(affinity, keyGen, cNode2);
            assert (key != null);
            insert.append('(').append(key).append(',').append(key * 10).append(')');
        }
        String qryStr = insert.toString();
        try (Transaction tx = client.transactions().txStart(TransactionConcurrency.PESSIMISTIC, TransactionIsolation.REPEATABLE_READ);){
            tx.timeout(this.txLongTimeout);
            SqlFieldsQuery qry = new SqlFieldsQuery(qryStr);
            clientCache.query(qry).getAll();
            tx.commit();
        }
        TestRecordingCommunicationSpi spi1 = TestRecordingCommunicationSpi.spi((Ignite)node1);
        TestRecordingCommunicationSpi spi2 = TestRecordingCommunicationSpi.spi((Ignite)node2);
        spi1.closure((IgniteBiInClosure)new IgniteBiInClosure<ClusterNode, Message>(){

            public void apply(ClusterNode node, Message msg) {
                if (msg instanceof GridDhtTxQueryEnlistResponse) {
                    GridAbstractTest.doSleep((long)100L);
                }
            }
        });
        spi2.closure((IgniteBiInClosure)new IgniteBiInClosure<ClusterNode, Message>(){

            public void apply(ClusterNode node, Message msg) {
                if (msg instanceof GridDhtTxQueryEnlistResponse) {
                    GridAbstractTest.doSleep((long)100L);
                }
            }
        });
        qryStr = "DELETE FROM Integer WHERE _key >= 10";
        try (Transaction tx = client.transactions().txStart(TransactionConcurrency.PESSIMISTIC, TransactionIsolation.REPEATABLE_READ);){
            tx.timeout(this.txLongTimeout);
            SqlFieldsQuery qry = new SqlFieldsQuery(qryStr);
            clientCache.query(qry).getAll();
            tx.commit();
        }
        Map<KeyCacheObject, List<CacheDataRow>> cache1Vers = this.allVersions(cache1);
        List res1 = this.getAll(cache1, "Integer");
        this.stopGrid(0);
        this.awaitPartitionMapExchange();
        Map<KeyCacheObject, List<CacheDataRow>> cache2Vers = this.allVersions(cache2);
        this.assertVersionsEquals(cache1Vers, cache2Vers);
        List res2 = this.getAll(cache2, "Integer");
        CacheMvccBackupsAbstractTest.assertEqualsCollections((Collection)res1, (Collection)res2);
    }

    @Test
    public void testBackupsCoherenceWithConcurrentUpdates2ServersNoClients() throws Exception {
        this.checkBackupsCoherenceWithConcurrentUpdates(2, 0);
    }

    @Test
    public void testBackupsCoherenceWithConcurrentUpdates4ServersNoClients() throws Exception {
        this.checkBackupsCoherenceWithConcurrentUpdates(4, 0);
    }

    @Test
    public void testBackupsCoherenceWithConcurrentUpdates3Servers1Client() throws Exception {
        this.checkBackupsCoherenceWithConcurrentUpdates(3, 1);
    }

    @Test
    public void testBackupsCoherenceWithConcurrentUpdates5Servers2Clients() throws Exception {
        this.checkBackupsCoherenceWithConcurrentUpdates(5, 2);
    }

    private void checkBackupsCoherenceWithConcurrentUpdates(int srvs, int clients) throws Exception {
        assert (srvs > 1);
        this.disableScheduledVacuum = true;
        this.accountsTxReadAll(srvs, clients, srvs - 1, 1024, (IgniteInClosure)new CacheMvccAbstractTest.InitIndexing(new Class[]{Integer.class, CacheMvccAbstractTest.MvccTestAccount.class}), true, CacheMvccAbstractTest.ReadMode.SQL, CacheMvccAbstractTest.WriteMode.DML, 5000L, null);
        for (int i = 0; i < srvs - 1; ++i) {
            IgniteEx node1 = this.grid(i);
            IgniteCache cache1 = node1.cache("default");
            Map<KeyCacheObject, List<CacheDataRow>> vers1 = this.allVersions(cache1);
            List res1 = this.getAll(cache1, "MvccTestAccount");
            this.stopGrid(i);
            this.awaitPartitionMapExchange();
            IgniteEx node2 = this.grid(i + 1);
            IgniteCache cache2 = node2.cache("default");
            Map<KeyCacheObject, List<CacheDataRow>> vers2 = this.allVersions(cache2);
            this.assertVersionsEquals(vers1, vers2);
            List res2 = this.getAll(cache2, "MvccTestAccount");
            CacheMvccBackupsAbstractTest.assertEqualsCollections((Collection)res1, (Collection)res2);
        }
    }

    @Test
    public void testNoForceKeyRequestDelayedRebalanceNoVacuum() throws Exception {
        this.disableScheduledVacuum = true;
        this.doTestRebalanceNodeAdd(true);
    }

    @Test
    public void testNoForceKeyRequestDelayedRebalance() throws Exception {
        this.doTestRebalanceNodeAdd(true);
    }

    @Test
    public void testNoForceKeyRequestNoVacuum() throws Exception {
        this.disableScheduledVacuum = true;
        this.doTestRebalanceNodeAdd(false);
    }

    @Test
    public void testNoForceKeyRequest() throws Exception {
        this.doTestRebalanceNodeAdd(false);
    }

    private void doTestRebalanceNodeAdd(final boolean delayRebalance) throws Exception {
        SqlFieldsQuery qry;
        this.testSpi = true;
        IgniteEx node1 = this.startGrid(0);
        IgniteCache cache = node1.createCache(this.cacheConfiguration(this.cacheMode(), CacheWriteSynchronizationMode.FULL_SYNC, 1, 16).setIndexedTypes(new Class[]{Integer.class, Integer.class}));
        try (Transaction tx = node1.transactions().txStart(TransactionConcurrency.PESSIMISTIC, TransactionIsolation.REPEATABLE_READ);){
            SqlFieldsQuery qry2 = new SqlFieldsQuery("INSERT INTO Integer (_key, _val) values (1,1),(2,2),(3,3),(4,4),(5,5)");
            cache.query(qry2).getAll();
            tx.commit();
        }
        TestRecordingCommunicationSpi spi = TestRecordingCommunicationSpi.spi((Ignite)node1);
        spi.closure((IgniteBiInClosure)new IgniteBiInClosure<ClusterNode, Message>(){

            public void apply(ClusterNode node, Message msg) {
                if (delayRebalance && msg instanceof GridDhtPartitionSupplyMessage) {
                    GridAbstractTest.doSleep((long)500L);
                }
                if (msg instanceof GridDhtForceKeysResponse) {
                    CacheMvccBackupsAbstractTest.fail((String)"Force key request");
                }
            }
        });
        IgniteEx node2 = this.startGrid(1);
        TestRecordingCommunicationSpi.spi((Ignite)node2).closure((IgniteBiInClosure)new IgniteBiInClosure<ClusterNode, Message>(){

            public void apply(ClusterNode node, Message msg) {
                if (msg instanceof GridDhtForceKeysRequest) {
                    CacheMvccBackupsAbstractTest.fail((String)"Force key request");
                }
            }
        });
        IgniteCache cache2 = node2.cache("default");
        try (Transaction tx = node2.transactions().txStart(TransactionConcurrency.PESSIMISTIC, TransactionIsolation.REPEATABLE_READ);){
            qry = new SqlFieldsQuery("DELETE FROM Integer WHERE _key IN (1,2,3,4,5)");
            cache2.query(qry).getAll();
            tx.commit();
        }
        this.awaitPartitionMapExchange();
        CacheMvccBackupsAbstractTest.doSleep((long)2000L);
        this.stopGrid(1);
        tx = node1.transactions().txStart(TransactionConcurrency.PESSIMISTIC, TransactionIsolation.REPEATABLE_READ);
        var8_12 = null;
        try {
            qry = new SqlFieldsQuery("INSERT INTO Integer (_key, _val) values (1,1),(2,2),(3,3),(4,4),(5,5)");
            cache.query(qry).getAll();
            tx.commit();
        }
        catch (Throwable throwable) {
            var8_12 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var8_12 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var8_12.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
        CacheMvccBackupsAbstractTest.doSleep((long)1000L);
    }

    @Test
    public void testRebalanceNodeLeaveClient() throws Exception {
        this.doTestRebalanceNodeLeave(true);
    }

    @Test
    public void testRebalanceNodeLeaveServer() throws Exception {
        this.doTestRebalanceNodeLeave(false);
    }

    public void doTestRebalanceNodeLeave(boolean startClient) throws Exception {
        this.testSpi = true;
        this.disableScheduledVacuum = true;
        this.startGridsMultiThreaded(4);
        this.client = true;
        IgniteEx node = startClient ? this.startGrid(4) : this.grid(0);
        IgniteCache cache = node.createCache(this.cacheConfiguration(this.cacheMode(), CacheWriteSynchronizationMode.FULL_SYNC, 2, 16).setIndexedTypes(new Class[]{Integer.class, Integer.class}));
        ArrayList keys = new ArrayList();
        for (int i = 0; i < 4; ++i) {
            keys.addAll(this.primaryKeys(this.grid(i).cache("default"), 2));
        }
        try (Transaction tx = node.transactions().txStart(TransactionConcurrency.PESSIMISTIC, TransactionIsolation.REPEATABLE_READ);){
            StringBuilder sb = new StringBuilder("INSERT INTO Integer (_key, _val) values ");
            for (int i = 0; i < keys.size(); ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append("(" + keys.get(i) + ", " + keys.get(i) + ")");
            }
            SqlFieldsQuery qry = new SqlFieldsQuery(sb.toString());
            cache.query(qry).getAll();
            tx.commit();
        }
        this.stopGrid(3);
        this.awaitPartitionMapExchange();
        tx = node.transactions().txStart(TransactionConcurrency.PESSIMISTIC, TransactionIsolation.REPEATABLE_READ);
        var6_7 = null;
        try {
            SqlFieldsQuery qry = new SqlFieldsQuery("UPDATE Integer SET _val = 10*_key");
            cache.query(qry).getAll();
            tx.commit();
        }
        catch (Throwable qry) {
            var6_7 = qry;
            throw qry;
        }
        finally {
            if (tx != null) {
                if (var6_7 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable qry) {
                        var6_7.addSuppressed(qry);
                    }
                } else {
                    tx.close();
                }
            }
        }
        this.awaitPartitionMapExchange();
        for (Integer key : keys) {
            List<CacheDataRow> vers = null;
            for (int i = 0; i < 3; ++i) {
                ClusterNode n = this.grid(i).cluster().localNode();
                if (!node.affinity("default").isPrimaryOrBackup(n, (Object)key)) continue;
                List<CacheDataRow> vers0 = this.allKeyVersions(this.grid(i).cache("default"), key);
                if (vers != null) {
                    this.assertKeyVersionsEquals(vers, vers0);
                }
                vers = vers0;
            }
        }
    }

    private Map<KeyCacheObject, List<CacheDataRow>> allVersions(IgniteCache cache) throws IgniteCheckedException {
        IgniteCacheProxy cache0 = (IgniteCacheProxy)cache;
        GridCacheContext cctx = cache0.context();
        assert (cctx.mvccEnabled());
        HashMap<KeyCacheObject, List<CacheDataRow>> vers = new HashMap<KeyCacheObject, List<CacheDataRow>>();
        for (Object e : cache) {
            IgniteBiTuple entry = (IgniteBiTuple)e;
            KeyCacheObject key = cctx.toCacheKeyObject(entry.getKey());
            GridCursor cur = cctx.offheap().mvccAllVersionsCursor(cctx, key, null);
            ArrayList<CacheDataRow> rows = new ArrayList<CacheDataRow>();
            while (cur.next()) {
                CacheDataRow row = (CacheDataRow)cur.get();
                rows.add(row);
            }
            vers.put(key, rows);
        }
        return vers;
    }

    private List<CacheDataRow> allKeyVersions(IgniteCache cache, Object key) throws IgniteCheckedException {
        IgniteCacheProxy cache0 = (IgniteCacheProxy)cache;
        GridCacheContext cctx = cache0.context();
        KeyCacheObject key0 = cctx.toCacheKeyObject(key);
        GridCursor cur = cctx.offheap().mvccAllVersionsCursor(cctx, key0, null);
        ArrayList<CacheDataRow> rows = new ArrayList<CacheDataRow>();
        while (cur.next()) {
            CacheDataRow row = (CacheDataRow)cur.get();
            rows.add(row);
        }
        return rows;
    }

    private void assertVersionsEquals(Map<KeyCacheObject, List<CacheDataRow>> left, Map<KeyCacheObject, List<CacheDataRow>> right) throws IgniteCheckedException {
        CacheMvccBackupsAbstractTest.assertNotNull(left);
        CacheMvccBackupsAbstractTest.assertNotNull(right);
        CacheMvccBackupsAbstractTest.assertTrue((!left.isEmpty() ? 1 : 0) != 0);
        CacheMvccBackupsAbstractTest.assertTrue((!right.isEmpty() ? 1 : 0) != 0);
        CacheMvccBackupsAbstractTest.assertEqualsCollections(left.keySet(), right.keySet());
        for (KeyCacheObject key : right.keySet()) {
            List<CacheDataRow> leftRows = left.get(key);
            List<CacheDataRow> rightRows = right.get(key);
            this.assertKeyVersionsEquals(leftRows, rightRows);
        }
    }

    private void assertKeyVersionsEquals(List<CacheDataRow> leftRows, List<CacheDataRow> rightRows) throws IgniteCheckedException {
        CacheMvccBackupsAbstractTest.assertNotNull(leftRows);
        CacheMvccBackupsAbstractTest.assertNotNull(rightRows);
        CacheMvccBackupsAbstractTest.assertEquals((String)("leftRows=" + leftRows + ", rightRows=" + rightRows), (int)leftRows.size(), (int)rightRows.size());
        for (int i = 0; i < leftRows.size(); ++i) {
            CacheDataRow leftRow = leftRows.get(i);
            CacheDataRow rightRow = rightRows.get(i);
            CacheMvccBackupsAbstractTest.assertNotNull((Object)leftRow);
            CacheMvccBackupsAbstractTest.assertNotNull((Object)rightRow);
            CacheMvccBackupsAbstractTest.assertTrue((boolean)(leftRow instanceof MvccDataRow));
            CacheMvccBackupsAbstractTest.assertTrue((boolean)(rightRow instanceof MvccDataRow));
            leftRow.key().valueBytes(null);
            CacheMvccBackupsAbstractTest.assertEquals((long)leftRow.expireTime(), (long)rightRow.expireTime());
            CacheMvccBackupsAbstractTest.assertEquals((int)leftRow.partition(), (int)rightRow.partition());
            Assert.assertArrayEquals((byte[])leftRow.value().valueBytes(null), (byte[])rightRow.value().valueBytes(null));
            CacheMvccBackupsAbstractTest.assertEquals((Object)leftRow.version(), (Object)rightRow.version());
            CacheMvccBackupsAbstractTest.assertEquals((int)leftRow.cacheId(), (int)rightRow.cacheId());
            CacheMvccBackupsAbstractTest.assertEquals((int)leftRow.hash(), (int)rightRow.hash());
            CacheMvccBackupsAbstractTest.assertEquals((Object)leftRow.key(), (Object)rightRow.key());
            CacheMvccBackupsAbstractTest.assertTrue((MvccUtils.compare((MvccVersionAware)leftRow, (MvccVersion)rightRow.mvccVersion()) == 0 ? 1 : 0) != 0);
            CacheMvccBackupsAbstractTest.assertTrue((MvccUtils.compareNewVersion((MvccUpdateVersionAware)leftRow, (MvccVersion)rightRow.newMvccVersion()) == 0 ? 1 : 0) != 0);
            CacheMvccBackupsAbstractTest.assertEquals((long)leftRow.newMvccCoordinatorVersion(), (long)rightRow.newMvccCoordinatorVersion());
            CacheMvccBackupsAbstractTest.assertEquals((long)leftRow.newMvccCounter(), (long)rightRow.newMvccCounter());
            CacheMvccBackupsAbstractTest.assertEquals((int)leftRow.newMvccOperationCounter(), (int)rightRow.newMvccOperationCounter());
        }
    }

    private List getAll(IgniteCache cache, String tblName) {
        List res = cache.query(new SqlFieldsQuery("SELECT * FROM " + tblName)).getAll();
        Collections.sort(res, new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                List l1 = (List)o1;
                List l2 = (List)o2;
                int res = ((Comparable)l1.get(0)).compareTo((Comparable)l2.get(0));
                if (res == 0 && l1.size() > 1) {
                    return ((Comparable)l1.get(1)).compareTo((Comparable)l2.get(1));
                }
                return res;
            }
        });
        return res;
    }
}

