/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.index;

import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.UUID;
import javax.cache.CacheException;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteSystemProperties;
import org.apache.ignite.cache.QueryEntity;
import org.apache.ignite.cache.query.FieldsQueryCursor;
import org.apache.ignite.cache.query.QueryCursor;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.DataRegionConfiguration;
import org.apache.ignite.configuration.DataStorageConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class StaticCacheDdlTest
extends GridCommonAbstractTest {
    private static final String PERSISTENT_CACHE_NAME = "PERSISTENTCACHE";
    private static final String MEMORY_CACHE_NAME = "MEMORYCACHE";
    private static final String TABLE_NAME = "PERSONS";
    public static final String PERSISTENT_REGION_NAME = "PERSISTENT_REGION_NAME";
    public static final String MEMORY_REGION_NAME = "MEMORY_REGION_NAME";

    @Before
    public void clearPersistence() throws Exception {
        this.cleanPersistenceDir();
    }

    @After
    public void cleanup() throws Exception {
        this.cleanPersistenceDir();
    }

    protected boolean ignoreStaticConfig() {
        return !IgniteSystemProperties.getBoolean((String)"IGNITE_KEEP_STATIC_CACHE_CONFIGURATION");
    }

    @Test
    public void testAddColumn() throws Exception {
        String fieldName = "new_field";
        int size = 10;
        try (IgniteEx ignite = this.startGrid(0);){
            ignite.cluster().active(true);
            this.insertData((Ignite)ignite, PERSISTENT_CACHE_NAME, size);
            this.insertData((Ignite)ignite, MEMORY_CACHE_NAME, size);
            this.checkField((Ignite)ignite, PERSISTENT_CACHE_NAME, fieldName, false);
            this.checkField((Ignite)ignite, MEMORY_CACHE_NAME, fieldName, false);
            this.addColumn((Ignite)ignite, PERSISTENT_CACHE_NAME, fieldName);
            this.addColumn((Ignite)ignite, MEMORY_CACHE_NAME, fieldName);
            this.checkTableSize((Ignite)ignite, PERSISTENT_CACHE_NAME, size);
            this.checkTableSize((Ignite)ignite, MEMORY_CACHE_NAME, size);
            this.checkField((Ignite)ignite, PERSISTENT_CACHE_NAME, fieldName, this.ignoreStaticConfig());
            this.checkField((Ignite)ignite, MEMORY_CACHE_NAME, fieldName, true);
        }
        ignite = this.startGrid(0);
        var4_4 = null;
        try {
            this.checkTableSize((Ignite)ignite, PERSISTENT_CACHE_NAME, size);
            this.checkField((Ignite)ignite, PERSISTENT_CACHE_NAME, fieldName, this.ignoreStaticConfig());
        }
        catch (Throwable throwable) {
            var4_4 = throwable;
            throw throwable;
        }
        finally {
            if (ignite != null) {
                if (var4_4 != null) {
                    try {
                        ignite.close();
                    }
                    catch (Throwable throwable) {
                        var4_4.addSuppressed(throwable);
                    }
                } else {
                    ignite.close();
                }
            }
        }
    }

    @Test
    public void testDropColumn() throws Exception {
        String fieldName = "field_to_drop";
        int size = 10;
        try (IgniteEx ignite = this.startGrid(0);){
            ignite.cluster().active(true);
            this.insertData((Ignite)ignite, PERSISTENT_CACHE_NAME, size);
            this.insertData((Ignite)ignite, MEMORY_CACHE_NAME, size);
            this.checkField((Ignite)ignite, PERSISTENT_CACHE_NAME, fieldName, true);
            this.checkField((Ignite)ignite, MEMORY_CACHE_NAME, fieldName, true);
            this.dropColumn((Ignite)ignite, PERSISTENT_CACHE_NAME, fieldName);
            this.dropColumn((Ignite)ignite, MEMORY_CACHE_NAME, fieldName);
            this.checkField((Ignite)ignite, PERSISTENT_CACHE_NAME, fieldName, !this.ignoreStaticConfig());
            this.checkField((Ignite)ignite, MEMORY_CACHE_NAME, fieldName, false);
        }
        ignite = this.startGrid(0);
        var4_4 = null;
        try {
            this.checkField((Ignite)ignite, PERSISTENT_CACHE_NAME, fieldName, !this.ignoreStaticConfig());
        }
        catch (Throwable throwable) {
            var4_4 = throwable;
            throw throwable;
        }
        finally {
            if (ignite != null) {
                if (var4_4 != null) {
                    try {
                        ignite.close();
                    }
                    catch (Throwable throwable) {
                        var4_4.addSuppressed(throwable);
                    }
                } else {
                    ignite.close();
                }
            }
        }
    }

    @Test
    public void testAddIndex() throws Exception {
        String fieldName = "some_field";
        String idxName = "PERSONS_" + fieldName.toUpperCase() + "_IDX";
        int size = 10;
        try (IgniteEx ignite = this.startGrid(0);){
            ignite.cluster().active(true);
            this.insertData((Ignite)ignite, PERSISTENT_CACHE_NAME, size);
            this.insertData((Ignite)ignite, MEMORY_CACHE_NAME, size);
            this.checkIndex((Ignite)ignite, PERSISTENT_CACHE_NAME, idxName, fieldName, false);
            this.checkIndex((Ignite)ignite, MEMORY_CACHE_NAME, idxName, fieldName, false);
            this.addIndex((Ignite)ignite, PERSISTENT_CACHE_NAME, idxName, fieldName);
            this.addIndex((Ignite)ignite, MEMORY_CACHE_NAME, idxName, fieldName);
            this.checkIndex((Ignite)ignite, PERSISTENT_CACHE_NAME, idxName, fieldName, this.ignoreStaticConfig());
            this.checkIndex((Ignite)ignite, MEMORY_CACHE_NAME, idxName, fieldName, true);
        }
        ignite = this.startGrid(0);
        var5_5 = null;
        try {
            this.checkIndex((Ignite)ignite, PERSISTENT_CACHE_NAME, idxName, fieldName, this.ignoreStaticConfig());
        }
        catch (Throwable throwable) {
            var5_5 = throwable;
            throw throwable;
        }
        finally {
            if (ignite != null) {
                if (var5_5 != null) {
                    try {
                        ignite.close();
                    }
                    catch (Throwable throwable) {
                        var5_5.addSuppressed(throwable);
                    }
                } else {
                    ignite.close();
                }
            }
        }
    }

    private void checkIndex(Ignite ignite, String cacheName, String idxName, String fieldName, boolean shouldExist) {
        SqlFieldsQuery q = new SqlFieldsQuery("EXPLAIN SELECT * FROM " + cacheName + "." + TABLE_NAME + " WHERE " + fieldName + " = ?").setArgs(new Object[]{""});
        boolean exists = false;
        try (FieldsQueryCursor cursor = ignite.cache(cacheName).query(q);){
            for (List row : cursor) {
                if (!row.toString().contains(idxName)) continue;
                exists = true;
                break;
            }
        }
        Assert.assertEquals((String)("Check index (" + idxName + ") exists"), (Object)shouldExist, (Object)exists);
    }

    private void checkField(Ignite ignite, String cacheName, String fieldName, boolean shouldExist) {
        SqlFieldsQuery q = new SqlFieldsQuery("SELECT * FROM " + cacheName + "." + TABLE_NAME + " LIMIT 1 OFFSET 0");
        boolean exists = false;
        try (FieldsQueryCursor cursor = ignite.cache(cacheName).query(q);){
            this.consume((QueryCursor<List<?>>)cursor);
            int cols = cursor.getColumnsCount();
            for (int i = 0; i < cols; ++i) {
                if (!cursor.getFieldName(i).equals(fieldName.toUpperCase())) continue;
                exists = true;
                break;
            }
        }
        Assert.assertEquals((String)("Check field (" + fieldName + ") exists"), (Object)shouldExist, (Object)exists);
    }

    private void checkTableSize(Ignite ignite, String cacheName, int expSize) {
        SqlFieldsQuery q = new SqlFieldsQuery("SELECT * FROM " + cacheName + "." + TABLE_NAME);
        try (FieldsQueryCursor cursor = ignite.cache(cacheName).query(q);){
            int actualSize = 0;
            for (List ignore : cursor) {
                ++actualSize;
            }
            Assert.assertEquals((String)"Check result set size", (long)expSize, (long)actualSize);
        }
    }

    private void insertData(Ignite ignite, String cacheName, int size) {
        int rows = 0;
        for (int i = 0; i < size; ++i) {
            SqlFieldsQuery q = new SqlFieldsQuery("INSERT INTO " + cacheName + "." + TABLE_NAME + "(id, name) VALUES(?, ?)").setArgs(new Object[]{i, UUID.randomUUID().toString()});
            try (FieldsQueryCursor cursor = ignite.cache(cacheName).query(q);){
                for (List ignore : cursor) {
                    ++rows;
                }
                continue;
            }
        }
        this.info(rows + " rows processed");
    }

    private void addIndex(Ignite ignite, String cacheName, String idxName, String fieldName) {
        SqlFieldsQuery q = new SqlFieldsQuery("CREATE INDEX  " + idxName + " ON " + cacheName + "." + TABLE_NAME + "(" + fieldName + ")");
        try (FieldsQueryCursor cursor = ignite.cache(cacheName).query(q);){
            this.consume((QueryCursor<List<?>>)cursor);
        }
        catch (CacheException e) {
            StaticCacheDdlTest.assertTrue((String)("Unexpected exception: " + e.getMessage()), (cacheName.equalsIgnoreCase(PERSISTENT_CACHE_NAME) && !this.ignoreStaticConfig() ? 1 : 0) != 0);
        }
    }

    private void addColumn(Ignite ignite, String cacheName, String fieldName) {
        SqlFieldsQuery q = new SqlFieldsQuery("ALTER TABLE " + cacheName + "." + TABLE_NAME + " ADD COLUMN " + fieldName + " VARCHAR");
        try (FieldsQueryCursor cursor = ignite.cache(cacheName).query(q);){
            this.consume((QueryCursor<List<?>>)cursor);
        }
        catch (CacheException e) {
            StaticCacheDdlTest.assertTrue((String)("Unexpected exception: " + e.getMessage()), (cacheName.equalsIgnoreCase(PERSISTENT_CACHE_NAME) && !this.ignoreStaticConfig() ? 1 : 0) != 0);
        }
    }

    private void dropColumn(Ignite ignite, String cacheName, String fieldName) {
        SqlFieldsQuery q = new SqlFieldsQuery("ALTER TABLE " + cacheName + "." + TABLE_NAME + " DROP COLUMN " + fieldName);
        try (FieldsQueryCursor cursor = ignite.cache(cacheName).query(q);){
            this.consume((QueryCursor<List<?>>)cursor);
        }
        catch (CacheException e) {
            StaticCacheDdlTest.assertTrue((String)("Unexpected exception: " + e.getMessage()), (cacheName.equals(PERSISTENT_CACHE_NAME) && !this.ignoreStaticConfig() ? 1 : 0) != 0);
        }
    }

    private void consume(QueryCursor<List<?>> cur) {
        int rows = 0;
        for (List ignore : cur) {
            ++rows;
        }
        this.info(rows + " rows processed");
    }

    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(igniteInstanceName);
        DataStorageConfiguration dataStorageConfiguration = new DataStorageConfiguration();
        dataStorageConfiguration.setDefaultDataRegionConfiguration(new DataRegionConfiguration().setName(PERSISTENT_REGION_NAME).setInitialSize(0x6400000L).setMaxSize(0x40000000L).setPersistenceEnabled(true)).setDataRegionConfigurations(new DataRegionConfiguration[]{new DataRegionConfiguration().setName(MEMORY_REGION_NAME).setInitialSize(0x6400000L).setMaxSize(0x40000000L).setPersistenceEnabled(false)});
        dataStorageConfiguration.setCheckpointFrequency(5000L);
        return cfg.setCacheConfiguration(new CacheConfiguration[]{this.getCacheConfig(PERSISTENT_CACHE_NAME, PERSISTENT_REGION_NAME), this.getCacheConfig(MEMORY_CACHE_NAME, MEMORY_REGION_NAME)}).setDataStorageConfiguration(dataStorageConfiguration);
    }

    private CacheConfiguration getCacheConfig(String cacheName, String regionName) {
        HashSet<String> keyFields = new HashSet<String>(Collections.singletonList("id"));
        LinkedHashMap<String, String> fields = new LinkedHashMap<String, String>();
        fields.put("id", Integer.class.getName());
        fields.put("name", String.class.getName());
        fields.put("field_to_drop", String.class.getName());
        fields.put("some_field", String.class.getName());
        QueryEntity qryEntity = new QueryEntity().setTableName(TABLE_NAME).setKeyType("CUSTOM_SQL_KEY_TYPE").setValueType("CUSTOM_SQL_VALUE_TYPE").setKeyFields(keyFields).setFields(fields);
        return new CacheConfiguration(cacheName).setQueryEntities(Collections.singletonList(qryEntity)).setDataRegionName(regionName);
    }
}

