/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.index;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cache.affinity.AffinityFunction;
import org.apache.ignite.cache.affinity.rendezvous.RendezvousAffinityFunction;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.client.Person;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.processors.cache.CacheGroupContext;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.index.AbstractRebuildIndexTest;
import org.apache.ignite.internal.processors.cache.index.IgniteH2IndexingEx;
import org.apache.ignite.internal.processors.cache.index.IndexingTestUtils;
import org.apache.ignite.internal.processors.cache.persistence.CacheDataRow;
import org.apache.ignite.internal.processors.cache.persistence.RootPage;
import org.apache.ignite.internal.processors.cache.persistence.checkpoint.CheckpointListener;
import org.apache.ignite.internal.processors.query.QueryIndexDescriptorImpl;
import org.apache.ignite.internal.processors.query.QueryIndexKey;
import org.apache.ignite.internal.processors.query.aware.IndexBuildStatusHolder;
import org.apache.ignite.internal.processors.query.h2.DurableBackgroundCleanupIndexTreeTaskV2;
import org.apache.ignite.internal.processors.query.h2.database.H2Tree;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.apache.ignite.internal.util.lang.IgniteThrowableFunction;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.testframework.GridTestUtils;
import org.apache.ignite.testframework.junits.WithSystemProperty;
import org.junit.Test;

@WithSystemProperty(key="IGNITE_INDEX_REBUILD_BATCH_SIZE", value="1")
public class ResumeCreateIndexTest
extends AbstractRebuildIndexTest {
    private DurableBackgroundCleanupIndexTreeTaskV2.H2TreeFactory originalTaskIdxTreeFactory;

    @Override
    protected void beforeTest() throws Exception {
        super.beforeTest();
        this.originalTaskIdxTreeFactory = DurableBackgroundCleanupIndexTreeTaskV2.idxTreeFactory;
    }

    @Override
    protected void afterTest() throws Exception {
        super.afterTest();
        DurableBackgroundCleanupIndexTreeTaskV2.idxTreeFactory = this.originalTaskIdxTreeFactory;
    }

    @Override
    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        return super.getConfiguration(igniteInstanceName).setCacheConfiguration(new CacheConfiguration[]{this.cacheConfig("default"), this.cacheConfig("default2")});
    }

    private CacheConfiguration<Object, Object> cacheConfig(String cacheName) {
        return this.cacheCfg(cacheName, "GRP").setAffinity((AffinityFunction)new RendezvousAffinityFunction(false, 1));
    }

    @Test
    public void testGeneralFlow() throws Exception {
        String cacheName = "default";
        IgniteEx n = this.prepareNodeToCreateNewIndex(cacheName, 10, true);
        String idxName = "IDX0";
        IndexingTestUtils.SlowdownBuildIndexConsumer slowdownIdxCreateConsumer = this.addSlowdownIdxCreateConsumer(n, idxName, 0L);
        IgniteInternalFuture<List<List<?>>> createIdxFut = this.createIdxAsync((IgniteCache<Integer, Person>)n.cache(cacheName), idxName);
        slowdownIdxCreateConsumer.startBuildIdxFut.get(this.getTestTimeout());
        this.checkInitStatus(n, cacheName, false, 1);
        slowdownIdxCreateConsumer.finishBuildIdxFut.onDone();
        createIdxFut.get(this.getTestTimeout());
        this.checkCompletedStatus(n, cacheName);
        this.enableCheckpointsAsync(n, this.getTestIgniteInstanceName(), true).get(this.getTestTimeout());
        this.checkNoStatus(n, cacheName);
    }

    @Test
    public void testNoCheckpointAfterIndexCreation() throws Exception {
        String cacheName = "default";
        IgniteEx n = this.prepareNodeToCreateNewIndex(cacheName, 10, true);
        String idxName = "IDX0";
        IndexingTestUtils.SlowdownBuildIndexConsumer slowdownIdxCreateConsumer = this.addSlowdownIdxCreateConsumer(n, idxName, 0L);
        IgniteInternalFuture<List<List<?>>> createIdxFut = this.createIdxAsync((IgniteCache<Integer, Person>)n.cache(cacheName), idxName);
        slowdownIdxCreateConsumer.startBuildIdxFut.get(this.getTestTimeout());
        this.checkInitStatus(n, cacheName, false, 1);
        slowdownIdxCreateConsumer.finishBuildIdxFut.onDone();
        createIdxFut.get(this.getTestTimeout());
        this.checkCompletedStatus(n, cacheName);
        this.stopGrid(0);
        IgniteH2IndexingEx.prepareBeforeNodeStart();
        IndexingTestUtils.StopBuildIndexConsumer stopRebuildIdxConsumer = this.addStopRebuildIndexConsumer(n, cacheName);
        n = this.startGrid(0);
        stopRebuildIdxConsumer.startBuildIdxFut.get(this.getTestTimeout());
        IgniteInternalFuture idxRebFut = this.indexRebuildFuture(n, CU.cacheId((String)cacheName));
        ResumeCreateIndexTest.assertNotNull((Object)idxRebFut);
        this.checkInitStatus(n, cacheName, true, 0);
        ResumeCreateIndexTest.assertTrue((boolean)this.allIndexes(n).containsKey(new QueryIndexKey(cacheName, idxName)));
        stopRebuildIdxConsumer.finishBuildIdxFut.onDone();
        idxRebFut.get(this.getTestTimeout());
        this.forceCheckpoint();
        this.checkNoStatus(n, cacheName);
        ResumeCreateIndexTest.assertEquals((int)10, (int)this.selectPersonByName((IgniteCache<Integer, Person>)n.cache(cacheName)).size());
    }

    @Test
    public void testErrorFlow() throws Exception {
        String cacheName = "default";
        IgniteEx n = this.prepareNodeToCreateNewIndex(cacheName, 10, true);
        String idxName = "IDX0";
        IndexingTestUtils.BreakBuildIndexConsumer breakBuildIdxConsumer = this.addBreakIdxCreateConsumer(n, idxName, 1);
        IgniteInternalFuture<List<List<?>>> createIdxFut = this.createIdxAsync((IgniteCache<Integer, Person>)n.cache(cacheName), idxName);
        breakBuildIdxConsumer.startBuildIdxFut.get(this.getTestTimeout());
        this.checkInitStatus(n, cacheName, false, 1);
        breakBuildIdxConsumer.finishBuildIdxFut.onDone();
        GridTestUtils.assertThrows((IgniteLogger)log, () -> (List)createIdxFut.get(this.getTestTimeout()), IgniteCheckedException.class, null);
        this.checkCompletedStatus(n, cacheName);
        this.enableCheckpointsAsync(n, this.getTestIgniteInstanceName(), true).get(this.getTestTimeout());
        this.checkNoStatus(n, cacheName);
    }

    @Test
    public void testConcurrentBuildNewIndexAndRebuildIndexes0() throws Exception {
        String cacheName = "default";
        IgniteEx n = this.prepareNodeToCreateNewIndex(cacheName, 100000, true);
        String idxName = "IDX0";
        IndexingTestUtils.SlowdownBuildIndexConsumer slowdownIdxCreateConsumer = this.addSlowdownIdxCreateConsumer(n, idxName, 0L);
        IgniteInternalFuture<List<List<?>>> createIdxFut = this.createIdxAsync((IgniteCache<Integer, Person>)n.cache(cacheName), idxName);
        slowdownIdxCreateConsumer.startBuildIdxFut.get(this.getTestTimeout());
        this.checkInitStatus(n, cacheName, false, 1);
        IndexingTestUtils.SlowdownBuildIndexConsumer slowdownRebuildIdxConsumer = this.addSlowdownRebuildIndexConsumer(n, cacheName, 100L);
        ResumeCreateIndexTest.assertTrue((boolean)this.forceRebuildIndexes(n, new GridCacheContext[]{n.cachex(cacheName).context()}).isEmpty());
        this.checkInitStatus(n, cacheName, true, 1);
        IgniteInternalFuture idxRebFut = this.indexRebuildFuture(n, CU.cacheId((String)cacheName));
        ResumeCreateIndexTest.assertNotNull((Object)idxRebFut);
        slowdownIdxCreateConsumer.finishBuildIdxFut.onDone();
        slowdownRebuildIdxConsumer.startBuildIdxFut.get(this.getTestTimeout());
        slowdownRebuildIdxConsumer.finishBuildIdxFut.onDone();
        createIdxFut.get(this.getTestTimeout());
        ResumeCreateIndexTest.assertFalse((boolean)idxRebFut.isDone());
        this.checkInitStatus(n, cacheName, true, 0);
        slowdownRebuildIdxConsumer.sleepTime.set(0L);
        idxRebFut.get(this.getTestTimeout());
        this.checkCompletedStatus(n, cacheName);
        this.enableCheckpointsAsync(n, this.getTestIgniteInstanceName(), true).get(this.getTestTimeout());
        this.checkNoStatus(n, cacheName);
    }

    @Test
    public void testConcurrentBuildNewIndexAndRebuildIndexes1() throws Exception {
        String cacheName = "default";
        IgniteEx n = this.prepareNodeToCreateNewIndex(cacheName, 100000, true);
        IndexingTestUtils.SlowdownBuildIndexConsumer slowdownRebuildIdxConsumer = this.addSlowdownRebuildIndexConsumer(n, cacheName, 10L);
        ResumeCreateIndexTest.assertTrue((boolean)this.forceRebuildIndexes(n, new GridCacheContext[]{n.cachex(cacheName).context()}).isEmpty());
        this.checkInitStatus(n, cacheName, true, 0);
        slowdownRebuildIdxConsumer.startBuildIdxFut.get(this.getTestTimeout());
        IgniteInternalFuture idxRebFut = this.indexRebuildFuture(n, CU.cacheId((String)cacheName));
        ResumeCreateIndexTest.assertNotNull((Object)idxRebFut);
        String idxName = "IDX0";
        IndexingTestUtils.SlowdownBuildIndexConsumer slowdownIdxCreateConsumer = this.addSlowdownIdxCreateConsumer(n, idxName, 100L);
        IgniteInternalFuture<List<List<?>>> createIdxFut = this.createIdxAsync((IgniteCache<Integer, Person>)n.cache(cacheName), idxName);
        slowdownRebuildIdxConsumer.finishBuildIdxFut.onDone();
        slowdownIdxCreateConsumer.startBuildIdxFut.get(this.getTestTimeout());
        this.checkInitStatus(n, cacheName, true, 1);
        slowdownIdxCreateConsumer.finishBuildIdxFut.onDone();
        slowdownRebuildIdxConsumer.sleepTime.set(0L);
        idxRebFut.get(this.getTestTimeout());
        this.checkInitStatus(n, cacheName, false, 1);
        slowdownIdxCreateConsumer.sleepTime.set(0L);
        createIdxFut.get(this.getTestTimeout());
        this.checkCompletedStatus(n, cacheName);
        this.enableCheckpointsAsync(n, this.getTestIgniteInstanceName(), true).get(this.getTestTimeout());
        this.checkNoStatus(n, cacheName);
    }

    @Test
    public void testPartialCheckpointNewIndexRows() throws Exception {
        String cacheName = "default";
        IgniteEx n = this.prepareNodeToCreateNewIndex(cacheName, 100000, false);
        String idxName = "IDX0";
        IndexingTestUtils.SlowdownBuildIndexConsumer slowdownIdxCreateConsumer = this.addSlowdownIdxCreateConsumer(n, idxName, 10L);
        IgniteInternalFuture<List<List<?>>> createIdxFut = this.createIdxAsync((IgniteCache<Integer, Person>)n.cache(cacheName), idxName);
        slowdownIdxCreateConsumer.startBuildIdxFut.get(this.getTestTimeout());
        this.checkInitStatus(n, cacheName, false, 1);
        String reason = this.getTestIgniteInstanceName();
        IgniteInternalFuture<Void> awaitBeforeCpBeginFut = this.awaitBeforeCheckpointBeginAsync(n, reason);
        IgniteInternalFuture<Void> disableCpFut = this.enableCheckpointsAsync(n, reason, false);
        awaitBeforeCpBeginFut.get(this.getTestTimeout());
        slowdownIdxCreateConsumer.finishBuildIdxFut.onDone();
        disableCpFut.get(this.getTestTimeout());
        slowdownIdxCreateConsumer.sleepTime.set(0L);
        createIdxFut.get(this.getTestTimeout());
        this.checkCompletedStatus(n, cacheName);
        this.stopGrid(0);
        IgniteH2IndexingEx.prepareBeforeNodeStart();
        IndexingTestUtils.StopBuildIndexConsumer stopRebuildIdxConsumer = this.addStopRebuildIndexConsumer(n, cacheName);
        n = this.startGrid(0);
        stopRebuildIdxConsumer.startBuildIdxFut.get(this.getTestTimeout());
        IgniteInternalFuture rebIdxFut = this.indexRebuildFuture(n, CU.cacheId((String)cacheName));
        ResumeCreateIndexTest.assertNotNull((Object)rebIdxFut);
        this.checkInitStatus(n, cacheName, true, 0);
        ResumeCreateIndexTest.assertTrue((boolean)this.allIndexes(n).containsKey(new QueryIndexKey(cacheName, idxName)));
        stopRebuildIdxConsumer.finishBuildIdxFut.onDone();
        rebIdxFut.get(this.getTestTimeout());
        this.forceCheckpoint();
        this.checkNoStatus(n, cacheName);
        ResumeCreateIndexTest.assertEquals((int)100000, (int)this.selectPersonByName((IgniteCache<Integer, Person>)n.cache(cacheName)).size());
    }

    @Test
    public void testIncompleteIndexDroppedOnCacheDestroy() throws Exception {
        String cacheName = "default";
        int cacheSize = 10000;
        IgniteEx n = this.prepareNodeToCreateNewIndex("default", 10000, false);
        this.populate((IgniteCache<Integer, Person>)n.cache("default2"), 1);
        IgniteEx cli = this.startClientGrid(1);
        String idxName = "IDX0";
        FailBuildIndexConsumer failBuildIndexConsumer = new FailBuildIndexConsumer(this.getTestTimeout(), 1000);
        IgniteH2IndexingEx.addIdxCreateCacheRowConsumer(IndexingTestUtils.nodeName(n), idxName, failBuildIndexConsumer);
        IgniteInternalFuture<List<List<?>>> createIdxFut = this.createIdxAsync((IgniteCache<Integer, Person>)cli.cache("default"), idxName);
        GridFutureAdapter startCleanupFut = new GridFutureAdapter();
        DurableBackgroundCleanupIndexTreeTaskV2.idxTreeFactory = this.treeFactory(idxName, (GridFutureAdapter<Object>)startCleanupFut);
        failBuildIndexConsumer.startBuildIdxFut.get(this.getTestTimeout());
        this.checkInitStatus(n, "default", false, 1);
        failBuildIndexConsumer.finishBuildIdxFut.onDone();
        cli.cache("default").destroy();
        ResumeCreateIndexTest.assertTrue((boolean)createIdxFut.isDone());
        startCleanupFut.get(this.getTestTimeout());
        cli.createCache(this.cacheConfig("default"));
        this.populate((IgniteCache<Integer, Person>)n.cache("default"), 10000);
        this.checkCompletedStatus(n, "default");
        IndexingTestUtils.SlowdownBuildIndexConsumer slowdownBuildIndexConsumer = this.addSlowdownIdxCreateConsumer(n, idxName, 0L);
        createIdxFut = this.createIdxAsync((IgniteCache<Integer, Person>)cli.cache("default"), idxName);
        slowdownBuildIndexConsumer.startBuildIdxFut.get(this.getTestTimeout());
        this.checkInitStatus(n, "default", false, 1);
        slowdownBuildIndexConsumer.finishBuildIdxFut.onDone();
        createIdxFut.get(this.getTestTimeout());
        this.checkCompletedStatus(n, "default");
        ResumeCreateIndexTest.assertTrue((boolean)this.allIndexes(n).containsKey(new QueryIndexKey("default", idxName)));
        ResumeCreateIndexTest.assertEquals((int)10000, (int)this.selectPersonByName((IgniteCache<Integer, Person>)n.cache("default")).size());
    }

    private DurableBackgroundCleanupIndexTreeTaskV2.H2TreeFactory treeFactory(final String indexName, final GridFutureAdapter<Object> startFut) {
        return new DurableBackgroundCleanupIndexTreeTaskV2.H2TreeFactory(){

            protected H2Tree create(CacheGroupContext grpCtx, RootPage rootPage, String treeName, String idxName, String cacheName) throws IgniteCheckedException {
                if (indexName.equals(idxName)) {
                    startFut.onDone();
                }
                return super.create(grpCtx, rootPage, treeName, idxName, cacheName);
            }
        };
    }

    private IgniteInternalFuture<List<List<?>>> createIdxAsync(IgniteCache<Integer, Person> cache, String idxName) {
        return GridTestUtils.runAsync(() -> this.createIdx(cache, idxName));
    }

    private IgniteInternalFuture<Void> enableCheckpointsAsync(IgniteEx n, String reason, boolean enable) {
        return GridTestUtils.runAsync(() -> this.enableCheckpoints(n, reason, enable));
    }

    private IgniteInternalFuture<Void> awaitBeforeCheckpointBeginAsync(IgniteEx n, final String reason) {
        final GridFutureAdapter fut = new GridFutureAdapter();
        this.dbMgr(n).addCheckpointListener(new CheckpointListener(){

            public void onMarkCheckpointBegin(CheckpointListener.Context ctx) {
            }

            public void onCheckpointBegin(CheckpointListener.Context ctx) {
            }

            public void beforeCheckpointBegin(CheckpointListener.Context ctx) {
                if (reason.equals(ctx.progress().reason())) {
                    fut.onDone();
                }
            }
        });
        return fut;
    }

    private Map<QueryIndexKey, QueryIndexDescriptorImpl> allIndexes(IgniteEx n) {
        return (Map)GridTestUtils.getFieldValue((Object)n.context().query(), (String[])new String[]{"idxs"});
    }

    private List<List<?>> selectPersonByName(IgniteCache<Integer, Person> cache) {
        return cache.query(new SqlFieldsQuery("SELECT * FROM Person where name LIKE 'name_%';")).getAll();
    }

    private void checkStatus(IndexBuildStatusHolder status, IndexBuildStatusHolder.Status expStatus, boolean expPersistent, boolean expRebuild, int expNewIdx) {
        ResumeCreateIndexTest.assertEquals((Object)expStatus, (Object)status.status());
        ResumeCreateIndexTest.assertEquals((boolean)expPersistent, (boolean)status.persistent());
        ResumeCreateIndexTest.assertEquals((boolean)expRebuild, (boolean)status.rebuild());
        ResumeCreateIndexTest.assertEquals((int)expNewIdx, (int)status.buildNewIndexes());
    }

    private IgniteEx prepareNodeToCreateNewIndex(String cacheName, int cnt, boolean disableCp) throws Exception {
        IgniteH2IndexingEx.prepareBeforeNodeStart();
        IgniteEx n = this.startGrid(0);
        this.populate((IgniteCache<Integer, Person>)n.cache(cacheName), cnt);
        if (disableCp) {
            this.enableCheckpointsAsync(n, this.getTestIgniteInstanceName(), false).get(this.getTestTimeout());
        }
        return n;
    }

    private void checkInitStatus(IgniteEx n, String cacheName, boolean expRebuild, int expNewIdx) throws Exception {
        this.checkStatus((IndexBuildStatusHolder)this.statuses(n).get(cacheName), IndexBuildStatusHolder.Status.INIT, true, expRebuild, expNewIdx);
        ResumeCreateIndexTest.assertNotNull((Object)this.metaStorageOperation(n, (IgniteThrowableFunction & Serializable)metaStorage -> metaStorage.read("rebuild-sql-indexes-" + cacheName)));
        ResumeCreateIndexTest.assertEquals((!expRebuild ? 1 : 0) != 0, (boolean)this.indexBuildStatusStorage(n).rebuildCompleted(cacheName));
    }

    private void checkCompletedStatus(IgniteEx n, String cacheName) throws Exception {
        this.checkStatus((IndexBuildStatusHolder)this.statuses(n).get(cacheName), IndexBuildStatusHolder.Status.COMPLETE, true, false, 0);
        ResumeCreateIndexTest.assertNotNull((Object)this.metaStorageOperation(n, (IgniteThrowableFunction & Serializable)metaStorage -> metaStorage.read("rebuild-sql-indexes-" + cacheName)));
        ResumeCreateIndexTest.assertTrue((boolean)this.indexBuildStatusStorage(n).rebuildCompleted(cacheName));
    }

    private void checkNoStatus(IgniteEx n, String cacheName) throws Exception {
        ResumeCreateIndexTest.assertNull(this.statuses(n).get(cacheName));
        ResumeCreateIndexTest.assertNull((Object)this.metaStorageOperation(n, (IgniteThrowableFunction & Serializable)metaStorage -> metaStorage.read("rebuild-sql-indexes-" + cacheName)));
        ResumeCreateIndexTest.assertTrue((boolean)this.indexBuildStatusStorage(n).rebuildCompleted(cacheName));
    }

    static class FailBuildIndexConsumer
    extends IndexingTestUtils.StopBuildIndexConsumer {
        private final int cnt;

        FailBuildIndexConsumer(long timeout, int cnt) {
            super(timeout);
            this.cnt = cnt;
        }

        @Override
        public void accept(CacheDataRow row) throws IgniteCheckedException {
            if (this.visitCnt.incrementAndGet() < (long)this.cnt) {
                return;
            }
            this.startBuildIdxFut.onDone();
            this.finishBuildIdxFut.get(this.timeout);
            throw new IgniteCheckedException("test");
        }
    }
}

