/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.index;

import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.cache.CacheKeyConfiguration;
import org.apache.ignite.cache.QueryEntity;
import org.apache.ignite.cache.QueryIndex;
import org.apache.ignite.cache.affinity.AffinityKeyMapped;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.processors.cache.index.AbstractIndexingCommonTest;
import org.apache.ignite.testframework.GridTestUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class PojoIndexLocalQueryTest
extends AbstractIndexingCommonTest {
    private static final int DATSET_SIZE = 1000;
    private static final AtomicInteger TBL_ID = new AtomicInteger();
    private static final String SELECT_ORDERED_RANGE_TEMPLATE = "SELECT val FROM \"%s\" USE INDEX(\"%s\") WHERE %s <= ? ORDER BY idxVal ASC";
    private static final String SELECT_VALUE_TEMPLATE = "SELECT val, idxVal FROM \"%s\" USE INDEX(\"%s\") WHERE %s = ?";
    private int maxStrLen;

    protected void beforeTestsStarted() throws Exception {
        super.beforeTestsStarted();
        this.startGrid(0);
    }

    @Before
    public void clearState() {
        this.maxStrLen = 40;
    }

    @Test
    public void testJavaPojoIndexLocal() {
        this.createPopulateAndVerify(TestPojo.class, null, null);
        this.createPopulateAndVerify(TestPojo.class, null, TestKeyWithAff.class);
        this.createPopulateAndVerify(TestPojo.class, null, TestKeyWithIdx.class);
    }

    @Test
    public void localPojoReproducerTest() {
        String tblName = TestPojo.class.getSimpleName().toUpperCase() + "_TBL" + TBL_ID.incrementAndGet();
        Class<TestKeyWithIdx> keyCls = TestKeyWithIdx.class;
        Class<TestPojo> idxCls = TestPojo.class;
        LinkedHashMap<String, String> fields = new LinkedHashMap<String, String>(2);
        fields.put("idxVal", idxCls.getName());
        fields.put("val", Integer.class.getName());
        QueryEntity qe = new QueryEntity(keyCls.getName(), Integer.class.getName()).setTableName(tblName).setValueFieldName("val").setFields(fields);
        String idxName = "IDXVAL_IDX";
        String idxFieldName = "idxVal";
        qe.setKeyFields(Collections.singleton(idxFieldName));
        qe.setIndexes(Collections.singleton(new QueryIndex(idxFieldName, true, idxName)));
        IgniteCache cache = this.grid(0).createCache(new CacheConfiguration(tblName + "_CACHE").setKeyConfiguration(new CacheKeyConfiguration[]{new CacheKeyConfiguration(TestKeyWithIdx.class.getName(), "idxVal")}).setQueryEntities(Collections.singletonList(qe)).setSqlSchema("PUBLIC"));
        int[] a1 = new int[]{-903, 141, 202};
        int[] b1 = new int[]{-876, 765, -192};
        int[] c1 = new int[]{-726, 109, -182};
        TestPojo pojo1 = new TestPojo(b1[0]);
        TestPojo pojo2 = new TestPojo(b1[1]);
        TestPojo pojo3 = new TestPojo(b1[2]);
        TestKeyWithIdx<TestPojo> idx1 = new TestKeyWithIdx<TestPojo>(a1[0], pojo1);
        TestKeyWithIdx<TestPojo> idx2 = new TestKeyWithIdx<TestPojo>(a1[1], pojo2);
        TestKeyWithIdx<TestPojo> idx3 = new TestKeyWithIdx<TestPojo>(a1[2], pojo3);
        cache.put(idx1, (Object)c1[0]);
        cache.put(idx2, (Object)c1[1]);
        cache.put(idx3, (Object)c1[2]);
        String format = String.format(SELECT_VALUE_TEMPLATE, tblName, idxName, idxFieldName);
        List sqlRes = this.grid(0).context().query().querySqlFields(new SqlFieldsQuery(format).setArgs(new Object[]{pojo3}).setLocal(true), false).getAll();
        PojoIndexLocalQueryTest.assertEquals((int)1, (int)sqlRes.size());
        Integer val = (Integer)cache.get(idx3);
        PojoIndexLocalQueryTest.assertEquals((Object)val, ((List)sqlRes.get(0)).get(0));
        this.grid(0).destroyCache(tblName + "_CACHE");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <Key extends ClassWrapper, Idx> void createPopulateAndVerify(Class<Idx> idxCls, @Nullable Comparator<Idx> comp, @Nullable Class<Key> keyCls) {
        IgniteEx ign = this.grid(0);
        String tblName = idxCls.getSimpleName().toUpperCase() + "_TBL" + TBL_ID.incrementAndGet();
        try {
            String idxFieldName;
            String idxName;
            LinkedHashMap<String, String> fields = new LinkedHashMap<String, String>(2);
            fields.put("idxVal", idxCls.getName());
            fields.put("val", Integer.class.getName());
            QueryEntity qe = new QueryEntity(keyCls == null ? idxCls.getName() : keyCls.getName(), Integer.class.getName()).setTableName(tblName).setValueFieldName("val").setFields(fields);
            if (keyCls == null) {
                qe.setKeyFieldName("idxVal");
                idxName = "_key_PK";
                idxFieldName = "_KEY";
            } else {
                idxFieldName = "idxVal";
                qe.setKeyFields(Collections.singleton(idxFieldName));
                if (keyCls.equals(TestKeyWithAff.class)) {
                    idxName = "AFFINITY_KEY";
                } else {
                    idxName = "IDXVAL_IDX";
                    qe.setIndexes(Collections.singleton(new QueryIndex(idxFieldName, true, idxName)));
                }
            }
            IgniteCache cache = ign.createCache(new CacheConfiguration(tblName + "_CACHE").setKeyConfiguration(new CacheKeyConfiguration[]{new CacheKeyConfiguration((keyCls != null ? keyCls : idxCls).getName(), "idxVal")}).setQueryEntities(Collections.singletonList(qe)).setSqlSchema("PUBLIC"));
            TreeMap data = new TreeMap(comp);
            if (keyCls == null) {
                this.populateTable(data, (IgniteCache<Object, Integer>)cache, idxCls);
            } else {
                this.populateTable(data, (IgniteCache<Object, Integer>)cache, keyCls, idxCls);
            }
            if (comp != null) {
                this.verifyRange(data, tblName, idxFieldName, idxName, comp);
            }
            this.verifyEach(data, tblName, idxFieldName, idxName);
        }
        finally {
            ign.destroyCache(tblName + "_CACHE");
        }
    }

    private <Key, Idx> void populateTable(Map<Idx, Integer> data, IgniteCache<Object, Integer> cache, Class<Key> keyCls, Class<Idx> idxCls) {
        HashMap<Idx, Key> idxToKey = new HashMap<Idx, Key>();
        for (int i = 0; i < 1000; ++i) {
            Key key = this.nextVal(keyCls, idxCls);
            int val = this.nextVal(Integer.class, null);
            try {
                Field f = keyCls.getDeclaredField("idxVal");
                f.setAccessible(true);
                Idx idx = idxCls.cast(f.get(key));
                Key old = idxToKey.put(idx, key);
                if (old != null) {
                    cache.remove(old);
                }
                data.put(idx, val);
                cache.put(key, (Object)val);
                continue;
            }
            catch (Exception ex) {
                PojoIndexLocalQueryTest.fail((String)("Unable to populate table: " + ex));
            }
        }
    }

    private <T> void populateTable(Map<T, Integer> data, IgniteCache<Object, Integer> cache, Class<T> keyCls) {
        for (int i = 0; i < 1000; ++i) {
            T key = this.nextVal(keyCls, null);
            int val = this.nextVal(Integer.class, null);
            data.put(key, val);
            cache.put(key, (Object)val);
        }
    }

    private <T, InnerT> T nextVal(Class<T> cls, @Nullable Class<InnerT> innerCls) {
        if (cls.isAssignableFrom(Boolean.class)) {
            return cls.cast(ThreadLocalRandom.current().nextBoolean());
        }
        if (cls.isAssignableFrom(Byte.class)) {
            return cls.cast((byte)ThreadLocalRandom.current().nextInt());
        }
        if (cls.isAssignableFrom(Short.class)) {
            return cls.cast((short)ThreadLocalRandom.current().nextInt());
        }
        if (cls.isAssignableFrom(Integer.class)) {
            return cls.cast(ThreadLocalRandom.current().nextInt());
        }
        if (cls.isAssignableFrom(Long.class)) {
            return cls.cast(ThreadLocalRandom.current().nextLong());
        }
        if (cls.isAssignableFrom(Float.class)) {
            return cls.cast(Float.valueOf(ThreadLocalRandom.current().nextFloat()));
        }
        if (cls.isAssignableFrom(Double.class)) {
            return cls.cast(ThreadLocalRandom.current().nextDouble());
        }
        if (cls.isAssignableFrom(BigDecimal.class)) {
            return cls.cast(new BigDecimal(ThreadLocalRandom.current().nextDouble()));
        }
        if (cls.isAssignableFrom(String.class)) {
            return cls.cast(GridTestUtils.randomString((Random)ThreadLocalRandom.current(), (int)1, (int)this.maxStrLen));
        }
        if (cls.isAssignableFrom(UUID.class)) {
            return cls.cast(new UUID(ThreadLocalRandom.current().nextLong(), ThreadLocalRandom.current().nextLong()));
        }
        if (cls.isAssignableFrom(TestPojo.class)) {
            return cls.cast(new TestPojo(ThreadLocalRandom.current().nextInt()));
        }
        if (cls.isAssignableFrom(TestKeyWithIdx.class)) {
            return cls.cast(new TestKeyWithIdx<Object>(ThreadLocalRandom.current().nextInt(), (innerCls != null ? (Object)this.nextVal(innerCls, null) : null)));
        }
        if (cls.isAssignableFrom(TestKeyWithAff.class)) {
            return cls.cast(new TestKeyWithAff<Object>(ThreadLocalRandom.current().nextInt(), (innerCls != null ? (Object)this.nextVal(innerCls, null) : null)));
        }
        throw new IllegalStateException("There is no generator for class=" + cls.getSimpleName());
    }

    private <T> void verifyRange(Map<T, Integer> data, String tblName, String idxFieldName, String idxName, Comparator<T> comp) {
        Object val = this.getRandom(data.keySet());
        List<List<?>> res = this.execSql(String.format(SELECT_ORDERED_RANGE_TEMPLATE, tblName, idxName, idxFieldName), val);
        List exp = data.entrySet().stream().filter(e -> comp.compare(e.getKey(), val) <= 0).sorted((e1, e2) -> comp.compare(e1.getKey(), e2.getKey())).map(Map.Entry::getValue).collect(Collectors.toList());
        List act = res.stream().flatMap(Collection::stream).map(e -> (Integer)e).collect(Collectors.toList());
        Assert.assertEquals(exp, act);
    }

    private <T> void verifyEach(Map<T, Integer> data, String tblName, String idxFieldName, String idxName) {
        for (Map.Entry<T, Integer> entry : data.entrySet()) {
            List<List<?>> res = this.execSql(String.format(SELECT_VALUE_TEMPLATE, tblName, idxName, idxFieldName), entry.getKey());
            Assert.assertFalse((String)"Result should not be empty", (boolean)res.isEmpty());
            Assert.assertFalse((String)"Result should contain at least one column", (boolean)res.get(0).isEmpty());
            Assert.assertEquals((Object)entry.getValue(), res.get(0).get(0));
        }
    }

    private <T> T getRandom(Collection<T> col) {
        int rndIdx = ThreadLocalRandom.current().nextInt(col.size());
        int i = 0;
        for (T el : col) {
            if (i++ != rndIdx) continue;
            return el;
        }
        return null;
    }

    private List<List<?>> execSql(String qry, Object ... args) {
        return this.grid(0).context().query().querySqlFields(new SqlFieldsQuery(qry).setArgs(args).setLocal(true), false).getAll();
    }

    static class TestKeyWithIdx<T>
    implements ClassWrapper {
        private final int val;
        private final T idxVal;

        public TestKeyWithIdx(int val, T idxVal) {
            this.val = val;
            this.idxVal = idxVal;
        }
    }

    static class TestKeyWithAff<T>
    implements ClassWrapper {
        private final int val;
        @AffinityKeyMapped
        private final T idxVal;

        public TestKeyWithAff(int val, T idxVal) {
            this.val = val;
            this.idxVal = idxVal;
        }
    }

    static interface ClassWrapper {
    }

    static class TestPojo
    implements Comparable<TestPojo> {
        private final int val;

        public TestPojo(int val) {
            this.val = val;
        }

        @Override
        public int compareTo(@NotNull TestPojo o) {
            if (o == null) {
                return 1;
            }
            return Integer.compare(this.val, o.val);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TestPojo pojo = (TestPojo)o;
            return this.val == pojo.val;
        }

        public int hashCode() {
            return Objects.hash(this.val);
        }
    }
}

