/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.index;

import java.io.Serializable;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.persistence.CacheDataRow;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.apache.ignite.internal.util.lang.IgniteThrowableBiPredicate;
import org.apache.ignite.internal.util.lang.IgniteThrowableConsumer;
import org.apache.ignite.internal.util.typedef.internal.U;

class IndexingTestUtils {
    static final IgniteThrowableConsumer<CacheDataRow> DO_NOTHING_CACHE_DATA_ROW_CONSUMER = (IgniteThrowableConsumer & Serializable)row -> {};
    static final Runnable DO_NOTHING = () -> {};

    private IndexingTestUtils() {
    }

    static String nodeName(GridKernalContext kernalCtx) {
        return kernalCtx.igniteInstanceName();
    }

    static String nodeName(IgniteEx n) {
        return IndexingTestUtils.nodeName(n.context());
    }

    static String nodeName(GridCacheContext cacheCtx) {
        return IndexingTestUtils.nodeName(cacheCtx.kernalContext());
    }

    static class BreakBuildIndexConsumer
    extends StopBuildIndexConsumer {
        final IgniteThrowableBiPredicate<BreakBuildIndexConsumer, CacheDataRow> brakePred;

        BreakBuildIndexConsumer(long timeout, IgniteThrowableBiPredicate<BreakBuildIndexConsumer, CacheDataRow> brakePred) {
            super(timeout);
            this.brakePred = brakePred;
        }

        @Override
        public void accept(CacheDataRow row) throws IgniteCheckedException {
            super.accept(row);
            if (this.brakePred.test((Object)this, (Object)row)) {
                throw new IgniteCheckedException("From test.");
            }
        }
    }

    static class SlowdownBuildIndexConsumer
    extends StopBuildIndexConsumer {
        final AtomicLong sleepTime;

        SlowdownBuildIndexConsumer(long timeout, long sleepTime) {
            super(timeout);
            this.sleepTime = new AtomicLong(sleepTime);
        }

        @Override
        public void accept(CacheDataRow row) throws IgniteCheckedException {
            super.accept(row);
            long sleepTime = this.sleepTime.get();
            if (sleepTime > 0L) {
                U.sleep((long)sleepTime);
            }
        }
    }

    static class StopBuildIndexConsumer
    implements IgniteThrowableConsumer<CacheDataRow> {
        final GridFutureAdapter<Void> startBuildIdxFut = new GridFutureAdapter();
        final GridFutureAdapter<Void> finishBuildIdxFut = new GridFutureAdapter();
        final AtomicLong visitCnt = new AtomicLong();
        final long timeout;

        StopBuildIndexConsumer(long timeout) {
            this.timeout = timeout;
        }

        public void accept(CacheDataRow row) throws IgniteCheckedException {
            this.startBuildIdxFut.onDone();
            this.visitCnt.incrementAndGet();
            this.finishBuildIdxFut.get(this.timeout);
        }

        void resetFutures() {
            this.startBuildIdxFut.reset();
            this.finishBuildIdxFut.reset();
        }
    }
}

