/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.index;

import java.util.ArrayList;
import java.util.Collection;
import javax.cache.CacheException;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.Ignition;
import org.apache.ignite.client.Person;
import org.apache.ignite.cluster.ClusterState;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.DataRegionConfiguration;
import org.apache.ignite.configuration.DataStorageConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.failure.FailureHandler;
import org.apache.ignite.failure.StopNodeFailureHandler;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.processors.cache.index.AbstractIndexingCommonTest;
import org.apache.ignite.internal.processors.query.schema.SchemaOperationException;
import org.apache.ignite.internal.util.typedef.X;
import org.apache.ignite.spi.discovery.DiscoverySpi;
import org.apache.ignite.spi.discovery.tcp.TcpDiscoverySpi;
import org.apache.ignite.spi.discovery.tcp.ipfinder.TcpDiscoveryIpFinder;
import org.apache.ignite.testframework.GridTestUtils;
import org.apache.ignite.testframework.junits.WithSystemProperty;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@WithSystemProperty(key="IGNITE_SKIP_CONFIGURATION_CONSISTENCY_CHECK", value="true")
public class ErroneousQueryEntityConfigurationTest
extends AbstractIndexingCommonTest {
    private static final String CLIENT_NAME = "client";
    @Parameterized.Parameter
    public Boolean persistent;

    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        IgniteConfiguration igniteCfg = super.getConfiguration(igniteInstanceName);
        if (this.persistent.booleanValue()) {
            igniteCfg.setDataStorageConfiguration(new DataStorageConfiguration().setDefaultDataRegionConfiguration(new DataRegionConfiguration().setPersistenceEnabled(true).setMaxSize(0xA00000L)));
        }
        return igniteCfg.setFailureHandler((FailureHandler)new StopNodeFailureHandler());
    }

    protected void beforeTest() throws Exception {
        super.beforeTest();
        this.stopAllGrids();
        this.cleanPersistenceDir();
    }

    protected void afterTest() throws Exception {
        this.stopAllGrids();
        this.cleanPersistenceDir();
        super.afterTest();
    }

    @Parameterized.Parameters(name="persistent = {0}")
    public static Collection<Object[]> testData() {
        ArrayList<Object[]> res = new ArrayList<Object[]>();
        res.add(new Object[]{true});
        res.add(new Object[]{false});
        return res;
    }

    @Test
    public void testErroneousCacheConfigFromClientNode() throws Exception {
        IgniteEx ignite = this.startGrid("srv1");
        TcpDiscoverySpi discoConf = (TcpDiscoverySpi)ignite.configuration().getDiscoverySpi();
        TcpDiscoveryIpFinder ipFinder = discoConf.getIpFinder();
        GridTestUtils.assertThrows((IgniteLogger)log, () -> {
            Ignite client = Ignition.start((IgniteConfiguration)this.getErroneousConfiguration(ipFinder, false));
            client.cluster().state(ClusterState.ACTIVE);
        }, IgniteException.class, (String)"Duplicate index name");
        Ignite client = Ignition.start((IgniteConfiguration)this.getErroneousConfiguration(ipFinder, true));
        client.cluster().state(ClusterState.ACTIVE);
        this.stopGrid("srv1");
        if (this.persistent.booleanValue()) {
            this.startGrid("srv1");
        }
    }

    @Test
    public void teststartErroneousCacheConfigThroughDynamicCaches() throws Exception {
        IgniteEx server = this.startGrid();
        IgniteEx client = this.startGrid(CLIENT_NAME);
        Collection<CacheConfiguration> ccfgs = ErroneousQueryEntityConfigurationTest.makeMultipleCachesConfig(false);
        client.cluster().state(ClusterState.ACTIVE);
        CacheException th = (CacheException)GridTestUtils.assertThrows((IgniteLogger)log, () -> client.getOrCreateCaches(ccfgs), CacheException.class, null);
        SchemaOperationException e = (SchemaOperationException)X.cause((Throwable)th, SchemaOperationException.class);
        ErroneousQueryEntityConfigurationTest.assertEquals((int)3, (int)e.code());
        server.cluster().state(ClusterState.ACTIVE);
    }

    @Test
    public void testEqualIndexAreConfiguredOnServerAndJoinedNode() throws Exception {
        IgniteEx server = this.startGrid("srv1");
        TcpDiscoverySpi discoConf = (TcpDiscoverySpi)server.configuration().getDiscoverySpi();
        TcpDiscoveryIpFinder ipFinder = discoConf.getIpFinder();
        IgniteConfiguration cfg = this.getErroneousConfiguration(ipFinder, false);
        CacheConfiguration[] ccfgs = cfg.getCacheConfiguration();
        cfg.setCacheConfiguration(new CacheConfiguration[]{ccfgs[0], ccfgs[1]});
        cfg.setClientMode(false);
        cfg.setIgniteInstanceName("srv2");
        this.startGrid(cfg);
        cfg = this.getErroneousConfiguration(ipFinder, false);
        cfg.setCacheConfiguration(new CacheConfiguration[]{ccfgs[2], ccfgs[3]});
        cfg.setClientMode(true);
        IgniteConfiguration cfg0 = cfg;
        GridTestUtils.assertThrows((IgniteLogger)log, () -> {
            IgniteEx client = this.startGrid(cfg0);
            client.cluster().state(ClusterState.ACTIVE);
        }, IgniteException.class, (String)"Duplicate index name");
        server.cluster().state(ClusterState.ACTIVE);
        ErroneousQueryEntityConfigurationTest.assertNotNull((Object)server.cache(ccfgs[0].getName()));
        server.cluster().state(ClusterState.INACTIVE);
        if (this.persistent.booleanValue()) {
            this.stopGrid("srv1");
            this.startGrid("srv1");
        }
    }

    private IgniteConfiguration getErroneousConfiguration(TcpDiscoveryIpFinder ipFinder, boolean differentSchemas) {
        TcpDiscoverySpi discoverySpi = new TcpDiscoverySpi();
        discoverySpi.setIpFinder(ipFinder);
        IgniteConfiguration igniteCfg = new IgniteConfiguration();
        igniteCfg.setDiscoverySpi((DiscoverySpi)discoverySpi);
        igniteCfg.setPeerClassLoadingEnabled(true);
        if (this.persistent.booleanValue()) {
            igniteCfg.setDataStorageConfiguration(new DataStorageConfiguration().setDefaultDataRegionConfiguration(new DataRegionConfiguration().setPersistenceEnabled(true).setMaxSize(0xA00000L)));
        }
        Collection<CacheConfiguration> ccfgs = ErroneousQueryEntityConfigurationTest.makeMultipleCachesConfig(differentSchemas);
        igniteCfg.setCacheConfiguration(ccfgs.toArray(new CacheConfiguration[0]));
        igniteCfg.setClientMode(true);
        return igniteCfg;
    }

    private static Collection<CacheConfiguration> makeMultipleCachesConfig(boolean differentSchemas) {
        ArrayList<CacheConfiguration> ccfgs = new ArrayList<CacheConfiguration>();
        CacheConfiguration c1 = new CacheConfiguration("c1");
        c1.setIndexedTypes(new Class[]{Integer.class, String.class});
        c1.setSqlSchema("TEST_V1");
        CacheConfiguration c1custom = new CacheConfiguration("c1custom");
        c1custom.setIndexedTypes(new Class[]{Integer.class, Person.class});
        c1custom.setSqlSchema("TEST_V1");
        CacheConfiguration c2 = new CacheConfiguration("c2");
        c2.setIndexedTypes(new Class[]{Integer.class, String.class});
        CacheConfiguration c2custom = new CacheConfiguration("c2custom");
        c2custom.setIndexedTypes(new Class[]{Integer.class, Person.class});
        if (differentSchemas) {
            c2.setSqlSchema("TEST_V2");
            c2custom.setSqlSchema("TEST_V2");
        } else {
            c2.setSqlSchema("TEST_V1");
            c2custom.setSqlSchema("TEST_V1");
        }
        ccfgs.add(c1);
        ccfgs.add(c1custom);
        ccfgs.add(c2);
        ccfgs.add(c2custom);
        return ccfgs;
    }
}

