/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.index;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteDataStreamer;
import org.apache.ignite.binary.BinaryObject;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.CacheWriteSynchronizationMode;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.cluster.ClusterState;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.DataRegionConfiguration;
import org.apache.ignite.configuration.DataStorageConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.processors.query.h2.H2TableDescriptor;
import org.apache.ignite.internal.processors.query.h2.IgniteH2Indexing;
import org.apache.ignite.internal.processors.query.h2.SchemaManager;
import org.apache.ignite.internal.processors.query.h2.database.H2TreeIndex;
import org.apache.ignite.lang.IgnitePredicate;
import org.apache.ignite.testframework.GridTestUtils;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;

public class DynamicEnableIndexingAbstractTest
extends GridCommonAbstractTest {
    protected static final int IDX_SRV_CRD = 0;
    protected static final int IDX_SRV_NON_CRD = 1;
    protected static final int IDX_CLI = 2;
    protected static final int IDX_SRV_FILTERED = 3;
    protected static final int IDX_CLI_NEAR_ONLY = 4;
    protected static final String ATTR_FILTERED = "FILTERED";
    protected static final String POI_CACHE_NAME = "poi";
    protected static final int NUM_ENTRIES = 1000;
    protected static final String POI_SCHEMA_NAME = "DOMAIN";
    protected static final String POI_TABLE_NAME = "POI";
    protected static final String POI_CLASS_NAME = "PointOfInterest";
    protected static final String ID_FIELD_NAME = "id";
    protected static final String NAME_FIELD_NAME = "name";
    protected static final String KEY_PK_IDX_NAME = "_key_PK";
    protected static final String LATITUDE_FIELD_NAME = "latitude";
    protected static final String LONGITUDE_FIELD_NAME = "longitude";
    protected static final String SELECT_ALL_QUERY = String.format("SELECT * FROM %s", "POI");
    protected static final int QUERY_PARALLELISM = 4;

    protected void createTable(IgniteCache<?, ?> cache, int qryParallelism) {
        this.createTable(cache, POI_SCHEMA_NAME, qryParallelism);
    }

    protected void createTable(IgniteCache<?, ?> cache, String schemaName, int qryParallelism) {
        String sql = String.format("CREATE TABLE %s.%s (%s INT, %s VARCHAR, %s DOUBLE PRECISION, %s DOUBLE PRECISION, PRIMARY KEY (%s)) WITH  \"CACHE_NAME=%s,VALUE_TYPE=%s,PARALLELISM=%d\"", schemaName, POI_TABLE_NAME, ID_FIELD_NAME, NAME_FIELD_NAME, LATITUDE_FIELD_NAME, LONGITUDE_FIELD_NAME, ID_FIELD_NAME, POI_CACHE_NAME, POI_CLASS_NAME, qryParallelism);
        cache.query(new SqlFieldsQuery(sql));
    }

    protected List<IgniteConfiguration> configurations() throws Exception {
        return Arrays.asList(this.serverConfiguration(0), this.serverConfiguration(1), this.clientConfiguration(2), this.serverConfiguration(3, true), this.clientConfiguration(4));
    }

    protected IgniteConfiguration clientConfiguration(int idx) throws Exception {
        return this.commonConfiguration(idx).setClientMode(true);
    }

    protected IgniteConfiguration serverConfiguration(int idx) throws Exception {
        return this.serverConfiguration(idx, false);
    }

    protected IgniteConfiguration serverConfiguration(int idx, boolean filter) throws Exception {
        IgniteConfiguration cfg = this.commonConfiguration(idx);
        if (filter) {
            cfg.setUserAttributes(Collections.singletonMap(ATTR_FILTERED, true));
        }
        return cfg;
    }

    protected IgniteConfiguration commonConfiguration(int idx) throws Exception {
        String gridName = this.getTestIgniteInstanceName(idx);
        IgniteConfiguration cfg = this.getConfiguration(gridName);
        cfg.setClusterStateOnStart(ClusterState.INACTIVE);
        DataStorageConfiguration memCfg = new DataStorageConfiguration().setDefaultDataRegionConfiguration(new DataRegionConfiguration().setMaxSize(0x8000000L));
        cfg.setDataStorageConfiguration(memCfg);
        cfg.setConsistentId((Serializable)((Object)gridName));
        cfg.setSqlSchemas(new String[]{POI_SCHEMA_NAME});
        return this.optimize(cfg);
    }

    protected CacheConfiguration<?, ?> testCacheConfiguration(String name, CacheMode mode, CacheAtomicityMode atomicityMode) {
        return new CacheConfiguration(name).setNodeFilter((IgnitePredicate)new NodeFilter()).setAtomicityMode(atomicityMode).setWriteSynchronizationMode(CacheWriteSynchronizationMode.FULL_SYNC).setCacheMode(mode);
    }

    protected void loadData(IgniteEx node, int start, int end) {
        try (IgniteDataStreamer streamer = node.dataStreamer(POI_CACHE_NAME);){
            ThreadLocalRandom rnd = ThreadLocalRandom.current();
            for (int i = start; i < end; ++i) {
                BinaryObject bo = node.binary().builder(POI_CLASS_NAME).setField(NAME_FIELD_NAME, (Object)("POI_" + i), String.class).setField(LATITUDE_FIELD_NAME, (Object)((Random)rnd).nextDouble(), Double.class).setField(LONGITUDE_FIELD_NAME, (Object)((Random)rnd).nextDouble(), Double.class).build();
                streamer.addData((Object)i, (Object)bo);
            }
        }
    }

    protected void performQueryingIntegrityCheck(Ignite ig) throws Exception {
        this.performQueryingIntegrityCheck(ig, 100);
    }

    protected List<List<?>> query(Ignite ig, String sql) throws Exception {
        IgniteCache cache = ig.cache(POI_CACHE_NAME).withKeepBinary();
        return cache.query(new SqlFieldsQuery(sql).setSchema(POI_SCHEMA_NAME)).getAll();
    }

    protected void performQueryingIntegrityCheck(Ignite ig, int key) throws Exception {
        IgniteCache cache = ig.cache(POI_CACHE_NAME).withKeepBinary();
        String sql = String.format("DELETE FROM %s WHERE %s = %d", POI_TABLE_NAME, ID_FIELD_NAME, key);
        List res = cache.query(new SqlFieldsQuery(sql).setSchema(POI_SCHEMA_NAME)).getAll();
        DynamicEnableIndexingAbstractTest.assertEquals((int)1, (int)res.size());
        DynamicEnableIndexingAbstractTest.assertNull((Object)cache.get((Object)key));
        sql = String.format("INSERT INTO %s(%s) VALUES (%s)", POI_TABLE_NAME, String.join((CharSequence)",", ID_FIELD_NAME, NAME_FIELD_NAME), String.join((CharSequence)",", String.valueOf(key), "'test'"));
        res = cache.query(new SqlFieldsQuery(sql).setSchema(POI_SCHEMA_NAME)).getAll();
        DynamicEnableIndexingAbstractTest.assertEquals((int)1, (int)res.size());
        DynamicEnableIndexingAbstractTest.assertNotNull((Object)cache.get((Object)key));
        sql = String.format("UPDATE %s SET %s = '%s' WHERE ID = %d", POI_TABLE_NAME, NAME_FIELD_NAME, "POI_" + key, key);
        res = cache.query(new SqlFieldsQuery(sql).setSchema(POI_SCHEMA_NAME)).getAll();
        DynamicEnableIndexingAbstractTest.assertEquals((int)1, (int)res.size());
        DynamicEnableIndexingAbstractTest.assertEquals((String)("POI_" + key), (String)((String)((BinaryObject)cache.get((Object)key)).field(NAME_FIELD_NAME)));
        this.assertIndexUsed(cache, "SELECT * FROM POI WHERE ID = " + key, KEY_PK_IDX_NAME);
    }

    protected String explainPlan(IgniteCache<?, ?> cache, String sql) {
        return ((List)cache.query(new SqlFieldsQuery("EXPLAIN " + sql).setSchema(POI_SCHEMA_NAME)).getAll().get(0)).get(0).toString().toLowerCase();
    }

    protected void assertIndexUsed(IgniteCache<?, ?> cache, String sql, String idx) throws IgniteCheckedException {
        AtomicReference currPlan = new AtomicReference();
        boolean res = GridTestUtils.waitForCondition(() -> {
            String plan = this.explainPlan(cache, sql);
            currPlan.set(plan);
            return plan.contains(idx.toLowerCase());
        }, (long)1000L);
        DynamicEnableIndexingAbstractTest.assertTrue((String)("Query \"" + sql + "\" executed without usage of " + idx + ", see plan:\n\"" + (String)currPlan.get() + "\""), (boolean)res);
    }

    protected void checkQueryParallelism(IgniteEx ig, CacheMode cacheMode) {
        int expectedParallelism = cacheMode != CacheMode.REPLICATED ? 4 : 1;
        IgniteH2Indexing indexing = (IgniteH2Indexing)ig.context().query().getIndexing();
        SchemaManager schemaMgr = indexing.schemaManager();
        H2TableDescriptor descr = schemaMgr.tableForType(POI_SCHEMA_NAME, POI_CACHE_NAME, POI_CLASS_NAME);
        DynamicEnableIndexingAbstractTest.assertNotNull((Object)descr);
        if (descr.table().getIndex(KEY_PK_IDX_NAME) instanceof H2TreeIndex) {
            H2TreeIndex pkIdx = (H2TreeIndex)descr.table().getIndex(KEY_PK_IDX_NAME);
            DynamicEnableIndexingAbstractTest.assertNotNull((Object)pkIdx);
            DynamicEnableIndexingAbstractTest.assertEquals((int)expectedParallelism, (int)pkIdx.segmentsCount());
        }
        CacheConfiguration cfg = ig.context().cache().cacheConfiguration(POI_CACHE_NAME);
        DynamicEnableIndexingAbstractTest.assertEquals((int)expectedParallelism, (int)cfg.getQueryParallelism());
    }

    protected static class NodeFilter
    implements IgnitePredicate<ClusterNode> {
        private static final long serialVersionUID = 0L;

        protected NodeFilter() {
        }

        public boolean apply(ClusterNode node) {
            return node.attribute(DynamicEnableIndexingAbstractTest.ATTR_FILTERED) == null;
        }
    }
}

