/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.index;

import java.io.Serializable;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.client.Person;
import org.apache.ignite.cluster.ClusterState;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.DataRegionConfiguration;
import org.apache.ignite.configuration.DataStorageConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.failure.FailureHandler;
import org.apache.ignite.failure.StopNodeFailureHandler;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.processors.cache.CacheMetricsImpl;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.index.IgniteH2IndexingEx;
import org.apache.ignite.internal.processors.cache.index.IndexingTestUtils;
import org.apache.ignite.internal.processors.cache.persistence.CacheDataRow;
import org.apache.ignite.internal.processors.query.aware.IndexBuildStatusHolder;
import org.apache.ignite.internal.processors.query.aware.IndexBuildStatusStorage;
import org.apache.ignite.internal.processors.query.h2.H2TableDescriptor;
import org.apache.ignite.internal.processors.query.h2.IgniteH2Indexing;
import org.apache.ignite.internal.processors.query.h2.database.H2TreeIndex;
import org.apache.ignite.internal.util.lang.IgniteThrowableBiPredicate;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.G;
import org.apache.ignite.testframework.GridTestUtils;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractRebuildIndexTest
extends GridCommonAbstractTest {
    protected void beforeTest() throws Exception {
        super.beforeTest();
        IgniteH2IndexingEx.clean(this.getTestIgniteInstanceName());
        this.stopAllGrids();
        this.cleanPersistenceDir();
    }

    protected void afterTest() throws Exception {
        super.afterTest();
        IgniteH2IndexingEx.clean(this.getTestIgniteInstanceName());
        this.stopAllGrids();
        this.cleanPersistenceDir();
    }

    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        return super.getConfiguration(igniteInstanceName).setConsistentId((Serializable)((Object)igniteInstanceName)).setFailureHandler((FailureHandler)new StopNodeFailureHandler()).setBuildIndexThreadPoolSize(Math.max(2, IgniteConfiguration.DFLT_BUILD_IDX_THREAD_POOL_SIZE)).setDataStorageConfiguration(new DataStorageConfiguration().setDefaultDataRegionConfiguration(new DataRegionConfiguration().setPersistenceEnabled(true))).setCacheConfiguration(new CacheConfiguration[]{this.cacheCfg("default", null)});
    }

    protected IgniteEx startGrid(int idx) throws Exception {
        IgniteEx n = super.startGrid(idx);
        n.cluster().state(ClusterState.ACTIVE);
        return n;
    }

    protected IndexingTestUtils.StopBuildIndexConsumer addStopRebuildIndexConsumer(IgniteEx n, String cacheName) {
        IndexingTestUtils.StopBuildIndexConsumer consumer = new IndexingTestUtils.StopBuildIndexConsumer(this.getTestTimeout());
        IgniteH2IndexingEx.addCacheRowConsumer(IndexingTestUtils.nodeName(n), cacheName, consumer);
        return consumer;
    }

    protected IndexingTestUtils.BreakBuildIndexConsumer addBreakRebuildIndexConsumer(IgniteEx n, String cacheName, int breakCnt) {
        IndexingTestUtils.BreakBuildIndexConsumer consumer = new IndexingTestUtils.BreakBuildIndexConsumer(this.getTestTimeout(), (IgniteThrowableBiPredicate<IndexingTestUtils.BreakBuildIndexConsumer, CacheDataRow>)(IgniteThrowableBiPredicate & Serializable)(c, r) -> c.visitCnt.get() >= (long)breakCnt);
        IgniteH2IndexingEx.addCacheRowConsumer(IndexingTestUtils.nodeName(n), cacheName, consumer);
        return consumer;
    }

    protected IndexingTestUtils.SlowdownBuildIndexConsumer addSlowdownRebuildIndexConsumer(IgniteEx n, String cacheName, long sleepTime) {
        IndexingTestUtils.SlowdownBuildIndexConsumer consumer = new IndexingTestUtils.SlowdownBuildIndexConsumer(this.getTestTimeout(), sleepTime);
        IgniteH2IndexingEx.addCacheRowConsumer(IndexingTestUtils.nodeName(n), cacheName, consumer);
        return consumer;
    }

    protected IndexingTestUtils.SlowdownBuildIndexConsumer addSlowdownIdxCreateConsumer(IgniteEx n, String idxName, long sleepTime) {
        IndexingTestUtils.SlowdownBuildIndexConsumer consumer = new IndexingTestUtils.SlowdownBuildIndexConsumer(this.getTestTimeout(), sleepTime);
        IgniteH2IndexingEx.addIdxCreateCacheRowConsumer(IndexingTestUtils.nodeName(n), idxName, consumer);
        return consumer;
    }

    protected IndexingTestUtils.BreakBuildIndexConsumer addBreakIdxCreateConsumer(IgniteEx n, String idxName, int breakCnt) {
        IndexingTestUtils.BreakBuildIndexConsumer consumer = new IndexingTestUtils.BreakBuildIndexConsumer(this.getTestTimeout(), (IgniteThrowableBiPredicate<IndexingTestUtils.BreakBuildIndexConsumer, CacheDataRow>)(IgniteThrowableBiPredicate & Serializable)(c, r) -> c.visitCnt.get() >= (long)breakCnt);
        IgniteH2IndexingEx.addIdxCreateCacheRowConsumer(IndexingTestUtils.nodeName(n), idxName, consumer);
        return consumer;
    }

    protected IgniteInternalFuture<?> checkStartRebuildIndexes(IgniteEx n, GridCacheContext<?, ?> cacheCtx) {
        IgniteInternalFuture idxRebFut = this.indexRebuildFuture(n, cacheCtx.cacheId());
        AbstractRebuildIndexTest.assertNotNull((Object)idxRebFut);
        AbstractRebuildIndexTest.assertFalse((boolean)idxRebFut.isDone());
        this.checkCacheMetrics0(n, cacheCtx.name(), true, 0L);
        return idxRebFut;
    }

    protected void checkCacheMetrics0(IgniteEx n, String cacheName, boolean expIdxRebuildInProgress, @Nullable Long expIdxRebuildKeysProcessed) {
        CacheMetricsImpl metrics0 = this.cacheMetrics0(n, cacheName);
        AbstractRebuildIndexTest.assertNotNull((Object)metrics0);
        AbstractRebuildIndexTest.assertEquals((boolean)expIdxRebuildInProgress, (boolean)metrics0.isIndexRebuildInProgress());
        if (expIdxRebuildKeysProcessed != null) {
            AbstractRebuildIndexTest.assertEquals((long)expIdxRebuildKeysProcessed, (long)metrics0.getIndexRebuildKeysProcessed());
        }
    }

    protected void checkFinishRebuildIndexes(IgniteEx n, GridCacheContext<?, ?> cacheCtx, int expKeys) {
        AbstractRebuildIndexTest.assertNull((Object)this.indexRebuildFuture(n, cacheCtx.cacheId()));
        this.checkCacheMetrics0(n, cacheCtx.name(), false, Long.valueOf(expKeys));
    }

    protected void stopAllGridsWithDeleteIndexBin() throws Exception {
        List igniteInstanceNames = G.allGrids().stream().map(Ignite::name).collect(Collectors.toList());
        this.stopAllGrids();
        for (String n : igniteInstanceNames) {
            GridTestUtils.deleteIndexBin((String)n);
        }
    }

    protected <K, V> CacheConfiguration<K, V> cacheCfg(String cacheName, @Nullable String grpName) {
        CacheConfiguration cacheCfg = new CacheConfiguration(cacheName);
        return cacheCfg.setGroupName(grpName).setIndexedTypes(new Class[]{Integer.class, Person.class});
    }

    protected void populate(IgniteCache<Integer, Person> cache, int cnt) {
        for (int i = 0; i < cnt; ++i) {
            cache.put((Object)i, (Object)new Person(Integer.valueOf(i), "name_" + i));
        }
    }

    protected IndexBuildStatusStorage indexBuildStatusStorage(IgniteEx n) {
        return (IndexBuildStatusStorage)GridTestUtils.getFieldValue((Object)n.context().query(), (String[])new String[]{"idxBuildStatusStorage"});
    }

    protected ConcurrentMap<String, IndexBuildStatusHolder> statuses(IgniteEx n) {
        return (ConcurrentMap)GridTestUtils.getFieldValue((Object)this.indexBuildStatusStorage(n), (String[])new String[]{"statuses"});
    }

    protected List<List<?>> createIdx(IgniteCache<Integer, Person> cache, String idxName) {
        String sql = "CREATE INDEX " + idxName + " ON Person(name)";
        return cache.query(new SqlFieldsQuery(sql)).getAll();
    }

    protected Void enableCheckpoints(IgniteEx n, String reason, boolean enable) throws Exception {
        if (enable) {
            this.dbMgr(n).enableCheckpoints(true).get(this.getTestTimeout());
            this.forceCheckpoint(F.asList((Object)n), reason);
        } else {
            this.forceCheckpoint(F.asList((Object)n), reason);
            this.dbMgr(n).enableCheckpoints(false).get(this.getTestTimeout());
        }
        return null;
    }

    @Nullable
    protected H2TreeIndex index(IgniteEx n, IgniteCache<Integer, Person> cache, String idxName) {
        IgniteH2Indexing indexing = (IgniteH2Indexing)n.context().query().getIndexing();
        return indexing.schemaManager().tablesForCache(GridTestUtils.cacheContext(cache).name()).stream().map(H2TableDescriptor::table).map(table -> table.getIndex(idxName)).findAny().map(H2TreeIndex.class::cast).orElse(null);
    }

    protected String treeName(H2TreeIndex idx) {
        return (String)GridTestUtils.getFieldValue((Object)idx, (String[])new String[]{"treeName"});
    }
}

