/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.distributed;

import java.util.Random;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.query.Query;
import org.apache.ignite.cache.query.SqlQuery;
import org.apache.ignite.cache.query.annotations.QuerySqlField;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.internal.processors.cache.distributed.CacheBlockOnReadAbstractTest;
import org.jetbrains.annotations.NotNull;
import org.junit.Ignore;
import org.junit.Test;

public class CacheBlockOnSqlQueryTest
extends CacheBlockOnReadAbstractTest {
    @NotNull
    protected CacheBlockOnReadAbstractTest.CacheReadBackgroundOperation<?, ?> getReadOperation() {
        return new CacheBlockOnReadAbstractTest.CacheReadBackgroundOperation<Integer, TestingEntity>(){
            private Random random;
            {
                this.random = new Random();
            }

            protected CacheConfiguration<Integer, TestingEntity> createCacheConfiguration() {
                return super.createCacheConfiguration().setIndexedTypes(new Class[]{Integer.class, TestingEntity.class});
            }

            protected Integer createKey(int idx) {
                return idx;
            }

            protected TestingEntity createValue(int idx) {
                return new TestingEntity(idx, idx);
            }

            public void doRead() {
                int idx = this.random.nextInt(this.entriesCount());
                this.cache().query((Query)new SqlQuery(TestingEntity.class, "val >= ? and val < ?").setArgs(new Object[]{idx, idx + 500})).getAll();
            }
        };
    }

    @CacheBlockOnReadAbstractTest.Params(baseline=1, atomicityMode=CacheAtomicityMode.ATOMIC, cacheMode=CacheMode.PARTITIONED)
    @Ignore(value="https://issues.apache.org/jira/browse/IGNITE-9916")
    @Test
    public void testStartServerAtomicPartitioned() {
    }

    @CacheBlockOnReadAbstractTest.Params(baseline=1, atomicityMode=CacheAtomicityMode.TRANSACTIONAL, cacheMode=CacheMode.PARTITIONED)
    @Ignore(value="https://issues.apache.org/jira/browse/IGNITE-9916")
    @Test
    public void testStartServerTransactionalPartitioned() {
    }

    @CacheBlockOnReadAbstractTest.Params(baseline=1, atomicityMode=CacheAtomicityMode.ATOMIC, cacheMode=CacheMode.PARTITIONED)
    @Ignore(value="https://issues.apache.org/jira/browse/IGNITE-9916")
    @Test
    public void testStopServerAtomicPartitioned() {
    }

    @CacheBlockOnReadAbstractTest.Params(baseline=1, atomicityMode=CacheAtomicityMode.TRANSACTIONAL, cacheMode=CacheMode.PARTITIONED)
    @Ignore(value="https://issues.apache.org/jira/browse/IGNITE-9916")
    @Test
    public void testStopServerTransactionalPartitioned() {
    }

    @CacheBlockOnReadAbstractTest.Params(baseline=1, atomicityMode=CacheAtomicityMode.ATOMIC, cacheMode=CacheMode.PARTITIONED)
    @Ignore(value="https://issues.apache.org/jira/browse/IGNITE-9916")
    @Test
    public void testStopBaselineAtomicPartitioned() {
    }

    @CacheBlockOnReadAbstractTest.Params(baseline=1, atomicityMode=CacheAtomicityMode.TRANSACTIONAL, cacheMode=CacheMode.PARTITIONED)
    @Ignore(value="https://issues.apache.org/jira/browse/IGNITE-9916")
    @Test
    public void testStopBaselineTransactionalPartitioned() {
    }

    @CacheBlockOnReadAbstractTest.Params(baseline=1, atomicityMode=CacheAtomicityMode.ATOMIC, cacheMode=CacheMode.PARTITIONED)
    @Ignore(value="https://issues.apache.org/jira/browse/IGNITE-9916")
    @Test
    public void testStartClientAtomicPartitioned() {
    }

    @CacheBlockOnReadAbstractTest.Params(baseline=1, atomicityMode=CacheAtomicityMode.TRANSACTIONAL, cacheMode=CacheMode.PARTITIONED)
    @Ignore(value="https://issues.apache.org/jira/browse/IGNITE-9916")
    @Test
    public void testStartClientTransactionalPartitioned() {
    }

    @CacheBlockOnReadAbstractTest.Params(baseline=1, atomicityMode=CacheAtomicityMode.ATOMIC, cacheMode=CacheMode.PARTITIONED)
    @Ignore(value="https://issues.apache.org/jira/browse/IGNITE-9916")
    @Test
    public void testStopClientAtomicPartitioned() {
    }

    @CacheBlockOnReadAbstractTest.Params(baseline=1, atomicityMode=CacheAtomicityMode.TRANSACTIONAL, cacheMode=CacheMode.PARTITIONED)
    @Ignore(value="https://issues.apache.org/jira/browse/IGNITE-9916")
    @Test
    public void testStopClientTransactionalPartitioned() {
    }

    public static class TestingEntity {
        @QuerySqlField(index=true)
        public Integer id;
        @QuerySqlField(index=true)
        public double val;

        public TestingEntity() {
        }

        public TestingEntity(Integer id, double val) {
            this.id = id;
            this.val = val;
        }
    }
}

