/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import org.apache.ignite.Ignite;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.DataRegionConfiguration;
import org.apache.ignite.configuration.DataStorageConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.failure.FailureContext;
import org.apache.ignite.failure.FailureHandler;
import org.apache.ignite.failure.StopNodeFailureHandler;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.testframework.junits.WithSystemProperty;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.junit.Test;

public class StartCachesInParallelTest
extends GridCommonAbstractTest {
    private TestStopNodeFailureHandler failureHnd;

    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(igniteInstanceName);
        cfg.setDataStorageConfiguration(new DataStorageConfiguration().setDefaultDataRegionConfiguration(new DataRegionConfiguration().setPersistenceEnabled(true)));
        cfg.setCacheConfiguration(new CacheConfiguration[]{new CacheConfiguration().setName("default").setIndexedTypes(new Class[]{Integer.class, Integer.class})});
        this.failureHnd = new TestStopNodeFailureHandler();
        cfg.setFailureHandler((FailureHandler)this.failureHnd);
        return cfg;
    }

    protected void beforeTest() throws Exception {
        super.beforeTest();
        this.stopAllGrids();
        this.cleanPersistenceDir();
    }

    protected void afterTest() throws Exception {
        super.afterTest();
        this.stopAllGrids();
        this.cleanPersistenceDir();
    }

    @Test
    @WithSystemProperty(key="IGNITE_ALLOW_START_CACHES_IN_PARALLEL", value="true")
    public void testWithEnabledOption() throws Exception {
        this.doTest();
    }

    @Test
    @WithSystemProperty(key="IGNITE_ALLOW_START_CACHES_IN_PARALLEL", value="true")
    public void testWithDisabledOption() throws Exception {
        this.doTest();
    }

    @Test
    @WithSystemProperty(key="IGNITE_ALLOW_START_CACHES_IN_PARALLEL", value="")
    public void testWithoutOption() throws Exception {
        System.clearProperty("IGNITE_ALLOW_START_CACHES_IN_PARALLEL");
        this.doTest();
    }

    private void doTest() throws Exception {
        String optionVal = System.getProperty("IGNITE_ALLOW_START_CACHES_IN_PARALLEL");
        StartCachesInParallelTest.assertEquals((String)"Property wasn't set", (String)optionVal, (String)System.getProperty("IGNITE_ALLOW_START_CACHES_IN_PARALLEL"));
        IgniteEx node = this.startGrid(0);
        node.cluster().active(true);
        StartCachesInParallelTest.assertNull((String)("Node failed with " + this.failureHnd.lastFailureCtx), (Object)this.failureHnd.lastFailureCtx);
        StartCachesInParallelTest.assertTrue((boolean)node.cluster().active());
    }

    private static class TestStopNodeFailureHandler
    extends StopNodeFailureHandler {
        private volatile FailureContext lastFailureCtx;

        private TestStopNodeFailureHandler() {
        }

        public boolean handle(Ignite ignite, FailureContext failureCtx) {
            this.lastFailureCtx = failureCtx;
            return super.handle(ignite, failureCtx);
        }
    }
}

