/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import java.sql.SQLException;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.IntStream;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.cache.QueryEntity;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.cache.query.annotations.QuerySqlField;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.testframework.GridTestUtils;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.junit.Ignore;
import org.junit.Test;

public class SqlCacheStartStopTest
extends GridCommonAbstractTest {
    public static final String[] CACHE_NAMES = new String[]{null, "SQL_C1", "SQL_C2", "SQL_C3", "SQL_C4", "SQL_C5", "SQL_C6", "SQL_C7", "SQL_C8", "SQL_C9", "SQL_C10", "SQL_C11", "SQL_C12"};

    protected void afterTest() throws Exception {
        this.stopAllGrids();
    }

    @Ignore(value="https://ggsystems.atlassian.net/browse/GG-26054")
    @Test
    public void testClientCloseQueryConcurrent() throws Exception {
        IgniteConfiguration srvCfg = this.getConfiguration("server").setCacheConfiguration(new CacheConfiguration[]{this.ccfg(1)});
        IgniteEx srv = this.startGrid(srvCfg);
        IgniteEx cli = this.startGrid(this.getConfiguration("client").setClientMode(true));
        this.execSql(srv, "insert into " + CACHE_NAMES[1] + "(id, s) values(?, ?)", "cli", "cli");
        SqlCacheStartStopTest.assertEquals((int)1, (int)this.execSql(cli, "SELECT * FROM " + CACHE_NAMES[1], new Object[0]).size());
        this.execSql(cli, "create index idx_" + CACHE_NAMES[1] + " on " + CACHE_NAMES[1] + "(s)", new Object[0]);
        this.execSql(cli, "drop index idx_" + CACHE_NAMES[1], new Object[0]);
        AtomicBoolean end = new AtomicBoolean();
        IgniteInternalFuture fut = GridTestUtils.runAsync(() -> {
            while (!end.get()) {
                cli.cache(CACHE_NAMES[1]).close();
            }
        });
        for (int i = 0; i < 100000; ++i) {
            SqlCacheStartStopTest.assertEquals((int)1, (int)this.execSql(cli, "SELECT * FROM " + CACHE_NAMES[1], new Object[0]).size());
            this.execSql(cli, "create index idx_" + CACHE_NAMES[1] + " on " + CACHE_NAMES[1] + "(s)", new Object[0]);
            this.execSql(cli, "drop index idx_" + CACHE_NAMES[1], new Object[0]);
        }
        end.set(true);
        fut.get(1000L);
    }

    @Test
    public void testClientCacheClose() throws Exception {
        int[] idxs = IntStream.rangeClosed(1, 9).toArray();
        IgniteConfiguration srvCfg = this.getConfiguration("server").setCacheConfiguration(new CacheConfiguration[]{this.ccfg(1), this.ccfg(2)});
        IgniteEx srv = this.startGrid(srvCfg);
        this.createCache(srv, 4);
        this.createTable(srv, 5);
        IgniteConfiguration cliCfg = this.getConfiguration("client").setClientMode(true).setCacheConfiguration(new CacheConfiguration[]{this.ccfg(1), this.ccfg(3)});
        IgniteEx cli = this.startGrid(cliCfg);
        this.createCache(srv, 6);
        this.createTable(srv, 7);
        this.createCache(cli, 8);
        this.execSql(this.cache((Ignite)cli, 1), this.createTableQuery(9), new Object[0]);
        for (int i : idxs) {
            this.execSql(srv, "insert into " + CACHE_NAMES[i] + "(id, s) values(?, ?)", "srv", "srv");
            this.execSql(cli, "insert into " + CACHE_NAMES[i] + "(id, s) values(?, ?)", "cli", "cli");
        }
        for (int i : idxs) {
            this.cache((Ignite)cli, i).close();
        }
        IgniteCache<Object, Object> c10 = this.createCache(cli, 10);
        IgniteCache c11 = cli.createCache(this.ccfgWithoutSql(11));
        for (int i : idxs) {
            String cacheName = CACHE_NAMES[i];
            this.execSql(cli, "select * from " + cacheName, new Object[0]);
            this.execSql(cli, "create index idx_" + cacheName + " on " + cacheName + "(s)", new Object[0]);
            this.execSql(cli, "select count(*) from " + cacheName, new Object[0]);
            this.execSql(cli, "drop index idx_" + cacheName, new Object[0]);
            this.execSql(c10, "select * from " + cacheName, new Object[0]);
            this.execSql(c10, "create index idx_" + cacheName + " on " + cacheName + "(s)", new Object[0]);
            this.execSql(c11, "select count(*) from " + cacheName, new Object[0]);
            this.execSql(c11, "drop index idx_" + cacheName, new Object[0]);
        }
    }

    @Test
    public void testServerCacheClose() throws Exception {
        int[] idxs = IntStream.rangeClosed(1, 11).toArray();
        CacheConfiguration[] ccfgs = new CacheConfiguration[]{this.ccfg(1), this.ccfg(2)};
        IgniteEx n1 = this.startGrid(this.getConfiguration("n1").setCacheConfiguration(ccfgs));
        IgniteEx n2 = this.startGrid(this.getConfiguration("n2").setCacheConfiguration(ccfgs));
        this.createCache(n1, 4);
        this.createTable(n1, 5);
        this.createCache(n2, 6);
        this.createTable(n2, 7);
        IgniteEx cli = this.startGrid(this.getConfiguration("client").setClientMode(true).setCacheConfiguration(new CacheConfiguration[]{this.ccfg(1), this.ccfg(3), this.ccfg(6)}));
        this.createCache(n1, 8);
        this.createTable(n2, 9);
        this.createCache(cli, 10);
        this.execSql(this.cache((Ignite)cli, 1), this.createTableQuery(11), new Object[0]);
        for (int i : idxs) {
            this.execSql(n1, "insert into " + CACHE_NAMES[i] + "(id, s) values(?, ?)", "n1", "n1");
            this.execSql(n2, "insert into " + CACHE_NAMES[i] + "(id, s) values(?, ?)", "n2", "n2");
            this.execSql(cli, "insert into " + CACHE_NAMES[i] + "(id, s) values(?, ?)", "cli", "cli");
        }
        for (int i : idxs) {
            this.cache((Ignite)n1, i).close();
        }
        n1.createCache(this.ccfg(12));
        for (int i : idxs) {
            String cacheName = CACHE_NAMES[i];
            this.execSql(this.cache((Ignite)cli, 1), "select * from " + cacheName, new Object[0]);
            this.execSql(this.cache((Ignite)cli, 3), "create index idx_" + cacheName + " on " + cacheName + "(s)", new Object[0]);
            this.execSql(this.cache((Ignite)n1, 12), "select count(*) from " + cacheName + " group by id", new Object[0]);
            this.execSql(this.cache((Ignite)n1, 12), "drop index idx_" + cacheName, new Object[0]);
        }
    }

    @Test
    public void testClientCacheDestroy() throws Exception {
        this.checkDestroy(true);
    }

    @Test
    public void testServerCacheDestroy() throws Exception {
        this.checkDestroy(false);
    }

    private void checkDestroy(boolean client) throws Exception {
        int[] idxs = IntStream.rangeClosed(1, 9).toArray();
        IgniteConfiguration srvCfg = this.getConfiguration("server").setCacheConfiguration(new CacheConfiguration[]{this.ccfg(1), this.ccfg(2)});
        IgniteEx srv = this.startGrid(srvCfg);
        this.createCache(srv, 4);
        this.createTable(srv, 5);
        IgniteConfiguration cliCfg = this.getConfiguration("client").setClientMode(true).setCacheConfiguration(new CacheConfiguration[]{this.ccfg(1), this.ccfg(3)});
        IgniteEx cli = this.startGrid(cliCfg);
        this.createCache(srv, 6);
        this.createTable(srv, 7);
        this.createCache(cli, 8);
        this.execSql(this.cache((Ignite)cli, 1), this.createTableQuery(9), new Object[0]);
        for (int i : idxs) {
            this.execSql(srv, "insert into " + CACHE_NAMES[i] + "(id, s) values(?, ?)", "srv", "srv");
            this.execSql(cli, "insert into " + CACHE_NAMES[i] + "(id, s) values(?, ?)", "cli", "cli");
        }
        for (int i : idxs) {
            IgniteEx node = client ? cli : srv;
            this.cache((Ignite)node, i).destroy();
        }
        IgniteCache<Object, Object> c10 = this.createCache(cli, 10);
        for (int i : idxs) {
            String cacheName = CACHE_NAMES[i];
            GridTestUtils.assertThrowsWithCause(() -> this.execSql(c10, "select * from " + cacheName, new Object[0]), SQLException.class);
        }
    }

    private IgniteCache<Object, Object> createCache(IgniteEx ign, int i) {
        return ign.createCache(this.ccfg(i));
    }

    private void createTable(IgniteEx ign, int i) {
        String name = CACHE_NAMES[i];
        this.execSql(ign, this.createTableQuery(i), new Object[0]);
    }

    private String createTableQuery(int i) {
        String name = CACHE_NAMES[i];
        return "create table " + name + "(id varchar primary key, s varchar) with \"cache_name=" + name + "\"";
    }

    private List<List<?>> execSql(IgniteCache<?, ?> cache, String sql, Object ... args) {
        return cache.query(new SqlFieldsQuery(sql).setArgs(args)).getAll();
    }

    private List<List<?>> execSql(IgniteEx ign, String sql, Object ... args) {
        return ign.context().query().querySqlFields(new SqlFieldsQuery(sql).setArgs(args), false).getAll();
    }

    private CacheConfiguration<Object, Object> ccfg(int i) {
        String name = CACHE_NAMES[i];
        return new CacheConfiguration(name).setSqlSchema("PUBLIC").setQueryEntities(Collections.singleton(new QueryEntity(Key.class, Val.class).setTableName(name)));
    }

    private CacheConfiguration<Object, Object> ccfgWithoutSql(int i) {
        return new CacheConfiguration(CACHE_NAMES[i]);
    }

    private IgniteCache<Object, Object> cache(Ignite ign, int i) {
        return ign.cache(CACHE_NAMES[i]);
    }

    public static class Val {
        @QuerySqlField
        private final String s;

        public Val(String s) {
            this.s = s;
        }
    }

    public static class Key {
        @QuerySqlField
        private final String id;

        public Key(String id) {
            this.id = id;
        }
    }
}

