/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.cache.query;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.cache.Cache;
import javax.cache.CacheException;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteDataStreamer;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.affinity.AffinityFunction;
import org.apache.ignite.cache.affinity.rendezvous.RendezvousAffinityFunction;
import org.apache.ignite.cache.query.IndexQuery;
import org.apache.ignite.cache.query.Query;
import org.apache.ignite.cache.query.QueryCursor;
import org.apache.ignite.cache.query.annotations.QuerySqlField;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.TestRecordingCommunicationSpi;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.spi.communication.CommunicationSpi;
import org.apache.ignite.testframework.GridTestUtils;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class IndexQueryPartitionTest
extends GridCommonAbstractTest {
    private static final String CACHE_PARTITIONED = "CACHE-PARTIIONED";
    private static final String CACHE_REPLICATED = "CACHE-REPLICATED";
    @Parameterized.Parameter
    public boolean client;
    private static Map<Integer, Person> data;

    @Parameterized.Parameters(name="client={0}")
    public static List<Object[]> params() {
        return F.asList((Object[])new Object[][]{{false}, {true}});
    }

    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(igniteInstanceName);
        CacheConfiguration ccfg1 = new CacheConfiguration().setName(CACHE_PARTITIONED).setAtomicityMode(CacheAtomicityMode.TRANSACTIONAL).setCacheMode(CacheMode.PARTITIONED).setIndexedTypes(new Class[]{Integer.class, Person.class}).setAffinity((AffinityFunction)new RendezvousAffinityFunction().setPartitions(100));
        CacheConfiguration ccfg2 = new CacheConfiguration().setName(CACHE_REPLICATED).setAtomicityMode(CacheAtomicityMode.TRANSACTIONAL).setCacheMode(CacheMode.REPLICATED).setIndexedTypes(new Class[]{Integer.class, Person.class}).setAffinity((AffinityFunction)new RendezvousAffinityFunction().setPartitions(100));
        cfg.setCacheConfiguration(new CacheConfiguration[]{ccfg1, ccfg2});
        cfg.setCommunicationSpi((CommunicationSpi)new TestRecordingCommunicationSpi());
        return cfg;
    }

    protected void beforeTest() throws Exception {
        this.startGrids(3);
        this.startClientGrid(3);
    }

    protected void afterTest() throws Exception {
        this.stopAllGrids();
    }

    @Test
    public void testSinglePartition() {
        this.load();
        for (int part = 0; part < 100; ++part) {
            Map<Integer, Person> expRes = this.expect(part);
            IndexQuery qry = new IndexQuery(Person.class).setPartition(Integer.valueOf(part));
            QueryCursor cursor = this.grid().cache(CACHE_PARTITIONED).query((Query)qry);
            for (Cache.Entry e : cursor) {
                Person p = expRes.remove(e.getKey());
                IndexQueryPartitionTest.assertEquals((String)((Integer)e.getKey()).toString(), (Object)p, (Object)e.getValue());
            }
            IndexQueryPartitionTest.assertTrue((boolean)expRes.isEmpty());
        }
    }

    @Test
    public void testSetNullNotAffect() {
        try (IgniteDataStreamer dataStreamer = this.grid().dataStreamer(CACHE_PARTITIONED);){
            Random rnd = new Random();
            for (int i = 0; i < 10000; ++i) {
                dataStreamer.addData((Object)i, (Object)new Person(rnd.nextInt()));
            }
        }
        IndexQuery qry = new IndexQuery(Person.class).setPartition(Integer.valueOf(0));
        IndexQueryPartitionTest.assertTrue((this.grid().cache(CACHE_PARTITIONED).query((Query)qry).getAll().size() < 10000 ? 1 : 0) != 0);
        qry = new IndexQuery(Person.class).setPartition(null);
        IndexQueryPartitionTest.assertTrue((this.grid().cache(CACHE_PARTITIONED).query((Query)qry).getAll().size() == 10000 ? 1 : 0) != 0);
    }

    @Test
    public void testLocalWithPartition() {
        this.load();
        for (int part = 0; part < 100; ++part) {
            IndexQuery qry = new IndexQuery(Person.class).setPartition(Integer.valueOf(part));
            qry.setLocal(true);
            IgniteCache cache = this.grid().cache(CACHE_PARTITIONED);
            if (this.client) {
                GridTestUtils.assertThrows(null, () -> cache.query((Query)qry).getAll(), CacheException.class, (String)"Execution of local IndexQuery on client node disallowed.");
                continue;
            }
            boolean owner = this.grid().affinity(CACHE_PARTITIONED).mapPartitionToNode(part).equals(this.grid().localNode());
            IndexQueryPartitionTest.assertEquals((!owner ? 1 : 0) != 0, (boolean)cache.query((Query)qry).getAll().isEmpty());
        }
    }

    @Test
    public void testNegativePartitionFails() {
        GridTestUtils.assertThrows(null, () -> new IndexQuery(Person.class).setPartition(Integer.valueOf(-1)), IllegalArgumentException.class, (String)"Specified partition must be in the range [0, N) where N is partition number in the cache.");
        GridTestUtils.assertThrows(null, () -> new IndexQuery(Person.class).setPartition(Integer.valueOf(-23)), IllegalArgumentException.class, (String)"Specified partition must be in the range [0, N) where N is partition number in the cache.");
        GridTestUtils.assertThrows(null, () -> {
            IndexQuery qry = new IndexQuery(Person.class).setPartition(Integer.valueOf(1000));
            this.grid().cache(CACHE_PARTITIONED).query((Query)qry);
        }, CacheException.class, (String)"Specified partition must be in the range [0, N) where N is partition number in the cache.");
    }

    @Test
    public void testSetPartitionOnReplicatedCacheFails() {
        IgniteCache cache = this.grid().cache(CACHE_REPLICATED);
        cache.put((Object)1, (Object)new Person(1));
        IndexQuery idxQuery = new IndexQuery(Person.class).setPartition(Integer.valueOf(1));
        GridTestUtils.assertThrows(null, () -> cache.query((Query)idxQuery).getAll(), CacheException.class, (String)"Partitions are not supported for replicated caches");
    }

    protected IgniteEx grid() {
        IgniteEx grid;
        IgniteEx igniteEx = grid = this.client ? this.grid(3) : this.grid(0);
        assert (this.client && this.grid(0).localNode().isClient() || !this.grid(0).localNode().isClient());
        return grid;
    }

    private void load() {
        data = new HashMap<Integer, Person>();
        try (IgniteDataStreamer dataStreamer = this.grid(0).dataStreamer(CACHE_PARTITIONED);){
            Random rnd = new Random();
            for (int i = 0; i < 10000; ++i) {
                Person p = new Person(rnd.nextInt());
                data.put(i, p);
                dataStreamer.addData((Object)i, (Object)p);
            }
        }
    }

    private Map<Integer, Person> expect(int part) {
        HashMap<Integer, Person> exp = new HashMap<Integer, Person>();
        for (Integer key : data.keySet()) {
            int p = this.grid(0).affinity(CACHE_PARTITIONED).partition((Object)key);
            if (p != part) continue;
            exp.put(key, data.get(key));
        }
        return exp;
    }

    private static class Person {
        @GridToStringInclude
        @QuerySqlField(index=true)
        private final int fld;

        Person(int fld) {
            this.fld = fld;
        }

        public String toString() {
            return S.toString(Person.class, (Object)this);
        }

        public boolean equals(Object o) {
            return this.fld == ((Person)o).fld;
        }

        public int hashCode() {
            return this.fld;
        }
    }
}

