/*
 * Copyright 2021 GridGain Systems, Inc. and Contributors.
 *
 * Licensed under the GridGain Community Edition License (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.gridgain.com/products/software/community-edition/gridgain-community-edition-license
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.ignite.internal.managers.systemview.walker;

import java.util.Collections;
import java.util.List;
import org.apache.ignite.internal.processors.query.stat.view.StatisticsColumnConfigurationView;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.spi.systemview.view.SystemViewRowAttributeWalker;

/**
 * Generated by {@code org.apache.ignite.codegen.SystemViewRowAttributeWalkerGenerator}.
 * {@link StatisticsColumnConfigurationView} attributes walker.
 * 
 * @see StatisticsColumnConfigurationView
 */
public class StatisticsColumnConfigurationViewWalker implements SystemViewRowAttributeWalker<StatisticsColumnConfigurationView> {
    /** Filter key for attribute "schema" */
    public static final String SCHEMA_FILTER = "schema";

    /** Filter key for attribute "type" */
    public static final String TYPE_FILTER = "type";

    /** Filter key for attribute "name" */
    public static final String NAME_FILTER = "name";

    /** Filter key for attribute "column" */
    public static final String COLUMN_FILTER = "column";

    /** List of filtrable attributes. */
    private static final List<String> FILTRABLE_ATTRS = Collections.unmodifiableList(F.asList(
        "schema", "type", "name", "column"
    ));

    /** {@inheritDoc} */
    @Override public List<String> filtrableAttributes() {
        return FILTRABLE_ATTRS;
    }

    /** {@inheritDoc} */
    @Override public void visitAll(AttributeVisitor v) {
        v.accept(0, "schema", String.class);
        v.accept(1, "type", String.class);
        v.accept(2, "name", String.class);
        v.accept(3, "column", String.class);
        v.accept(4, "maxPartitionObsolescencePercent", byte.class);
        v.accept(5, "manualNulls", Long.class);
        v.accept(6, "manualDistinct", Long.class);
        v.accept(7, "manualTotal", Long.class);
        v.accept(8, "manualSize", Integer.class);
        v.accept(9, "version", long.class);
    }

    /** {@inheritDoc} */
    @Override public void visitAll(StatisticsColumnConfigurationView row, AttributeWithValueVisitor v) {
        v.accept(0, "schema", String.class, row.schema());
        v.accept(1, "type", String.class, row.type());
        v.accept(2, "name", String.class, row.name());
        v.accept(3, "column", String.class, row.column());
        v.acceptByte(4, "maxPartitionObsolescencePercent", row.maxPartitionObsolescencePercent());
        v.accept(5, "manualNulls", Long.class, row.manualNulls());
        v.accept(6, "manualDistinct", Long.class, row.manualDistinct());
        v.accept(7, "manualTotal", Long.class, row.manualTotal());
        v.accept(8, "manualSize", Integer.class, row.manualSize());
        v.acceptLong(9, "version", row.version());
    }

    /** {@inheritDoc} */
    @Override public int count() {
        return 10;
    }
}
