/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.stat;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.managers.systemview.GridSystemViewManager;
import org.apache.ignite.internal.managers.systemview.walker.StatisticsColumnLocalDataViewWalker;
import org.apache.ignite.internal.managers.systemview.walker.StatisticsColumnPartitionDataViewWalker;
import org.apache.ignite.internal.processors.query.stat.IgniteStatisticsHelper;
import org.apache.ignite.internal.processors.query.stat.IgniteStatisticsStore;
import org.apache.ignite.internal.processors.query.stat.ObjectPartitionStatisticsImpl;
import org.apache.ignite.internal.processors.query.stat.ObjectPartitionStatisticsObsolescence;
import org.apache.ignite.internal.processors.query.stat.ObjectStatisticsImpl;
import org.apache.ignite.internal.processors.query.stat.StatisticsKey;
import org.apache.ignite.internal.processors.query.stat.config.StatisticsObjectConfiguration;
import org.apache.ignite.internal.processors.query.stat.view.ColumnLocalDataViewSupplier;
import org.apache.ignite.internal.processors.query.stat.view.ColumnPartitionDataViewSupplier;
import org.apache.ignite.internal.util.collection.IntHashMap;
import org.apache.ignite.internal.util.collection.IntMap;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.spi.systemview.view.SystemViewRowAttributeWalker;

public class IgniteStatisticsRepository {
    public static final String STAT_PART_DATA_VIEW = "statisticsPartitionData";
    public static final String STAT_PART_DATA_VIEW_DESC = "Statistics per partition data.";
    public static final String STAT_LOCAL_DATA_VIEW = "statisticsLocalData";
    public static final String STAT_LOCAL_DATA_VIEW_DESC = "Statistics local node data.";
    private final IgniteLogger log;
    private final IgniteStatisticsStore store;
    private final Map<StatisticsKey, ObjectStatisticsImpl> locStats = new ConcurrentHashMap<StatisticsKey, ObjectStatisticsImpl>();
    private final Map<StatisticsKey, IntMap<ObjectPartitionStatisticsObsolescence>> statObs = new ConcurrentHashMap<StatisticsKey, IntMap<ObjectPartitionStatisticsObsolescence>>();
    private final IgniteStatisticsHelper helper;

    public IgniteStatisticsRepository(IgniteStatisticsStore store, GridSystemViewManager sysViewMgr, IgniteStatisticsHelper helper, Function<Class<?>, IgniteLogger> logSupplier) {
        this.store = store;
        this.helper = helper;
        this.log = logSupplier.apply(IgniteStatisticsRepository.class);
        ColumnPartitionDataViewSupplier colPartDataViewSupplier = new ColumnPartitionDataViewSupplier(store);
        sysViewMgr.registerFiltrableView(STAT_PART_DATA_VIEW, STAT_PART_DATA_VIEW_DESC, (SystemViewRowAttributeWalker)new StatisticsColumnPartitionDataViewWalker(), colPartDataViewSupplier::columnPartitionStatisticsViewSupplier, Function.identity());
        ColumnLocalDataViewSupplier colLocDataViewSupplier = new ColumnLocalDataViewSupplier(this);
        sysViewMgr.registerFiltrableView(STAT_LOCAL_DATA_VIEW, STAT_LOCAL_DATA_VIEW_DESC, (SystemViewRowAttributeWalker)new StatisticsColumnLocalDataViewWalker(), colLocDataViewSupplier::columnLocalStatisticsViewSupplier, Function.identity());
    }

    public Collection<ObjectPartitionStatisticsImpl> getLocalPartitionsStatistics(StatisticsKey key) {
        return this.store.getLocalPartitionsStatistics(key);
    }

    public ObjectPartitionStatisticsObsolescence getObsolescence(StatisticsKey key, int partId) {
        IntMap<ObjectPartitionStatisticsObsolescence> objObs = this.statObs.get(key);
        if (objObs == null) {
            return null;
        }
        return (ObjectPartitionStatisticsObsolescence)objObs.get(partId);
    }

    public void refreshObsolescence(StatisticsKey key, int partId) {
        ObjectPartitionStatisticsObsolescence newObs = new ObjectPartitionStatisticsObsolescence();
        newObs.dirty(false);
        this.statObs.compute(key, (k, v) -> {
            if (v == null) {
                v = new IntHashMap();
            }
            v.put(partId, (Object)newObs);
            return v;
        });
        this.store.saveObsolescenceInfo(key, partId, newObs);
    }

    public void replaceLocalPartitionStatistics(StatisticsKey key, ObjectPartitionStatisticsImpl statistics) {
        this.store.saveLocalPartitionStatistics(key, statistics);
    }

    public ObjectPartitionStatisticsImpl getLocalPartitionStatistics(StatisticsKey key, int partId) {
        return this.store.getLocalPartitionStatistics(key, partId);
    }

    public void saveLocalStatistics(StatisticsKey key, ObjectStatisticsImpl statistics) {
        this.locStats.put(key, statistics);
    }

    public void clearLocalPartitionsStatistics(StatisticsKey key, Set<Integer> partsToRemove) {
        if (F.isEmpty(partsToRemove)) {
            this.store.clearLocalPartitionsStatistics(key);
            this.store.clearObsolescenceInfo(key, null);
            this.locStats.remove(key);
            this.statObs.remove(key);
        } else {
            this.store.clearLocalPartitionsStatistics(key, partsToRemove);
            this.store.clearObsolescenceInfo(key, partsToRemove);
            this.statObs.computeIfPresent(key, (k, v) -> {
                for (Integer partToRemove : partsToRemove) {
                    v.remove(partToRemove.intValue());
                }
                return v.isEmpty() ? null : v;
            });
        }
    }

    public ObjectStatisticsImpl getLocalStatistics(StatisticsKey key) {
        return this.locStats.get(key);
    }

    public Map<StatisticsKey, ObjectStatisticsImpl> localStatisticsMap() {
        return this.locStats;
    }

    public IgniteStatisticsStore statisticsStore() {
        return this.store;
    }

    public ObjectStatisticsImpl aggregatedLocalStatistics(Collection<ObjectPartitionStatisticsImpl> stats, StatisticsObjectConfiguration cfg) {
        ObjectStatisticsImpl locStat;
        if (this.log.isDebugEnabled()) {
            this.log.debug("Refresh local aggregated statistic [cfg=" + cfg + ", part.size()=" + stats.size() + ']');
        }
        if ((locStat = this.helper.aggregateLocalStatistics(cfg, stats)) != null) {
            this.saveLocalStatistics(cfg.key(), locStat);
        }
        return locStat;
    }

    public synchronized void stop() {
        this.locStats.clear();
        if (this.log.isDebugEnabled()) {
            this.log.debug("Statistics repository started.");
        }
    }

    public synchronized void start() {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Statistics repository started.");
        }
    }

    public synchronized List<StatisticsKey> getObsolescenceKeys() {
        return new ArrayList<StatisticsKey>(this.statObs.keySet());
    }

    public synchronized IntMap<ObjectPartitionStatisticsObsolescence> getObsolescence(StatisticsKey key) {
        IntMap<ObjectPartitionStatisticsObsolescence> res = this.statObs.get(key);
        if (res == null) {
            return new IntHashMap(0);
        }
        return new IntHashMap(res);
    }

    public void saveObsolescenceInfo(StatisticsKey key) {
        IntMap<ObjectPartitionStatisticsObsolescence> objObs = this.statObs.get(key);
        if (objObs == null) {
            return;
        }
        objObs.forEach((k, v) -> {
            if (v.dirty()) {
                this.store.saveObsolescenceInfo(key, k, (ObjectPartitionStatisticsObsolescence)v);
                v.dirty(false);
            }
        });
    }
}

