/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.twostep.msg;

import java.nio.ByteBuffer;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.processors.query.h2.twostep.msg.GridH2ValueMessage;
import org.apache.ignite.plugin.extensions.communication.MessageReader;
import org.apache.ignite.plugin.extensions.communication.MessageWriter;
import org.gridgain.internal.h2.value.Value;
import org.gridgain.internal.h2.value.ValueTimestamp;

public class GridH2Timestamp
extends GridH2ValueMessage {
    private long date;
    private long nanos;

    public GridH2Timestamp() {
    }

    public GridH2Timestamp(Value val) {
        assert (val.getType().getValueType() == 11) : val.getType();
        ValueTimestamp t = (ValueTimestamp)val;
        this.date = t.getDateValue();
        this.nanos = t.getTimeNanos();
    }

    @Override
    public Value value(GridKernalContext ctx) {
        return ValueTimestamp.fromDateValueAndNanos((long)this.date, (long)this.nanos);
    }

    @Override
    public boolean writeTo(ByteBuffer buf, MessageWriter writer) {
        writer.setBuffer(buf);
        if (!super.writeTo(buf, writer)) {
            return false;
        }
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(this.directType(), this.fieldsCount())) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 0: {
                if (!writer.writeLong("date", this.date)) {
                    return false;
                }
                writer.incrementState();
            }
            case 1: {
                if (!writer.writeLong("nanos", this.nanos)) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }

    @Override
    public boolean readFrom(ByteBuffer buf, MessageReader reader) {
        reader.setBuffer(buf);
        if (!reader.beforeMessageRead()) {
            return false;
        }
        if (!super.readFrom(buf, reader)) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                this.date = reader.readLong("date");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 1: {
                this.nanos = reader.readLong("nanos");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(GridH2Timestamp.class);
    }

    public short directType() {
        return -15;
    }

    public byte fieldsCount() {
        return 2;
    }

    public String toString() {
        return this.date + "_" + this.nanos;
    }
}

