/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2;

import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.processors.query.h2.opt.H2Row;
import org.apache.ignite.internal.util.lang.GridCursor;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.gridgain.internal.h2.index.Cursor;
import org.gridgain.internal.h2.message.DbException;
import org.gridgain.internal.h2.result.Row;
import org.gridgain.internal.h2.result.SearchRow;

public class H2Cursor
implements Cursor,
AutoCloseable {
    private final GridCursor<H2Row> cursor;
    private final long time = U.currentTimeMillis();
    private Row cur;

    public H2Cursor(GridCursor<H2Row> cursor) {
        assert (cursor != null);
        this.cursor = cursor;
    }

    public Row get() {
        return this.cur;
    }

    public SearchRow getSearchRow() {
        return this.get();
    }

    public boolean next() {
        try {
            while (this.cursor.next()) {
                H2Row row = (H2Row)this.cursor.get();
                if (row.expireTime() > 0L && row.expireTime() <= this.time) continue;
                this.cur = row;
                return true;
            }
            this.cur = null;
            return false;
        }
        catch (IgniteCheckedException e) {
            throw DbException.convert((Throwable)e);
        }
    }

    public boolean previous() {
        throw DbException.getUnsupportedException((String)"previous");
    }

    @Override
    public void close() throws Exception {
        this.cursor.close();
        this.cur = null;
    }
}

