/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.sqltests;

import com.google.inject.internal.util.Objects;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.CacheWriteSynchronizationMode;
import org.apache.ignite.cache.affinity.AffinityFunction;
import org.apache.ignite.cache.affinity.rendezvous.RendezvousAffinityFunction;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.processors.cache.AbstractDataTypesCoverageTest;
import org.apache.ignite.testframework.GridTestUtils;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.impl.CoordinateArraySequence;

public class SqlDataTypesCoverageTests
extends AbstractDataTypesCoverageTest {
    protected static final int TIMEOUT_FOR_KEY_RETRIEVAL_IN_FULL_ASYNC_MODE = 10000;

    @Before
    public void init() throws Exception {
        super.init();
    }

    @Test
    public void testBooleanDataType() throws Exception {
        this.checkBasicSqlOperations(SqlDataType.BOOLEAN, Boolean.TRUE, Boolean.FALSE);
    }

    @Test
    public void testIntDataType() throws Exception {
        this.checkBasicSqlOperations(SqlDataType.INT, 0, 1, Integer.MAX_VALUE, Integer.MIN_VALUE);
    }

    @Ignore(value="https://ggsystems.atlassian.net/browse/GG-23065")
    @Test
    public void testTinyIntDataType() throws Exception {
        this.checkBasicSqlOperations(SqlDataType.TINYINT, (byte)0, (byte)1, (byte)-128, (byte)127);
    }

    @Ignore(value="https://ggsystems.atlassian.net/browse/GG-23065")
    @Test
    public void testSmallIntDataType() throws Exception {
        this.checkBasicSqlOperations(SqlDataType.SMALLINT, (short)0, (short)1, (short)Short.MIN_VALUE, (short)Short.MAX_VALUE);
    }

    @Test
    public void testBigIntDataType() throws Exception {
        this.checkBasicSqlOperations(SqlDataType.BIGINT, 0L, 1L, Long.MIN_VALUE, Long.MAX_VALUE);
    }

    @Test
    public void testDecimalDataType() throws Exception {
        this.checkBasicSqlOperations(SqlDataType.DECIMAL, new BigDecimal(123.123), BigDecimal.ONE, BigDecimal.ZERO, BigDecimal.valueOf(123456789L, 0), BigDecimal.valueOf(123456789L, 1), BigDecimal.valueOf(123456789L, 2), BigDecimal.valueOf(123456789L, 3));
    }

    @Test
    public void testDoubleDataType() throws Exception {
        this.checkBasicSqlOperations(SqlDataType.DOUBLE, Double.MIN_VALUE, Double.MAX_VALUE, new AbstractDataTypesCoverageTest.Quoted((Object)Double.NaN), new AbstractDataTypesCoverageTest.Quoted((Object)Double.NEGATIVE_INFINITY), new AbstractDataTypesCoverageTest.Quoted((Object)Double.POSITIVE_INFINITY), 0.0, 0.0, 1.0, 1.0, 1.1);
    }

    @Test
    public void testRealDataType() throws Exception {
        this.checkBasicSqlOperations(SqlDataType.REAL, Float.valueOf(Float.MIN_VALUE), Float.valueOf(Float.MAX_VALUE), new AbstractDataTypesCoverageTest.Quoted((Object)Float.valueOf(Float.NaN)), new AbstractDataTypesCoverageTest.Quoted((Object)Float.valueOf(Float.NEGATIVE_INFINITY)), new AbstractDataTypesCoverageTest.Quoted((Object)Float.valueOf(Float.POSITIVE_INFINITY)), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(1.0f), Float.valueOf(1.1f));
    }

    @Ignore(value="https://ggsystems.atlassian.net/browse/GG-23410")
    @Test
    public void testTimeDataType() throws Exception {
        this.checkBasicSqlOperations(SqlDataType.TIME, new AbstractDataTypesCoverageTest.Timed(new Time(0L)), new AbstractDataTypesCoverageTest.Timed(new Time(123L)));
    }

    @Ignore(value="https://ggsystems.atlassian.net/browse/GG-17353")
    @Test
    public void testDateDataType() throws Exception {
        this.checkBasicSqlOperations(SqlDataType.DATE, new AbstractDataTypesCoverageTest.Dated(new Date(0L)), new AbstractDataTypesCoverageTest.Dated(new Date(123L)));
    }

    @Test
    public void testTimestampDataType() throws Exception {
        this.checkBasicSqlOperations(SqlDataType.TIMESTAMP, new AbstractDataTypesCoverageTest.Dated(new Timestamp(0L)), new AbstractDataTypesCoverageTest.Dated(new Timestamp(123L)));
    }

    @Test
    public void testVarcharDataType() throws Exception {
        this.checkBasicSqlOperations(SqlDataType.VARCHAR, new AbstractDataTypesCoverageTest.Quoted((Object)""), new AbstractDataTypesCoverageTest.Quoted((Object)"abcABC"), new AbstractDataTypesCoverageTest.Quoted((Object)"!@#$%^&*()"));
    }

    @Test
    public void testCharDataType() throws Exception {
        this.checkBasicSqlOperations(SqlDataType.CHAR, new AbstractDataTypesCoverageTest.Quoted((Object)"a"), new AbstractDataTypesCoverageTest.Quoted((Object)"A"), new AbstractDataTypesCoverageTest.Quoted((Object)"@"));
    }

    @Test
    public void testUUIDDataType() throws Exception {
        this.checkBasicSqlOperations(SqlDataType.UUID, new AbstractDataTypesCoverageTest.Quoted((Object)UUID.randomUUID()), new AbstractDataTypesCoverageTest.Quoted((Object)UUID.randomUUID()));
    }

    @Ignore(value="https://ggsystems.atlassian.net/browse/GG-23401")
    @Test
    public void testBinaryDataType() throws Exception {
        this.checkBasicSqlOperations(SqlDataType.BINARY, new AbstractDataTypesCoverageTest.ByteArrayed(new byte[]{1, 2, 3}), new AbstractDataTypesCoverageTest.ByteArrayed(new byte[]{3, 2, 1}), new AbstractDataTypesCoverageTest.ByteArrayed(new byte[0]));
    }

    @Ignore(value="https://ggsystems.atlassian.net/browse/GG-23066")
    @Test
    public void testGeometryDataType() throws Exception {
        GeometryFactory geometryFactory = new GeometryFactory();
        this.checkBasicSqlOperations(SqlDataType.GEOMETRY, new AbstractDataTypesCoverageTest.Quoted((Object)new Point((CoordinateSequence)new CoordinateArraySequence(new Coordinate[]{new Coordinate(1.1, 2.2)}), geometryFactory)), new AbstractDataTypesCoverageTest.Quoted((Object)new Point((CoordinateSequence)new CoordinateArraySequence(new Coordinate[]{new Coordinate(3.3, 4.4)}), geometryFactory)));
    }

    protected void checkBasicSqlOperations(SqlDataType dataType, Object ... valsToCheck) throws Exception {
        assert (valsToCheck.length > 0);
        IgniteEx ignite = this.grid(new Random().nextInt(3));
        String tblName = "table" + UUID.randomUUID().toString().replaceAll("-", "_");
        String templateName = "template" + UUID.randomUUID().toString().replaceAll("-", "_");
        CacheConfiguration cfg = new CacheConfiguration(templateName).setAtomicityMode(this.atomicityMode).setCacheMode(this.cacheMode).setExpiryPolicyFactory(this.ttlFactory).setBackups(this.backups).setEvictionPolicyFactory(this.evictionFactory).setOnheapCacheEnabled(this.evictionFactory != null || this.onheapCacheEnabled).setWriteSynchronizationMode(this.writeSyncMode).setAffinity((AffinityFunction)new RendezvousAffinityFunction(false, 16));
        ignite.addCacheConfiguration(cfg);
        ignite.context().query().querySqlFields(new SqlFieldsQuery("CREATE TABLE " + tblName + "(id " + (Object)((Object)dataType) + " PRIMARY KEY, val " + (Object)((Object)dataType) + ") WITH \"template=" + templateName + "\""), false);
        if (this.cacheMode != CacheMode.LOCAL) {
            ignite.context().query().querySqlFields(new SqlFieldsQuery("CREATE INDEX IDX" + UUID.randomUUID().toString().replaceAll("-", "_") + " ON " + tblName + "(id, val)"), false);
        }
        this.checkCRUD(ignite, tblName, dataType, valsToCheck);
    }

    private void checkCRUD(IgniteEx ignite, String tblName, SqlDataType dataType, Object ... valsToCheck) throws Exception {
        for (int i = 0; i < valsToCheck.length; ++i) {
            Object valToCheck = valsToCheck[i];
            Object valToPut = valToCheck instanceof AbstractDataTypesCoverageTest.SqlStrConvertedValHolder ? ((AbstractDataTypesCoverageTest.SqlStrConvertedValHolder)valToCheck).sqlStrVal() : valToCheck;
            Object expVal = valToCheck instanceof AbstractDataTypesCoverageTest.SqlStrConvertedValHolder ? ((AbstractDataTypesCoverageTest.SqlStrConvertedValHolder)valToCheck).originalVal() : valToCheck;
            ignite.context().query().querySqlFields(new SqlFieldsQuery("INSERT INTO " + tblName + "(id, val)  VALUES (" + valToPut + ", " + valToPut + ");"), false);
            this.check(ignite, "SELECT id, val FROM " + tblName + ";", dataType, expVal, expVal);
            Object revertedVal = valsToCheck[valsToCheck.length - 1 - i];
            Object revertedValToPut = revertedVal instanceof AbstractDataTypesCoverageTest.SqlStrConvertedValHolder ? ((AbstractDataTypesCoverageTest.SqlStrConvertedValHolder)revertedVal).sqlStrVal() : revertedVal;
            Object expRevertedVal = revertedVal instanceof AbstractDataTypesCoverageTest.SqlStrConvertedValHolder ? ((AbstractDataTypesCoverageTest.SqlStrConvertedValHolder)revertedVal).originalVal() : revertedVal;
            ignite.context().query().querySqlFields(new SqlFieldsQuery("UPDATE " + tblName + " SET val =  " + revertedValToPut + ";"), false);
            this.check(ignite, "SELECT id, val FROM " + tblName + ";", dataType, expVal, expRevertedVal);
            this.check(ignite, "SELECT id, val FROM " + tblName + " where id =  " + valToPut + ";", dataType, expVal, expRevertedVal);
            ignite.context().query().querySqlFields(new SqlFieldsQuery("DELETE FROM " + tblName + " where id =  " + valToPut + ";"), false);
            if (this.writeSyncMode == CacheWriteSynchronizationMode.FULL_ASYNC && !GridTestUtils.waitForCondition(() -> ignite.context().query().querySqlFields(new SqlFieldsQuery("SELECT id FROM " + tblName + ";"), false).getAll().isEmpty(), (long)10000L)) {
                SqlDataTypesCoverageTests.fail((String)"Deleted data are still retrievable via SELECT.");
            }
            List res = ignite.context().query().querySqlFields(new SqlFieldsQuery("SELECT id FROM " + tblName + ";"), false).getAll();
            SqlDataTypesCoverageTests.assertEquals((int)0, (int)res.size());
        }
    }

    private void check(IgniteEx ignite, String qryStr, SqlDataType dataType, Object expKey, Object expVal) throws Exception {
        if (this.writeSyncMode == CacheWriteSynchronizationMode.FULL_ASYNC && !GridTestUtils.waitForCondition(() -> {
            List res = ignite.context().query().querySqlFields(new SqlFieldsQuery(qryStr), false).getAll();
            if (res.isEmpty()) {
                return false;
            }
            if (res.size() != 1) {
                return false;
            }
            if (((List)res.get(0)).size() != 2) {
                return false;
            }
            if (expKey instanceof byte[] ? !Arrays.equals((byte[])expKey, (byte[])((List)res.get(0)).get(0)) : !Objects.equal((Object)expKey, ((List)res.get(0)).get(0))) {
                return false;
            }
            if (!((List)res.get(0)).get(1).getClass().equals(dataType.javaType)) {
                return false;
            }
            return !(expVal instanceof byte[] ? !Arrays.equals((byte[])expVal, (byte[])((List)res.get(0)).get(1)) : !Objects.equal((Object)expVal, ((List)res.get(0)).get(1)));
        }, (long)10000L)) {
            SqlDataTypesCoverageTests.fail((String)"Unable to retrieve data via SELECT.");
        }
        List res = ignite.context().query().querySqlFields(new SqlFieldsQuery(qryStr), false).getAll();
        SqlDataTypesCoverageTests.assertEquals((int)1, (int)res.size());
        SqlDataTypesCoverageTests.assertEquals((int)2, (int)((List)res.get(0)).size());
        SqlDataTypesCoverageTests.assertTrue((boolean)((List)res.get(0)).get(0).getClass().equals(dataType.javaType));
        if (expKey instanceof byte[]) {
            SqlDataTypesCoverageTests.assertTrue((boolean)Arrays.equals((byte[])expKey, (byte[])((List)res.get(0)).get(0)));
        } else {
            SqlDataTypesCoverageTests.assertEquals((Object)expKey, ((List)res.get(0)).get(0));
        }
        SqlDataTypesCoverageTests.assertTrue((boolean)((List)res.get(0)).get(1).getClass().equals(dataType.javaType));
        if (expVal instanceof byte[]) {
            SqlDataTypesCoverageTests.assertTrue((boolean)Arrays.equals((byte[])expVal, (byte[])((List)res.get(0)).get(1)));
        } else {
            SqlDataTypesCoverageTests.assertEquals((Object)expVal, ((List)res.get(0)).get(1));
        }
    }

    protected static enum SqlDataType {
        BOOLEAN(Boolean.class),
        INT(Integer.class),
        TINYINT(Byte.class),
        SMALLINT(Short.class),
        BIGINT(Long.class),
        DECIMAL(BigDecimal.class),
        DOUBLE(Double.class),
        REAL(Float.class),
        TIME(Time.class),
        DATE(Date.class),
        TIMESTAMP(Timestamp.class),
        VARCHAR(String.class),
        CHAR(String.class),
        UUID(UUID.class),
        BINARY(byte[].class),
        GEOMETRY(Point.class);

        private Object javaType;

        private SqlDataType(Object javaType) {
            this.javaType = javaType;
        }
    }
}

