/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.sql;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.cache.processor.EntryProcessorResult;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteException;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.cache.CacheEntryProcessor;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.CacheWriteSynchronizationMode;
import org.apache.ignite.cache.QueryEntity;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.internal.processors.cache.index.AbstractIndexingCommonTest;
import org.apache.ignite.internal.util.typedef.T2;
import org.apache.ignite.lang.IgniteBiTuple;
import org.apache.ignite.testframework.GridTestUtils;
import org.jetbrains.annotations.NotNull;
import org.junit.Test;

public class IgniteCachePartitionedAtomicColumnConstraintsTest
extends AbstractIndexingCommonTest {
    private static final long FUT_TIMEOUT = 10000L;
    private static final String STR_CACHE_NAME = "STR_STR";
    private static final String STR_ORG_CACHE_NAME = "STR_ORG";
    private static final String STR_ORG_WITH_FIELDS_CACHE_NAME = "STR_ORG_WITH_FIELDS";
    private static final String OBJ_CACHE_NAME = "ORG_ADDRESS";
    private static final String DEC_CACHE_NAME_FOR_SCALE = "DEC_DEC_FOR_SCALE";
    private static final String OBJ_CACHE_NAME_FOR_SCALE = "ORG_EMPLOYEE_FOR_SCALE";
    private static final String DEC_EMPL_CACHE_NAME_FOR_SCALE = "DEC_EMPLOYEE_FOR_SCALE";
    private static final String DEC_CACHE_NAME_FOR_PREC = "DEC_DEC_FOR_PREC";
    private static final String OBJ_CACHE_NAME_FOR_PREC = "ORG_EMPLOYEE_FOR_PREC";
    private static final String DEC_EMPL_CACHE_NAME_FOR_PREC = "DEC_EMPLOYEE_FOR_PREC";
    private Consumer<Runnable> shouldFail = op -> GridTestUtils.assertThrowsWithCause((Runnable)op, IgniteException.class);
    private Consumer<Runnable> shouldSucceed = Runnable::run;

    protected void beforeTestsStarted() throws Exception {
        this.startGrid(0);
        this.createCachesForStringTests();
        this.createCachesForDecimalPrecisionTests();
        this.createCachesForDecimalScaleTests();
    }

    private void createCachesForStringTests() throws Exception {
        HashMap<String, Integer> strStrPrecision = new HashMap<String, Integer>();
        strStrPrecision.put("_KEY", 5);
        strStrPrecision.put("_VAL", 5);
        this.jcache((Ignite)this.grid(0), this.cacheConfiguration(new QueryEntity(String.class.getName(), String.class.getName()).setFieldsPrecision(strStrPrecision)), STR_CACHE_NAME);
        HashMap<String, Integer> orgAddressPrecision = new HashMap<String, Integer>();
        orgAddressPrecision.put("name", 5);
        orgAddressPrecision.put("address", 5);
        this.jcache((Ignite)this.grid(0), this.cacheConfiguration(new QueryEntity(Organization.class.getName(), Address.class.getName()).setKeyFields(Collections.singleton("name")).addQueryField("name", "java.lang.String", "name").addQueryField("address", "java.lang.String", "address").setFieldsPrecision(orgAddressPrecision)), OBJ_CACHE_NAME);
        HashMap<String, Integer> strOrgPrecision = new HashMap<String, Integer>();
        strOrgPrecision.put("_KEY", 5);
        this.jcache((Ignite)this.grid(0), this.cacheConfiguration(new QueryEntity(String.class.getName(), Organization.class.getName()).setFieldsPrecision(strOrgPrecision)), STR_ORG_CACHE_NAME);
        this.jcache((Ignite)this.grid(0), this.cacheConfiguration(new QueryEntity(String.class.getName(), Organization.class.getName()).addQueryField("name", "java.lang.String", "name").addQueryField("address", "java.lang.String", "address").setFieldsPrecision(strOrgPrecision)), STR_ORG_WITH_FIELDS_CACHE_NAME);
    }

    private void createCachesForDecimalPrecisionTests() throws Exception {
        HashMap<String, Integer> decDecPrecision = new HashMap<String, Integer>();
        decDecPrecision.put("_KEY", 4);
        decDecPrecision.put("_VAL", 4);
        this.jcache((Ignite)this.grid(0), this.cacheConfiguration(new QueryEntity(BigDecimal.class.getName(), BigDecimal.class.getName()).setFieldsPrecision(decDecPrecision)), DEC_CACHE_NAME_FOR_PREC);
        HashMap<String, Integer> orgEmployeePrecision = new HashMap<String, Integer>();
        orgEmployeePrecision.put("id", 4);
        orgEmployeePrecision.put("salary", 4);
        this.jcache((Ignite)this.grid(0), this.cacheConfiguration(new QueryEntity(DecOrganization.class.getName(), Employee.class.getName()).setKeyFields(Collections.singleton("id")).addQueryField("id", "java.math.BigDecimal", "id").addQueryField("salary", "java.math.BigDecimal", "salary").setFieldsPrecision(orgEmployeePrecision)), OBJ_CACHE_NAME_FOR_PREC);
        HashMap<String, Integer> decEmployeePrecision = new HashMap<String, Integer>();
        decEmployeePrecision.put("_KEY", 4);
        decEmployeePrecision.put("salary", 4);
        this.jcache((Ignite)this.grid(0), this.cacheConfiguration(new QueryEntity(BigDecimal.class.getName(), Employee.class.getName()).addQueryField("salary", "java.math.BigDecimal", "salary").setFieldsPrecision(decEmployeePrecision)), DEC_EMPL_CACHE_NAME_FOR_PREC);
    }

    private void createCachesForDecimalScaleTests() throws Exception {
        HashMap<String, Integer> decDecPrecision = new HashMap<String, Integer>();
        decDecPrecision.put("_KEY", 4);
        decDecPrecision.put("_VAL", 4);
        HashMap<String, Integer> decDecScale = new HashMap<String, Integer>();
        decDecScale.put("_KEY", 2);
        decDecScale.put("_VAL", 2);
        this.jcache((Ignite)this.grid(0), this.cacheConfiguration(new QueryEntity(BigDecimal.class.getName(), BigDecimal.class.getName()).setFieldsScale(decDecScale).setFieldsPrecision(decDecPrecision)), DEC_CACHE_NAME_FOR_SCALE);
        HashMap<String, Integer> orgEmployeePrecision = new HashMap<String, Integer>();
        orgEmployeePrecision.put("id", 4);
        orgEmployeePrecision.put("salary", 4);
        HashMap<String, Integer> orgEmployeeScale = new HashMap<String, Integer>();
        orgEmployeeScale.put("id", 2);
        orgEmployeeScale.put("salary", 2);
        this.jcache((Ignite)this.grid(0), this.cacheConfiguration(new QueryEntity(DecOrganization.class.getName(), Employee.class.getName()).setKeyFields(Collections.singleton("id")).addQueryField("id", "java.math.BigDecimal", "id").addQueryField("salary", "java.math.BigDecimal", "salary").setFieldsScale(orgEmployeeScale).setFieldsPrecision(orgEmployeePrecision)), OBJ_CACHE_NAME_FOR_SCALE);
        HashMap<String, Integer> decEmployeePrecision = new HashMap<String, Integer>();
        decEmployeePrecision.put("_KEY", 4);
        decEmployeePrecision.put("salary", 4);
        HashMap<String, Integer> decEmployeeScale = new HashMap<String, Integer>();
        decEmployeeScale.put("_KEY", 2);
        decEmployeeScale.put("salary", 2);
        this.jcache((Ignite)this.grid(0), this.cacheConfiguration(new QueryEntity(BigDecimal.class.getName(), Employee.class.getName()).addQueryField("salary", "java.math.BigDecimal", "salary").setFieldsPrecision(decEmployeePrecision).setFieldsScale(decEmployeeScale)), DEC_EMPL_CACHE_NAME_FOR_SCALE);
    }

    @Test
    public void testPutTooLongStringValueFail() throws Exception {
        IgniteCache cache = this.jcache(0, STR_CACHE_NAME);
        T2 val = new T2((Object)"3", (Object)"123456");
        this.checkPutAll(this.shouldFail, cache, new T2((Object)"1", (Object)"1"), val);
        this.checkPutOps(this.shouldFail, cache, val);
        this.checkReplaceOps(this.shouldFail, cache, val, "1");
    }

    @Test
    public void testPutTooLongStringKeyFail() throws Exception {
        IgniteCache cache = this.jcache(0, STR_CACHE_NAME);
        T2 val = new T2((Object)"123456", (Object)"2");
        this.checkPutAll(this.shouldFail, cache, new T2((Object)"1", (Object)"1"), val);
        this.checkPutOps(this.shouldFail, cache, val);
    }

    @Test
    public void testPutTooLongStringValueFieldFail() throws Exception {
        IgniteCache cache = this.jcache(0, OBJ_CACHE_NAME);
        T2 val = new T2((Object)new Organization("3"), (Object)new Address("123456"));
        this.checkPutAll(this.shouldFail, cache, new T2((Object)new Organization("1"), (Object)new Address("1")), val);
        this.checkPutOps(this.shouldFail, cache, val);
        this.checkReplaceOps(this.shouldFail, cache, val, new Address("1"));
    }

    @Test
    public void testPutTooLongStringKeyFieldFail() throws Exception {
        IgniteCache cache = this.jcache(0, OBJ_CACHE_NAME);
        T2 val = new T2((Object)new Organization("123456"), (Object)new Address("2"));
        this.checkPutAll(this.shouldFail, cache, new T2((Object)new Organization("1"), (Object)new Address("1")), val);
        this.checkPutOps(this.shouldFail, cache, val);
    }

    @Test
    public void testPutTooLongStringKeyFail2() throws Exception {
        this.doCheckPutTooLongStringKeyFail2(STR_ORG_CACHE_NAME);
    }

    @Test
    public void testPutTooLongStringKeyFail3() throws Exception {
        this.doCheckPutTooLongStringKeyFail2(STR_ORG_WITH_FIELDS_CACHE_NAME);
    }

    private void doCheckPutTooLongStringKeyFail2(String cacheName) {
        IgniteCache cache = this.jcache(0, cacheName);
        T2 val = new T2((Object)"123456", (Object)new Organization("1"));
        this.checkPutAll(this.shouldFail, cache, new T2((Object)"1", (Object)new Organization("1")), val);
        this.checkPutOps(this.shouldFail, cache, val);
    }

    @Test
    public void testPutLongStringValue() throws Exception {
        IgniteCache cache = this.jcache(0, STR_CACHE_NAME);
        T2 val = new T2((Object)"3", (Object)"12345");
        this.checkPutAll(this.shouldSucceed, cache, new T2((Object)"1", (Object)"1"), val);
        this.checkPutOps(this.shouldSucceed, cache, val);
        this.checkReplaceOps(this.shouldSucceed, cache, val, "1");
    }

    @Test
    public void testPutLongStringKey() throws Exception {
        IgniteCache cache = this.jcache(0, STR_CACHE_NAME);
        T2 val = new T2((Object)"12345", (Object)"2");
        this.checkPutAll(this.shouldSucceed, cache, new T2((Object)"1", (Object)"1"), val);
        this.checkPutOps(this.shouldSucceed, cache, val);
    }

    @Test
    public void testPutLongStringValueField() throws Exception {
        IgniteCache cache = this.jcache(0, OBJ_CACHE_NAME);
        T2 val = new T2((Object)new Organization("3"), (Object)new Address("12345"));
        this.checkPutAll(this.shouldSucceed, cache, new T2((Object)new Organization("1"), (Object)new Address("1")), val);
        this.checkPutOps(this.shouldSucceed, cache, val);
        this.checkReplaceOps(this.shouldSucceed, cache, val, new Address("1"));
    }

    @Test
    public void testPutLongStringKeyField() throws Exception {
        IgniteCache cache = this.jcache(0, OBJ_CACHE_NAME);
        T2 val = new T2((Object)new Organization("12345"), (Object)new Address("2"));
        this.checkPutAll(this.shouldSucceed, cache, new T2((Object)new Organization("1"), (Object)new Address("1")), val);
        this.checkPutOps(this.shouldSucceed, cache, val);
    }

    @Test
    public void testPutLongStringKey2() throws Exception {
        this.doCheckPutLongStringKey2(STR_ORG_CACHE_NAME);
    }

    @Test
    public void testPutLongStringKey3() throws Exception {
        this.doCheckPutLongStringKey2(STR_ORG_WITH_FIELDS_CACHE_NAME);
    }

    private void doCheckPutLongStringKey2(String cacheName) {
        IgniteCache cache = this.jcache(0, cacheName);
        T2 key2 = new T2((Object)"12345", (Object)new Organization("1"));
        this.checkPutAll(this.shouldSucceed, cache, new T2((Object)"1", (Object)new Organization("1")), key2);
        this.checkPutOps(this.shouldSucceed, cache, key2);
    }

    @Test
    public void testPutTooLongDecimalValueFail() throws Exception {
        IgniteCache cache = this.jcache(0, DEC_CACHE_NAME_FOR_PREC);
        T2 val = new T2((Object)this.d(12.36), (Object)this.d(123.45));
        this.checkPutAll(this.shouldFail, cache, new T2((Object)this.d(12.34), (Object)this.d(12.34)), val);
        this.checkPutOps(this.shouldFail, cache, val);
        this.checkReplaceOps(this.shouldFail, cache, val, this.d(12.34));
    }

    @Test
    public void testPutTooLongDecimalKeyFail() throws Exception {
        IgniteCache cache = this.jcache(0, DEC_CACHE_NAME_FOR_PREC);
        T2 val = new T2((Object)this.d(123.45), (Object)this.d(12.34));
        this.checkPutAll(this.shouldFail, cache, new T2((Object)this.d(12.35), (Object)this.d(12.34)), val);
        this.checkPutOps(this.shouldFail, cache, val);
    }

    @Test
    public void testPutTooLongDecimalKeyFail2() throws Exception {
        IgniteCache cache = this.jcache(0, DEC_EMPL_CACHE_NAME_FOR_PREC);
        T2 val = new T2((Object)this.d(123.45), (Object)new Employee(this.d(12.34)));
        this.checkPutAll(this.shouldFail, cache, new T2((Object)this.d(12.35), (Object)new Employee(this.d(12.34))), val);
        this.checkPutOps(this.shouldFail, cache, val);
    }

    @Test
    public void testPutTooLongDecimalValueFieldFail() throws Exception {
        IgniteCache cache = this.jcache(0, OBJ_CACHE_NAME_FOR_PREC);
        T2 val = new T2((Object)new DecOrganization(this.d(12.36)), (Object)new Employee(this.d(123.45)));
        this.checkPutAll(this.shouldFail, cache, new T2((Object)new DecOrganization(this.d(12.34)), (Object)new Employee(this.d(12.34))), val);
        this.checkPutOps(this.shouldFail, cache, val);
        this.checkReplaceOps(this.shouldFail, cache, val, new Employee(this.d(12.34)));
    }

    @Test
    public void testPutTooLongDecimalValueFieldFail2() throws Exception {
        IgniteCache cache = this.jcache(0, DEC_EMPL_CACHE_NAME_FOR_PREC);
        T2 val = new T2((Object)this.d(12.36), (Object)new Employee(this.d(123.45)));
        this.checkPutAll(this.shouldFail, cache, new T2((Object)this.d(12.34), (Object)new Employee(this.d(12.34))), val);
        this.checkPutOps(this.shouldFail, cache, val);
        this.checkReplaceOps(this.shouldFail, cache, val, new Employee(this.d(12.34)));
    }

    @Test
    public void testPutTooLongDecimalKeyFieldFail() throws Exception {
        IgniteCache cache = this.jcache(0, OBJ_CACHE_NAME_FOR_PREC);
        T2 val = new T2((Object)new DecOrganization(this.d(123.45)), (Object)new Employee(this.d(12.34)));
        this.checkPutAll(this.shouldFail, cache, new T2((Object)new DecOrganization(this.d(12.35)), (Object)new Employee(this.d(12.34))), val);
        this.checkPutOps(this.shouldFail, cache, val);
    }

    @Test
    public void testPutTooLongDecimalValueScaleFail() throws Exception {
        IgniteCache cache = this.jcache(0, DEC_CACHE_NAME_FOR_SCALE);
        T2 val = new T2((Object)this.d(12.36), (Object)this.d(3.456));
        this.checkPutAll(this.shouldFail, cache, new T2((Object)this.d(12.34), (Object)this.d(12.34)), val);
        this.checkPutOps(this.shouldFail, cache, val);
        this.checkReplaceOps(this.shouldFail, cache, val, this.d(12.34));
    }

    @Test
    public void testPutTooLongDecimalKeyScaleFail() throws Exception {
        IgniteCache cache = this.jcache(0, DEC_CACHE_NAME_FOR_SCALE);
        T2 val = new T2((Object)this.d(3.456), (Object)this.d(12.34));
        this.checkPutAll(this.shouldFail, cache, new T2((Object)this.d(12.35), (Object)this.d(12.34)), val);
        this.checkPutOps(this.shouldFail, cache, val);
    }

    @Test
    public void testPutTooLongDecimalKeyScaleFail2() throws Exception {
        IgniteCache cache = this.jcache(0, DEC_EMPL_CACHE_NAME_FOR_SCALE);
        T2 val = new T2((Object)this.d(3.456), (Object)new Employee(this.d(12.34)));
        this.checkPutAll(this.shouldFail, cache, new T2((Object)this.d(12.35), (Object)new Employee(this.d(12.34))), val);
        this.checkPutOps(this.shouldFail, cache, val);
    }

    @Test
    public void testPutTooLongDecimalValueFieldScaleFail() throws Exception {
        IgniteCache cache = this.jcache(0, OBJ_CACHE_NAME_FOR_SCALE);
        T2 val = new T2((Object)new DecOrganization(this.d(12.36)), (Object)new Employee(this.d(3.456)));
        this.checkPutAll(this.shouldFail, cache, new T2((Object)new DecOrganization(this.d(12.34)), (Object)new Employee(this.d(12.34))), val);
        this.checkPutOps(this.shouldFail, cache, val);
        this.checkReplaceOps(this.shouldFail, cache, val, new Employee(this.d(12.34)));
    }

    @Test
    public void testPutTooLongDecimalValueFieldScaleFail2() throws Exception {
        IgniteCache cache = this.jcache(0, DEC_EMPL_CACHE_NAME_FOR_SCALE);
        T2 val = new T2((Object)this.d(12.36), (Object)new Employee(this.d(3.456)));
        this.checkPutAll(this.shouldFail, cache, new T2((Object)this.d(12.34), (Object)new Employee(this.d(12.34))), val);
        this.checkPutOps(this.shouldFail, cache, val);
        this.checkReplaceOps(this.shouldFail, cache, val, new Employee(this.d(12.34)));
    }

    @Test
    public void testPutTooLongDecimalKeyFieldScaleFail() throws Exception {
        IgniteCache cache = this.jcache(0, OBJ_CACHE_NAME_FOR_SCALE);
        T2 val = new T2((Object)new DecOrganization(this.d(3.456)), (Object)new Employee(this.d(12.34)));
        this.checkPutAll(this.shouldFail, cache, new T2((Object)new DecOrganization(this.d(12.35)), (Object)new Employee(this.d(12.34))), val);
        this.checkPutOps(this.shouldFail, cache, val);
    }

    @Test
    public void testPutValidDecimalKeyAndValue() throws Exception {
        IgniteCache cache = this.jcache(0, DEC_CACHE_NAME_FOR_SCALE);
        T2 val = new T2((Object)this.d(12.37), (Object)this.d(12.34));
        this.checkPutAll(this.shouldSucceed, cache, new T2((Object)this.d(12.36), (Object)this.d(12.34)), val);
        this.checkPutOps(this.shouldSucceed, cache, val);
        this.checkReplaceOps(this.shouldSucceed, cache, val, this.d(12.34));
    }

    @Test
    public void testPutValidDecimalKeyAndValueField() throws Exception {
        IgniteCache cache = this.jcache(0, OBJ_CACHE_NAME_FOR_SCALE);
        T2 val = new T2((Object)new DecOrganization(this.d(12.37)), (Object)new Employee(this.d(12.34)));
        this.checkPutAll(this.shouldSucceed, cache, new T2((Object)new DecOrganization(this.d(12.36)), (Object)new Employee(this.d(12.34))), val);
        this.checkPutOps(this.shouldSucceed, cache, val);
        this.checkReplaceOps(this.shouldSucceed, cache, val, new Employee(this.d(12.34)));
    }

    @Test
    public void testPutValidDecimalKeyAndValueField2() throws Exception {
        IgniteCache cache = this.jcache(0, DEC_EMPL_CACHE_NAME_FOR_SCALE);
        T2 val = new T2((Object)this.d(12.37), (Object)new Employee(this.d(12.34)));
        this.checkPutAll(this.shouldSucceed, cache, new T2((Object)this.d(12.36), (Object)new Employee(this.d(12.34))), val);
        this.checkPutOps(this.shouldSucceed, cache, val);
        this.checkReplaceOps(this.shouldSucceed, cache, val, new Employee(this.d(12.34)));
    }

    private BigDecimal d(double val) {
        return BigDecimal.valueOf(val);
    }

    private <K, V> void checkReplaceOps(Consumer<Runnable> checker, IgniteCache<K, V> cache, T2<K, V> val, V okVal) {
        Object k = val.get1();
        Object v = val.get2();
        cache.put(k, okVal);
        CacheEntryProcessor & Serializable entryProcessor = (CacheEntryProcessor & Serializable)(e, arguments) -> {
            e.setValue(arguments[0]);
            return null;
        };
        Stream<Runnable> ops = Stream.of(() -> cache.replace(k, v), () -> cache.getAndReplace(k, v), () -> cache.replace(k, okVal, v), () -> cache.invoke(k, entryProcessor, new Object[]{v}), () -> {
            Boolean cfr_ignored_0 = (Boolean)cache.replaceAsync(k, v).get(10000L);
        }, () -> cache.getAndReplaceAsync(k, v).get(10000L), () -> {
            Boolean cfr_ignored_0 = (Boolean)cache.replaceAsync(k, okVal, v).get(10000L);
        }, () -> cache.invokeAsync(k, entryProcessor, new Object[]{v}).get(10000L));
        ops.forEach(checker);
    }

    private <K, V> void checkPutOps(Consumer<Runnable> checker, IgniteCache<K, V> cache, T2<K, V> val) {
        Object k = val.get1();
        Object v = val.get2();
        Stream<Runnable> ops = Stream.of(() -> cache.put(k, v), () -> cache.putIfAbsent(k, v), () -> cache.getAndPut(k, v), () -> cache.getAndPutIfAbsent(k, v), () -> {
            Void cfr_ignored_0 = (Void)cache.putAsync(k, v).get(10000L);
        }, () -> {
            Boolean cfr_ignored_0 = (Boolean)cache.putIfAbsentAsync(k, v).get(10000L);
        }, () -> cache.getAndPutAsync(k, v).get(10000L), () -> cache.getAndPutIfAbsentAsync(k, v).get(10000L));
        ops.forEach(checker);
    }

    private <K, V> void checkPutAll(Consumer<Runnable> checker, IgniteCache<K, V> cache, T2<K, V> ... entries) {
        CacheEntryProcessor & Serializable entryProcessor = (CacheEntryProcessor & Serializable)(e, arguments) -> {
            e.setValue(((Iterator)arguments[0]).next());
            return null;
        };
        Map<Object, Object> vals = Arrays.stream(entries).collect(Collectors.toMap(IgniteBiTuple::get1, IgniteBiTuple::get2));
        Stream<Runnable> ops = Stream.of(() -> cache.putAll(vals), () -> {
            Void cfr_ignored_0 = (Void)cache.putAllAsync(vals).get(10000L);
        }, () -> {
            Map map = cache.invokeAll(vals.keySet(), entryProcessor, new Object[]{vals.values().iterator()});
            for (EntryProcessorResult result : map.values()) {
                log.info(">>> " + result.get());
            }
        }, () -> {
            Map map = (Map)cache.invokeAllAsync(vals.keySet(), entryProcessor, new Object[]{vals.values().iterator()}).get(10000L);
            for (EntryProcessorResult result : map.values()) {
                log.info(">>> " + result.get());
            }
        });
        ops.forEach(checker);
    }

    protected CacheConfiguration cacheConfiguration(QueryEntity qryEntity) {
        CacheConfiguration cache = IgniteCachePartitionedAtomicColumnConstraintsTest.defaultCacheConfiguration();
        cache.setCacheMode(this.cacheMode());
        cache.setAtomicityMode(this.atomicityMode());
        cache.setBackups(1);
        cache.setWriteSynchronizationMode(CacheWriteSynchronizationMode.FULL_SYNC);
        cache.setQueryEntities(Collections.singletonList(qryEntity));
        if (CacheAtomicityMode.TRANSACTIONAL_SNAPSHOT.equals((Object)this.atomicityMode())) {
            cache.setNearConfiguration(null);
        }
        return cache;
    }

    @NotNull
    protected CacheAtomicityMode atomicityMode() {
        return CacheAtomicityMode.ATOMIC;
    }

    @NotNull
    protected CacheMode cacheMode() {
        return CacheMode.PARTITIONED;
    }

    private static class Employee
    implements Serializable {
        private final BigDecimal salary;

        private Employee(BigDecimal salary) {
            this.salary = salary;
        }
    }

    private static class DecOrganization
    implements Serializable {
        private final BigDecimal id;

        private DecOrganization(BigDecimal id) {
            this.id = id;
        }
    }

    private static class Address
    implements Serializable {
        private final String address;

        private Address(String address) {
            this.address = address;
        }
    }

    private static class Organization
    implements Serializable {
        private final String name;

        private Organization(String name) {
            this.name = name;
        }
    }
}

