/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.timeout;

import java.util.concurrent.Callable;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.processors.cache.index.AbstractIndexingCommonTest;
import org.apache.ignite.internal.processors.query.h2.IgniteH2Indexing;
import org.apache.ignite.internal.processors.query.timeout.TimedQueryHelper;
import org.apache.ignite.internal.util.typedef.G;
import org.apache.ignite.testframework.GridTestUtils;
import org.junit.Test;

public abstract class AbstractDefaultQueryTimeoutTest
extends AbstractIndexingCommonTest {
    protected void afterTest() throws Exception {
        this.stopAllGrids();
        super.afterTest();
    }

    protected boolean updateQuery() {
        return false;
    }

    @Test
    public void testNoExplicitTimeout1() throws Exception {
        this.checkQueryNoExplicitTimeout(1000L, 0, false);
    }

    @Test
    public void testNoExplicitTimeout2() throws Exception {
        this.checkQueryNoExplicitTimeout(1000L, 1500, false);
    }

    @Test
    public void testNoExplicitTimeout3() throws Exception {
        this.checkQueryNoExplicitTimeout(1000L, 500, true);
    }

    @Test
    public void testExplicitTimeout1() throws Exception {
        this.checkQuery(500L, 0, 0, false);
    }

    @Test
    public void testExplicitTimeout2() throws Exception {
        this.checkQuery(500L, 1000, 0, false);
    }

    @Test
    public void testExplicitTimeout3() throws Exception {
        this.checkQuery(2000L, 1000, 0, true);
    }

    @Test
    public void testExplicitTimeout4() throws Exception {
        this.checkQuery(1500L, 0, 1000, false);
    }

    @Test
    public void testExplicitTimeout5() throws Exception {
        this.checkQuery(1000L, 1500, 500, false);
    }

    @Test
    public void testExplicitTimeout6() throws Exception {
        this.checkQuery(2000L, 1000, 500, true);
    }

    @Test
    public void testExplicitTimeout7() throws Exception {
        this.checkQuery(500L, 1000, 2000, false);
    }

    @Test
    public void testExplicitTimeout8() throws Exception {
        this.checkQuery(2000L, 1000, 2000, true);
    }

    @Test
    public void testConcurrent() throws Exception {
        IgniteEx ign = this.startGrid(0);
        this.setDefaultQueryTimeout(2000);
        this.prepareQueryExecution();
        TimedQueryHelper helper = new TimedQueryHelper(1000L, "default");
        helper.createCache((Ignite)ign);
        String qryText = this.updateQuery() ? helper.buildTimedUpdateQuery() : helper.buildTimedQuery();
        IgniteInternalFuture fut1 = GridTestUtils.runAsync(() -> {
            this.executeQuery(qryText, 500);
            return null;
        });
        IgniteInternalFuture fut2 = GridTestUtils.runAsync(() -> {
            this.executeQuery(qryText, 1500);
            return null;
        });
        this.assertQueryCancelled(() -> ((IgniteInternalFuture)fut1).get());
        fut2.get();
    }

    private void checkQueryNoExplicitTimeout(long execTime, int defaultTimeout, boolean expectCancelled) throws Exception {
        this.checkQuery0(execTime, null, defaultTimeout, expectCancelled);
    }

    protected void checkQuery(long execTime, int explicitTimeout, int defaultTimeout, boolean expectCancelled) throws Exception {
        this.checkQuery0(execTime, explicitTimeout, defaultTimeout, expectCancelled);
    }

    private void checkQuery0(long execTime, Integer explicitTimeout, int defaultTimeout, boolean expectCancelled) throws Exception {
        this.startGrid(0);
        this.setDefaultQueryTimeout(defaultTimeout);
        this.prepareQueryExecution();
        TimedQueryHelper helper = new TimedQueryHelper(execTime, "default");
        helper.createCache((Ignite)this.grid(0));
        Callable<Void> c = () -> {
            String qryText;
            String string = qryText = this.updateQuery() ? helper.buildTimedUpdateQuery() : helper.buildTimedQuery();
            if (explicitTimeout != null) {
                this.executeQuery(qryText, explicitTimeout);
            } else {
                this.executeQuery(qryText);
            }
            return null;
        };
        if (expectCancelled) {
            this.assertQueryCancelled(c);
        } else {
            c.call();
        }
    }

    protected void prepareQueryExecution() throws Exception {
    }

    protected abstract void executeQuery(String var1) throws Exception;

    protected abstract void executeQuery(String var1, int var2) throws Exception;

    protected abstract void assertQueryCancelled(Callable<?> var1);

    protected void setDefaultQueryTimeout(int timeout) throws IgniteCheckedException {
        ((IgniteH2Indexing)this.grid(0).context().query().getIndexing()).distributedConfiguration().defaultQueryTimeout(timeout);
        AbstractDefaultQueryTimeoutTest.assertTrue((boolean)GridTestUtils.waitForCondition(() -> {
            for (Ignite ign : G.allGrids()) {
                if (((IgniteH2Indexing)((IgniteEx)ign).context().query().getIndexing()).distributedConfiguration().defaultQueryTimeout() == timeout) continue;
                return false;
            }
            return true;
        }, (long)2000L));
    }
}

