/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.stat.hll;

import org.apache.ignite.internal.processors.query.stat.hll.util.BitUtil;

public class ProbabilisticTestUtil {
    public static long constructHLLValue(int log2m, int registerIndex, int registerValue) {
        long partition = registerIndex;
        long substreamValue = 1L << registerValue - 1;
        return substreamValue << log2m | partition;
    }

    public static short getRegisterIndex(long rawValue, int log2m) {
        long mBitsMask = (1 << log2m) - 1;
        short j = (short)(rawValue & mBitsMask);
        return j;
    }

    public static byte getRegisterValue(long rawValue, int log2m) {
        long substreamValue = rawValue >>> log2m;
        byte p_w = substreamValue == 0L ? (byte)0 : (byte)Math.min(1 + BitUtil.leastSignificantBit((long)substreamValue), 31);
        return p_w;
    }

    public static int getRequiredBytes(int shortWordLength, int registerCount) {
        return (int)Math.ceil((float)(registerCount * shortWordLength) / 8.0f);
    }
}

