/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.stat;

import org.apache.ignite.internal.processors.query.stat.StatisticsTypesAbstractTest;
import org.junit.Ignore;
import org.junit.Test;

public class PSUStatisticsTypesTest
extends StatisticsTypesAbstractTest {
    private void doColumnTests(String name, String comp, String val) {
        String[][] noHints = new String[1][];
        String[][] hints = new String[][]{{"DTYPES_" + name}};
        String[][] wrongHints = new String[][]{{"DTYPES_COL_INDEX"}};
        String isNullSql = String.format("select * from dtypes i1 where col_%s is null", name);
        this.checkOptimalPlanChosenForDifferentIndexes(this.grid(0), new String[]{"DTYPES_" + name}, isNullSql, noHints);
        this.checkOptimalPlanChosenForDifferentIndexes(this.grid(0), new String[]{"DTYPES_" + name}, isNullSql, hints);
        this.checkOptimalPlanChosenForDifferentIndexes(this.grid(0), new String[0], isNullSql, wrongHints);
        String sql = String.format("select * from dtypes i1 where col_%s %s %s", name, comp, val);
        this.checkOptimalPlanChosenForDifferentIndexes(this.grid(0), new String[]{"DTYPES_" + name}, sql, noHints);
        this.checkOptimalPlanChosenForDifferentIndexes(this.grid(0), new String[]{"DTYPES_" + name}, sql, hints);
        this.checkOptimalPlanChosenForDifferentIndexes(this.grid(0), new String[0], sql, wrongHints);
        String sqlMoreCond = sql + " and col_no_index = 213";
        this.checkOptimalPlanChosenForDifferentIndexes(this.grid(0), new String[]{"DTYPES_" + name}, sqlMoreCond, noHints);
        this.checkOptimalPlanChosenForDifferentIndexes(this.grid(0), new String[]{"DTYPES_" + name}, sqlMoreCond, hints);
        this.checkOptimalPlanChosenForDifferentIndexes(this.grid(0), new String[0], sqlMoreCond, wrongHints);
        String descSql = sql + String.format(" order by col_%s desc", name);
        this.checkOptimalPlanChosenForDifferentIndexes(this.grid(0), new String[]{"DTYPES_" + name}, descSql, noHints);
        this.checkOptimalPlanChosenForDifferentIndexes(this.grid(0), new String[]{"DTYPES_" + name}, descSql, hints);
        this.checkOptimalPlanChosenForDifferentIndexes(this.grid(0), new String[0], descSql, wrongHints);
        String descNoIndexSql = sql + " order by col_no_index desc";
        this.checkOptimalPlanChosenForDifferentIndexes(this.grid(0), new String[]{"DTYPES_" + name}, descNoIndexSql, noHints);
        this.checkOptimalPlanChosenForDifferentIndexes(this.grid(0), new String[]{"DTYPES_" + name}, descNoIndexSql, hints);
    }

    @Ignore(value="https://ggsystems.atlassian.net/browse/GG-32021")
    @Test
    public void compareSelectWithBooleanConditions() {
        this.doColumnTests("BOOLEAN", "=", "true");
    }

    @Test
    public void compareSelectWithIntConditions() {
        this.doColumnTests("INT", "<", "-10");
        this.doColumnTests("INT", "<", "10");
        this.doColumnTests("INT", "<=", "2");
        this.doColumnTests("INT", "=", "1");
        this.doColumnTests("INT", ">=", "100");
        this.doColumnTests("INT", ">", "90");
        this.doColumnTests("INT", ">", "190");
    }

    @Test
    public void compareSelectWithTinyintConditions() {
        this.doColumnTests("TINYINT", "<", "-10");
        this.doColumnTests("TINYINT", "<", "10");
        this.doColumnTests("TINYINT", "<=", "10");
        this.doColumnTests("TINYINT", "=", "1");
        this.doColumnTests("TINYINT", ">=", "100");
        this.doColumnTests("TINYINT", ">", "99");
        this.doColumnTests("TINYINT", ">", "110");
    }

    @Test
    public void compareSelectWithSmallintConditions() {
        this.doColumnTests("SMALLINT", "<", "-10");
        this.doColumnTests("SMALLINT", "<", "10");
        this.doColumnTests("SMALLINT", "<=", "10");
        this.doColumnTests("SMALLINT", "=", "1");
        this.doColumnTests("SMALLINT", ">=", "100");
        this.doColumnTests("SMALLINT", ">", "90");
        this.doColumnTests("SMALLINT", ">", "190");
    }

    @Test
    public void compareSelectWithBigintConditions() {
        this.doColumnTests("BIGINT", "<", "-10");
        this.doColumnTests("BIGINT", "<", "10");
        this.doColumnTests("BIGINT", "<=", "10");
        this.doColumnTests("BIGINT", "=", "1");
        this.doColumnTests("BIGINT", ">=", "100");
        this.doColumnTests("BIGINT", ">", "99");
        this.doColumnTests("BIGINT", ">", "199");
    }

    @Test
    public void compareSelectWithDecimalConditions() {
        this.doColumnTests("DECIMAL", "<", "-10");
        this.doColumnTests("DECIMAL", "<", "0.2");
        this.doColumnTests("DECIMAL", "<=", "0.1");
        this.doColumnTests("DECIMAL", "=", "1");
        this.doColumnTests("DECIMAL", ">=", "0.8");
        this.doColumnTests("DECIMAL", ">=", "100");
    }

    @Test
    public void compareSelectWithDoubleConditions() {
        this.doColumnTests("DOUBLE", "<", "-10");
        this.doColumnTests("DOUBLE", "<", "0.2");
        this.doColumnTests("DOUBLE", "<=", "0.2");
        this.doColumnTests("DOUBLE", "=", "1");
        this.doColumnTests("DOUBLE", ">=", "0.8");
        this.doColumnTests("DOUBLE", ">", "0.9");
        this.doColumnTests("DOUBLE", ">=", "100");
    }

    @Test
    public void compareSelectWithRealConditions() throws InterruptedException {
        this.doColumnTests("REAL", "<", "-10");
        this.doColumnTests("REAL", "<", "0.2");
        this.doColumnTests("REAL", "<=", "0.22");
        this.doColumnTests("REAL", "=", "1");
        this.doColumnTests("REAL", ">=", "0.8");
        this.doColumnTests("REAL", ">", "0.9");
        this.doColumnTests("REAL", ">=", "100");
    }

    @Test
    public void compareSelectWithTimeConditions() {
        this.doColumnTests("TIME", "<", "'11:00:02'");
        this.doColumnTests("TIME", "<", "'12:00:02'");
        this.doColumnTests("TIME", "<=", "'12:00:02'");
        this.doColumnTests("TIME", "=", "'12:00:00'");
        this.doColumnTests("TIME", ">=", "'12:01:00'");
        this.doColumnTests("TIME", ">=", "'13:00:00'");
    }

    @Test
    public void compareSelectWithDateConditions() {
        this.doColumnTests("DATE", "<", "'1969-01-03'");
        this.doColumnTests("DATE", "<", "'1970-01-03'");
        this.doColumnTests("DATE", "<=", "'1970-01-02'");
        this.doColumnTests("DATE", "=", "'1970-01-02'");
        this.doColumnTests("DATE", ">=", "'1970-03-03'");
        this.doColumnTests("DATE", ">=", "'1970-09-03'");
    }

    @Test
    public void compareSelectWithTimestampConditions() {
        this.doColumnTests("TIMESTAMP", "<", "'1970-01-01 11:00:09'");
        this.doColumnTests("TIMESTAMP", "<", "'1970-01-01 12:00:09'");
        this.doColumnTests("TIMESTAMP", "<=", "'1970-01-01 12:00:02'");
        this.doColumnTests("TIMESTAMP", "=", "'1970-01-01 12:00:59'");
        this.doColumnTests("TIMESTAMP", ">=", "'1970-01-01 12:01:23'");
        this.doColumnTests("TIMESTAMP", ">=", "'1970-01-01 12:08:23'");
    }

    @Test
    public void compareSelectWithVarcharConditions() {
        this.doColumnTests("VARCHAR", "<", "'a'");
        this.doColumnTests("VARCHAR", "<", "'varchar2'");
        this.doColumnTests("VARCHAR", "<", "'varchar1'");
        this.doColumnTests("VARCHAR", "=", "'test+string'");
        this.doColumnTests("VARCHAR", ">=", "'varchar99'");
        this.doColumnTests("VARCHAR", ">", "'varchar99'");
        this.doColumnTests("VARCHAR", ">", "'varchar199'");
        this.doColumnTests("VARCHAR", ">", "'varchar1'");
    }

    @Test
    public void compareSelectWithCharConditions() {
        this.doColumnTests("CHAR", "<", "'8'");
        this.doColumnTests("CHAR", "<", "'B'");
        this.doColumnTests("CHAR", "<=", "'C'");
        this.doColumnTests("CHAR", "=", "'D'");
        this.doColumnTests("CHAR", ">=", "'W'");
        this.doColumnTests("CHAR", ">", "'Z'");
        this.doColumnTests("CHAR", ">", "'z'");
    }

    @Test
    public void compareSelectWithUuidConditions() {
        this.doColumnTests("UUID", "<=", "'00000000-0000-0000-0000-000000000003'");
        this.doColumnTests("UUID", "<=", "'00000000-0000-0000-0000-000000000001'");
        this.doColumnTests("UUID", "=", "'00000000-0000-0000-0000-000000000002'");
        this.doColumnTests("UUID", ">=", "'00000000-0000-0000-0000-000000000089'");
        this.doColumnTests("UUID", ">=", "'00000000-0000-0000-0000-000000000099'");
        this.doColumnTests("UUID", ">", "'c1707d92-f1ad-11ea-adc1-0242ac120002'");
    }

    @Test
    public void compareSelectWithBinaryConditions() {
        this.doColumnTests("BINARY", "<", "12");
        this.doColumnTests("BINARY", "<=", "13");
        this.doColumnTests("BINARY", "=", "13");
        this.doColumnTests("BINARY", ">=", "85");
        this.doColumnTests("BINARY", ">", "95");
        this.doColumnTests("BINARY", ">=", "1242452143213");
    }
}

