/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.stat;

import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.processors.query.stat.StatisticsAbstractTest;
import org.apache.ignite.internal.processors.query.stat.StatisticsTarget;
import org.junit.Test;

public class PSUStatisticPartialGatheringTest
extends StatisticsAbstractTest {
    private static final String SQL = "select * from TBL_SELECT i1 where lo_select = %d and med_select = %d";
    private static final String[][] NO_HINTS = new String[1][];

    @Override
    protected void beforeTestsStarted() throws Exception {
        Ignite node = this.startGridsMultiThreaded(1);
        node.getOrCreateCache("default");
    }

    protected void beforeTest() throws Exception {
        this.sql("DROP TABLE IF EXISTS TBL_SELECT");
        this.sql("CREATE TABLE TBL_SELECT (ID INT PRIMARY KEY, lo_select int, med_select int, hi_select int)");
        this.sql("CREATE INDEX TBL_SELECT_LO_IDX ON TBL_SELECT(lo_select)");
        this.sql("CREATE INDEX TBL_SELECT_MED_IDX ON TBL_SELECT(med_select)");
        this.sql("CREATE INDEX TBL_SELECT_HI_IDX ON TBL_SELECT(hi_select)");
        for (int i = 0; i < 1000; ++i) {
            this.sql(String.format("insert into tbl_select(id, lo_select, med_select, hi_select) values(%d, %d, %d, %d)", i, i % 10, i % 100, i % 1000));
        }
        this.collectStatistics("tbl_select");
    }

    @Test
    public void compareSelectWithIntConditions() throws IgniteCheckedException {
        System.out.println("+++ " + this.sql("select * from sys.statistics_local_data"));
        this.checkOptimalPlanChosenForDifferentIndexes(this.grid(0), new String[]{"TBL_SELECT_MED_IDX"}, String.format(SQL, 5, 5), NO_HINTS);
        this.sql("UPDATE TBL_SELECT SET lo_select = hi_select");
        this.checkOptimalPlanChosenForDifferentIndexes(this.grid(0), new String[]{"TBL_SELECT_MED_IDX"}, String.format(SQL, 6, 6), NO_HINTS);
        this.updateStatistics(new StatisticsTarget("PUBLIC", "TBL_SELECT", new String[]{"LO_SELECT"}));
        this.checkOptimalPlanChosenForDifferentIndexes(this.grid(0), new String[]{"TBL_SELECT_LO_IDX"}, String.format(SQL, 8, 8), NO_HINTS);
    }
}

