/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.stat;

import java.math.BigDecimal;
import org.apache.ignite.internal.processors.query.h2.IgniteH2Indexing;
import org.apache.ignite.internal.processors.query.stat.ColumnStatistics;
import org.apache.ignite.internal.processors.query.stat.ObjectStatisticsImpl;
import org.apache.ignite.internal.processors.query.stat.StatisticsKey;
import org.apache.ignite.internal.processors.query.stat.StatisticsTypesAbstractTest;
import org.gridgain.internal.h2.value.ValueUuid;
import org.junit.Test;

public class ManagerStatisticsTypesTest
extends StatisticsTypesAbstractTest {
    @Test
    public void testCollectedStatistics() {
        IgniteH2Indexing indexing = (IgniteH2Indexing)this.grid(0).context().query().getIndexing();
        ObjectStatisticsImpl dtypesStat = (ObjectStatisticsImpl)indexing.statsManager().getLocalStatistics(new StatisticsKey("PUBLIC", "DTYPES"));
        ManagerStatisticsTypesTest.assertNotNull((Object)dtypesStat);
        ManagerStatisticsTypesTest.assertEquals((double)149.0, (double)dtypesStat.rowCount());
        ManagerStatisticsTypesTest.assertEquals((int)(TYPES.length + 3), (int)dtypesStat.columnsStatistics().size());
        for (String type : TYPES) {
            String colName = "COL_" + type;
            ColumnStatistics colStat = dtypesStat.columnStatistics(colName);
            ManagerStatisticsTypesTest.assertNotNull((Object)colStat);
            if (colName.equals("COL_GEOMETRY")) {
                ManagerStatisticsTypesTest.assertEquals((String)("Unexpected nulls count for column " + colName), (double)149.0, (double)colStat.nulls());
            } else {
                ManagerStatisticsTypesTest.assertEquals((String)("Unexpected nulls count for column " + colName), (long)50L, (long)colStat.nulls());
            }
            ManagerStatisticsTypesTest.assertEquals((long)dtypesStat.rowCount(), (long)colStat.total());
            ManagerStatisticsTypesTest.assertNotNull((Object)colStat.raw());
            if (colName.equals("COL_GEOMETRY")) {
                ManagerStatisticsTypesTest.assertNull((Object)colStat.min());
                ManagerStatisticsTypesTest.assertNull((Object)colStat.max());
                continue;
            }
            ManagerStatisticsTypesTest.assertNotNull((Object)colStat.min());
            ManagerStatisticsTypesTest.assertNotNull((Object)colStat.max());
        }
    }

    @Test
    public void testBooleanStatistics() {
        String colName = "COL_BOOLEAN";
        ColumnStatistics booleanStats = this.getTypesStats().columnStatistics(colName);
        ManagerStatisticsTypesTest.assertEquals((long)2L, (long)booleanStats.distinct());
        ManagerStatisticsTypesTest.assertFalse((boolean)booleanStats.min().getBoolean());
        ManagerStatisticsTypesTest.assertTrue((boolean)booleanStats.max().getBoolean());
        ManagerStatisticsTypesTest.assertEquals((int)1, (int)booleanStats.size());
    }

    @Test
    public void testIntStatistics() {
        String colName = "COL_INT";
        ColumnStatistics intStats = this.getTypesStats().columnStatistics(colName);
        ManagerStatisticsTypesTest.assertEquals((long)99L, (long)intStats.distinct());
        ManagerStatisticsTypesTest.assertEquals((int)1, (int)intStats.min().getInt());
        ManagerStatisticsTypesTest.assertEquals((int)99, (int)intStats.max().getInt());
        ManagerStatisticsTypesTest.assertEquals((int)4, (int)intStats.size());
    }

    @Test
    public void testTinyintStatistics() {
        String colName = "COL_TINYINT";
        ColumnStatistics tinyintStats = this.getTypesStats().columnStatistics(colName);
        ManagerStatisticsTypesTest.assertEquals((long)99L, (long)tinyintStats.distinct());
        ManagerStatisticsTypesTest.assertEquals((int)1, (int)tinyintStats.min().getShort());
        ManagerStatisticsTypesTest.assertEquals((int)99, (int)tinyintStats.max().getShort());
        ManagerStatisticsTypesTest.assertEquals((int)1, (int)tinyintStats.size());
    }

    @Test
    public void testSmallintStatistics() {
        String colName = "COL_SMALLINT";
        ColumnStatistics smallintStats = this.getTypesStats().columnStatistics(colName);
        ManagerStatisticsTypesTest.assertEquals((long)99L, (long)smallintStats.distinct());
        ManagerStatisticsTypesTest.assertEquals((int)1, (int)smallintStats.min().getShort());
        ManagerStatisticsTypesTest.assertEquals((int)99, (int)smallintStats.max().getShort());
        ManagerStatisticsTypesTest.assertEquals((int)2, (int)smallintStats.size());
    }

    @Test
    public void testBigintStatistics() {
        String colName = "COL_BIGINT";
        ColumnStatistics bigintStats = this.getTypesStats().columnStatistics(colName);
        ManagerStatisticsTypesTest.assertEquals((long)99L, (long)bigintStats.distinct());
        ManagerStatisticsTypesTest.assertEquals((int)1, (int)bigintStats.min().getBigDecimal().intValue());
        ManagerStatisticsTypesTest.assertEquals((int)99, (int)bigintStats.max().getBigDecimal().intValue());
        ManagerStatisticsTypesTest.assertEquals((int)8, (int)bigintStats.size());
    }

    @Test
    public void testDecimalStatistics() {
        String colName = "COL_DECIMAL";
        ColumnStatistics decimalStats = this.getTypesStats().columnStatistics(colName);
        ManagerStatisticsTypesTest.assertEquals((long)99L, (long)decimalStats.distinct());
        ManagerStatisticsTypesTest.assertEquals((Object)new BigDecimal("0.01"), (Object)decimalStats.min().getBigDecimal());
        ManagerStatisticsTypesTest.assertEquals((Object)new BigDecimal("0.99"), (Object)decimalStats.max().getBigDecimal());
        ManagerStatisticsTypesTest.assertEquals((int)2, (int)decimalStats.size());
    }

    @Test
    public void testDoubleStatistics() {
        String colName = "COL_DOUBLE";
        ColumnStatistics doubleStats = this.getTypesStats().columnStatistics(colName);
        ManagerStatisticsTypesTest.assertEquals((long)99L, (long)doubleStats.distinct());
        ManagerStatisticsTypesTest.assertEquals((double)0.01, (double)doubleStats.min().getDouble());
        ManagerStatisticsTypesTest.assertEquals((double)0.99, (double)doubleStats.max().getDouble());
        ManagerStatisticsTypesTest.assertEquals((int)2, (int)doubleStats.size());
    }

    @Test
    public void testRealStatistics() {
        String colName = "COL_REAL";
        ColumnStatistics realStats = this.getTypesStats().columnStatistics(colName);
        ManagerStatisticsTypesTest.assertEquals((long)99L, (long)realStats.distinct());
        ManagerStatisticsTypesTest.assertEquals((Object)new BigDecimal("0.01"), (Object)realStats.min().getBigDecimal());
        ManagerStatisticsTypesTest.assertEquals((Object)new BigDecimal("0.99"), (Object)realStats.max().getBigDecimal());
        ManagerStatisticsTypesTest.assertEquals((int)2, (int)realStats.size());
    }

    @Test
    public void testTimeStatistics() {
        String colName = "COL_TIME";
        ColumnStatistics timeStats = this.getTypesStats().columnStatistics(colName);
        ManagerStatisticsTypesTest.assertEquals((long)99L, (long)timeStats.distinct());
        ManagerStatisticsTypesTest.assertEquals((String)"12:00:01", (String)timeStats.min().getTime().toString());
        ManagerStatisticsTypesTest.assertEquals((String)"12:01:39", (String)timeStats.max().getTime().toString());
        ManagerStatisticsTypesTest.assertEquals((int)4, (int)timeStats.size());
    }

    @Test
    public void testDateStatistics() {
        String colName = "COL_DATE";
        ColumnStatistics dateStats = this.getTypesStats().columnStatistics(colName);
        ManagerStatisticsTypesTest.assertEquals((long)99L, (long)dateStats.distinct());
        ManagerStatisticsTypesTest.assertEquals((String)"1970-01-02", (String)dateStats.min().getDate().toString());
        ManagerStatisticsTypesTest.assertEquals((String)"1970-04-10", (String)dateStats.max().getDate().toString());
        ManagerStatisticsTypesTest.assertEquals((int)4, (int)dateStats.size());
    }

    @Test
    public void testTimestampStatistics() {
        String colName = "COL_TIMESTAMP";
        ColumnStatistics timestampStats = this.getTypesStats().columnStatistics(colName);
        ManagerStatisticsTypesTest.assertEquals((long)99L, (long)timestampStats.distinct());
        ManagerStatisticsTypesTest.assertEquals((String)"1970-01-01 12:00:01.0", (String)timestampStats.min().getTimestamp().toString());
        ManagerStatisticsTypesTest.assertEquals((String)"1970-01-01 12:01:39.0", (String)timestampStats.max().getTimestamp().toString());
        ManagerStatisticsTypesTest.assertEquals((int)4, (int)timestampStats.size());
    }

    @Test
    public void testVarcharStatistics() {
        String colName = "COL_VARCHAR";
        ColumnStatistics varcharStats = this.getTypesStats().columnStatistics(colName);
        ManagerStatisticsTypesTest.assertEquals((long)99L, (long)varcharStats.distinct());
        ManagerStatisticsTypesTest.assertEquals((String)"varchar1", (String)varcharStats.min().getString());
        ManagerStatisticsTypesTest.assertEquals((String)"varchar99", (String)varcharStats.max().getString());
        ManagerStatisticsTypesTest.assertEquals((int)8, (int)varcharStats.size());
    }

    @Test
    public void testCharStatistics() {
        String colName = "COL_CHAR";
        ColumnStatistics charStats = this.getTypesStats().columnStatistics(colName);
        ManagerStatisticsTypesTest.assertEquals((long)26L, (long)charStats.distinct());
        ManagerStatisticsTypesTest.assertEquals((char)'A', (char)charStats.min().getString().charAt(0));
        ManagerStatisticsTypesTest.assertEquals((char)'Z', (char)charStats.max().getString().charAt(0));
        ManagerStatisticsTypesTest.assertEquals((int)1, (int)charStats.size());
    }

    @Test
    public void testUUIDStatistics() {
        String colName = "COL_UUID";
        ColumnStatistics decimalStats = this.getTypesStats().columnStatistics(colName);
        ManagerStatisticsTypesTest.assertEquals((long)99L, (long)decimalStats.distinct());
        ManagerStatisticsTypesTest.assertEquals((long)1L, (long)((ValueUuid)decimalStats.min()).getLow());
        ManagerStatisticsTypesTest.assertEquals((long)99L, (long)((ValueUuid)decimalStats.max()).getLow());
        ManagerStatisticsTypesTest.assertEquals((int)16, (int)decimalStats.size());
    }

    @Test
    public void testBinaryStatistics() {
        String colName = "COL_BINARY";
        ColumnStatistics binaryStats = this.getTypesStats().columnStatistics(colName);
        ManagerStatisticsTypesTest.assertEquals((long)99L, (long)binaryStats.distinct());
        ManagerStatisticsTypesTest.assertEquals((byte)1, (byte)binaryStats.min().getBytes()[3]);
        ManagerStatisticsTypesTest.assertEquals((byte)99, (byte)binaryStats.max().getBytes()[3]);
        ManagerStatisticsTypesTest.assertEquals((int)4, (int)binaryStats.size());
    }

    private ObjectStatisticsImpl getTypesStats() {
        return (ObjectStatisticsImpl)this.statisticsMgr(0).getLocalStatistics(new StatisticsKey("PUBLIC", "DTYPES"));
    }
}

