/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.stat;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import org.apache.ignite.internal.processors.query.stat.Hasher;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.junit.Test;

public class HasherSelfTest
extends GridCommonAbstractTest {
    @Test
    public void testCornerCaseSizedArray() {
        Hasher h = new Hasher();
        ArrayList<Long> list = new ArrayList<Long>();
        list.add(h.fastHash(new byte[0]));
        list.add(h.fastHash(new byte[]{1}));
        list.add(h.fastHash(new byte[]{1, 2, 3, 4}));
        list.add(h.fastHash(new byte[]{1, 2, 3, 4, 5, 6, 7}));
        list.add(h.fastHash(new byte[]{1, 2, 3, 4, 5, 6, 7, 8}));
        list.add(h.fastHash(new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9}));
        list.add(h.fastHash(new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15}));
        list.add(h.fastHash(new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16}));
        list.add(h.fastHash(new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17}));
        HashSet<Long> set = new HashSet<Long>();
        set.addAll(list);
        HasherSelfTest.assertEquals((int)list.size(), (int)set.size());
    }

    @Test
    public void testRandomHash() {
        Hasher h = new Hasher();
        Random r = new Random();
        int testSize = 100;
        HashMap<byte[], Long> hashes = new HashMap<byte[], Long>(testSize);
        for (int i = 0; i < testSize; ++i) {
            byte[] arr = new byte[r.nextInt(1000)];
            r.nextBytes(arr);
            hashes.put(arr, h.fastHash(arr));
        }
        for (Map.Entry entry : hashes.entrySet()) {
            HasherSelfTest.assertEquals((long)((Long)entry.getValue()), (long)h.fastHash((byte[])entry.getKey()));
        }
    }
}

