/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.stat;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.ignite.internal.processors.query.stat.ColumnStatistics;
import org.apache.ignite.internal.processors.query.stat.ColumnStatisticsCollector;
import org.apache.ignite.internal.processors.query.stat.hll.HLL;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.gridgain.internal.h2.value.Value;
import org.gridgain.internal.h2.value.ValueDecimal;
import org.junit.Test;

public class ColumnStatisticsCollectorAggregationTest
extends GridCommonAbstractTest {
    private static final Comparator<Value> DECIMAL_VALUE_COMPARATOR = (v1, v2) -> v1.getBigDecimal().compareTo(v2.getBigDecimal());

    @Test
    public void aggregateSingleTest() {
        ArrayList<ColumnStatistics> statistics = new ArrayList<ColumnStatistics>();
        ColumnStatistics stat1 = new ColumnStatistics(null, null, 100L, 0L, 100L, 0, this.getHLL(-1).toBytes(), 0L, U.currentTimeMillis());
        statistics.add(stat1);
        ColumnStatistics res = ColumnStatisticsCollector.aggregate(DECIMAL_VALUE_COMPARATOR, statistics, null);
        ColumnStatisticsCollectorAggregationTest.assertEquals((Object)stat1, (Object)res);
    }

    @Test
    public void aggregateNullTest() {
        ArrayList<ColumnStatistics> statistics = new ArrayList<ColumnStatistics>();
        ColumnStatistics stat1 = new ColumnStatistics(null, null, 100L, 0L, 100L, 0, this.getHLL(-1).toBytes(), 0L, U.currentTimeMillis());
        ColumnStatistics stat2 = new ColumnStatistics(null, null, 100L, 0L, 10L, 0, this.getHLL(-1).toBytes(), 0L, U.currentTimeMillis());
        statistics.add(stat1);
        statistics.add(stat2);
        ColumnStatistics res = ColumnStatisticsCollector.aggregate(DECIMAL_VALUE_COMPARATOR, statistics, null);
        ColumnStatisticsCollectorAggregationTest.assertNull((Object)res.min());
        ColumnStatisticsCollectorAggregationTest.assertNull((Object)res.max());
        ColumnStatisticsCollectorAggregationTest.assertEquals((long)200L, (long)res.nulls());
        ColumnStatisticsCollectorAggregationTest.assertEquals((long)0L, (long)res.distinct());
        ColumnStatisticsCollectorAggregationTest.assertEquals((long)110L, (long)res.total());
        ColumnStatisticsCollectorAggregationTest.assertEquals((int)0, (int)res.size());
        ColumnStatisticsCollectorAggregationTest.assertNotNull((Object)res.raw());
    }

    @Test
    public void aggregateTest() {
        ArrayList<ColumnStatistics> statistics = new ArrayList<ColumnStatistics>();
        ColumnStatistics stat1 = new ColumnStatistics((Value)ValueDecimal.get((BigDecimal)BigDecimal.ONE), (Value)ValueDecimal.get((BigDecimal)BigDecimal.TEN), 50L, 10L, 1000L, 0, this.getHLL(50).toBytes(), 0L, U.currentTimeMillis());
        ColumnStatistics stat2 = new ColumnStatistics((Value)ValueDecimal.get((BigDecimal)BigDecimal.ZERO), (Value)ValueDecimal.get((BigDecimal)BigDecimal.ONE), 10L, 100L, 10L, 0, this.getHLL(9).toBytes(), 0L, U.currentTimeMillis());
        statistics.add(stat1);
        statistics.add(stat2);
        ColumnStatistics res = ColumnStatisticsCollector.aggregate(DECIMAL_VALUE_COMPARATOR, statistics, null);
        ColumnStatisticsCollectorAggregationTest.assertEquals((Object)ValueDecimal.get((BigDecimal)BigDecimal.ZERO), (Object)res.min());
        ColumnStatisticsCollectorAggregationTest.assertEquals((Object)ValueDecimal.get((BigDecimal)BigDecimal.TEN), (Object)res.max());
        ColumnStatisticsCollectorAggregationTest.assertEquals((long)60L, (long)res.nulls());
        ColumnStatisticsCollectorAggregationTest.assertEquals((long)59L, (long)res.distinct());
        ColumnStatisticsCollectorAggregationTest.assertEquals((long)1010L, (long)res.total());
        ColumnStatisticsCollectorAggregationTest.assertEquals((int)0, (int)res.size());
        ColumnStatisticsCollectorAggregationTest.assertNotNull((Object)res.raw());
    }

    private HLL getHLL(int uniq) {
        HLL res = new HLL(13, 5);
        ThreadLocalRandom r = ThreadLocalRandom.current();
        for (int i = 0; i < uniq; ++i) {
            res.addRaw(((Random)r).nextLong());
        }
        return res;
    }
}

