/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.oom;

import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.cache.query.exceptions.SqlMemoryQuotaExceededException;
import org.apache.ignite.internal.processors.query.oom.AbstractMemoryQuotaStaticConfigurationTest;
import org.apache.ignite.internal.processors.query.oom.DiskSpillingAbstractTest;
import org.junit.Test;

public class MemoryQuotaStaticConfigurationTest
extends AbstractMemoryQuotaStaticConfigurationTest {
    private static String qryMore60Percent;
    private static String qry50Percent;
    private static String qry25Percent;
    private static String qry10Percent;

    @Override
    protected boolean startClient() {
        return true;
    }

    @Override
    protected boolean fromClient() {
        return true;
    }

    @Override
    protected void beforeTestsStarted() throws Exception {
        this.initGrid("0", "50%", false);
        String qry = "SELECT listagg(p1.name), listagg(p1.name), listagg(p1.name), listagg(p1.name), listagg(p1.name), listagg(p1.name), listagg(p1.name), listagg(p1.name), listagg(p1.name), listagg(p1.name), listagg(p1.name), listagg(p1.name) FROM person p1 JOIN person p2 WHERE p1.id < ";
        int param = 0;
        for (int i = 1002; i >= 0; i -= 100) {
            try {
                this.grid("client").cache("default").query(new SqlFieldsQuery(qry + i).setLazy(true)).getAll();
                param = i;
                break;
            }
            catch (SqlMemoryQuotaExceededException e) {
                MemoryQuotaStaticConfigurationTest.assertTrue((String)("Wrong message:" + e.getMessage()), (boolean)e.getMessage().contains("Query quota was exceeded."));
                continue;
            }
        }
        if (param <= 0 || param >= 1002) {
            throw new IllegalStateException("Can not start test, quota can not be determined. Consider changing the query. Query parameter=" + param);
        }
        qry50Percent = qry + param;
        qry25Percent = qry + param / 2;
        qry10Percent = qry + param / 5;
        qryMore60Percent = qry + 1002;
        if (log.isInfoEnabled()) {
            log.info("Query with memory consumption more than 60%: " + qryMore60Percent);
            log.info("Query with memory consumption a bit less than 50%: " + qry50Percent);
            log.info("Query with memory consumption about 25%: " + qry25Percent);
            log.info("Query with memory consumption about 10%: " + qry10Percent);
        }
        this.afterTest();
    }

    @Test
    public void testDefaults() throws Exception {
        this.initGrid(null, null, null);
        this.checkQuery(DiskSpillingAbstractTest.Result.SUCCESS_NO_OFFLOADING, qry50Percent);
        this.checkQuery(DiskSpillingAbstractTest.Result.ERROR_GLOBAL_QUOTA, qryMore60Percent);
        this.checkQuery(DiskSpillingAbstractTest.Result.SUCCESS_NO_OFFLOADING, qry10Percent, 4, 1);
        this.checkQuery(DiskSpillingAbstractTest.Result.ERROR_GLOBAL_QUOTA, qry25Percent, 4, 1);
    }

    @Test
    public void testOffloadingEnabled() throws Exception {
        this.initGrid("60%", null, true);
        this.checkQuery(DiskSpillingAbstractTest.Result.SUCCESS_NO_OFFLOADING, qry50Percent);
        this.checkQuery(DiskSpillingAbstractTest.Result.SUCCESS_WITH_OFFLOADING, qryMore60Percent);
        this.checkQuery(DiskSpillingAbstractTest.Result.SUCCESS_WITH_OFFLOADING, qry50Percent, 2, 1);
    }

    @Test
    public void testQueryQuota() throws Exception {
        this.initGrid("0", "60%", null);
        this.checkQuery(DiskSpillingAbstractTest.Result.SUCCESS_NO_OFFLOADING, qry25Percent, 2, 1);
        this.checkQuery(DiskSpillingAbstractTest.Result.SUCCESS_NO_OFFLOADING, qry50Percent, 2, 1);
    }

    @Test
    public void testGlobalQuotaOverride() throws Exception {
        this.initGrid(null, "1024", null);
        this.checkQuery(DiskSpillingAbstractTest.Result.ERROR_QUERY_QUOTA, qry25Percent, 2, 1);
    }

    @Test
    public void testOffloadingWithPerQueryQuota() throws Exception {
        this.initGrid("0", "60%", true);
        this.checkQuery(DiskSpillingAbstractTest.Result.SUCCESS_NO_OFFLOADING, qry25Percent, 1, 1);
        this.checkQuery(DiskSpillingAbstractTest.Result.SUCCESS_WITH_OFFLOADING, qryMore60Percent, 2, 1);
    }

    @Test
    public void testLegacyOffloadPropertyNotSupported() throws Exception {
        System.setProperty("IGNITE_SQL_USE_DISK_OFFLOAD", "true");
        try {
            this.initGrid(null, null, null);
            this.checkQuery(DiskSpillingAbstractTest.Result.ERROR_GLOBAL_QUOTA, qryMore60Percent);
        }
        finally {
            System.clearProperty("IGNITE_SQL_USE_DISK_OFFLOAD");
        }
    }

    @Test
    public void testLegacyGlobalQuotaPropertyNotSupported() throws Exception {
        System.setProperty("IGNITE_DEFAULT_SQL_MEMORY_POOL_SIZE", "0");
        try {
            this.initGrid(null, null, null);
            this.checkQuery(DiskSpillingAbstractTest.Result.ERROR_GLOBAL_QUOTA, qryMore60Percent);
        }
        finally {
            System.clearProperty("IGNITE_SQL_USE_DISK_OFFLOAD");
        }
    }

    @Test
    public void testLegacyQueryQuotaPropertyNotSupported() throws Exception {
        System.setProperty("IGNITE_DEFAULT_SQL_QUERY_MEMORY_LIMIT", "1024");
        try {
            this.initGrid(null, null, null);
            this.checkQuery(DiskSpillingAbstractTest.Result.SUCCESS_NO_OFFLOADING, qry25Percent);
        }
        finally {
            System.clearProperty("IGNITE_SQL_USE_DISK_OFFLOAD");
        }
    }
}

