/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.oom;

import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.cache.query.exceptions.SqlMemoryQuotaExceededException;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.processors.query.h2.QueryMemoryManager;
import org.apache.ignite.internal.processors.query.oom.AbstractMemoryQuotaStaticConfigurationTest;
import org.apache.ignite.internal.processors.query.oom.DiskSpillingAbstractTest;
import org.apache.ignite.internal.util.typedef.G;
import org.apache.ignite.testframework.GridTestUtils;
import org.junit.Test;

public class MemoryQuotaStaticAndDynamicConfigurationTest
extends AbstractMemoryQuotaStaticConfigurationTest {
    @Test
    public void testGlobalQuota() throws Exception {
        this.initGrid("0", "0", null);
        String qry = "SELECT * FROM person ORDER BY name";
        this.checkQuery(DiskSpillingAbstractTest.Result.SUCCESS_NO_OFFLOADING, "SELECT * FROM person ORDER BY name");
        this.setGlobalQuota("100");
        this.checkQuery(DiskSpillingAbstractTest.Result.ERROR_GLOBAL_QUOTA, "SELECT * FROM person ORDER BY name");
        this.setGlobalQuota("0");
        this.checkQuery(DiskSpillingAbstractTest.Result.SUCCESS_NO_OFFLOADING, "SELECT * FROM person ORDER BY name");
    }

    @Test
    public void testOffloading() throws Exception {
        this.initGrid("0", "0", null);
        String qry = "SELECT * FROM person ORDER BY name";
        this.checkQuery(DiskSpillingAbstractTest.Result.SUCCESS_NO_OFFLOADING, "SELECT * FROM person ORDER BY name");
        this.setDefaultQueryQuota("100");
        this.checkQuery(DiskSpillingAbstractTest.Result.ERROR_QUERY_QUOTA, "SELECT * FROM person ORDER BY name");
        this.setDefaultQueryQuota("0");
        this.checkQuery(DiskSpillingAbstractTest.Result.SUCCESS_NO_OFFLOADING, "SELECT * FROM person ORDER BY name");
    }

    @Test
    public void testQueryQuota() throws Exception {
        this.initGrid("0", "0", null);
        String qry = "SELECT * FROM person ORDER BY name";
        this.checkQuery(DiskSpillingAbstractTest.Result.SUCCESS_NO_OFFLOADING, "SELECT * FROM person ORDER BY name");
        this.setDefaultQueryQuota("100");
        this.checkQuery(DiskSpillingAbstractTest.Result.ERROR_QUERY_QUOTA, "SELECT * FROM person ORDER BY name");
        this.setDefaultQueryQuota("0");
        this.checkQuery(DiskSpillingAbstractTest.Result.SUCCESS_NO_OFFLOADING, "SELECT * FROM person ORDER BY name");
    }

    @Test
    public void testOffloadingEnabledByDefault() throws Exception {
        this.initGrid(null, "100", true);
        String qry = "SELECT * FROM person ORDER BY id";
        this.checkQuery(DiskSpillingAbstractTest.Result.SUCCESS_WITH_OFFLOADING, "SELECT * FROM person ORDER BY id");
        this.setOffloadingEnabled(false);
        this.checkQuery(DiskSpillingAbstractTest.Result.ERROR_QUERY_QUOTA, "SELECT * FROM person ORDER BY id");
        this.setOffloadingEnabled(true);
        this.checkQuery(DiskSpillingAbstractTest.Result.SUCCESS_WITH_OFFLOADING, "SELECT * FROM person ORDER BY id");
    }

    @Test
    public void testTwoNodesDifferentSettings() throws Exception {
        this.initGrid(null, null, null);
        this.startGrid(1);
        this.awaitPartitionMapExchange();
        String qry = "SELECT * FROM person ORDER BY name";
        this.grid(1).cache("default").query(new SqlFieldsQuery("SELECT * FROM person ORDER BY name").setLocal(true)).getAll();
        this.grid(1).cache("default").query(new SqlFieldsQuery("SELECT * FROM person ORDER BY name").setLocal(true)).getAll();
        this.memoryManager(this.grid(0)).setQueryQuota("10");
        GridTestUtils.assertThrows((IgniteLogger)log, () -> this.grid(0).cache("default").query(new SqlFieldsQuery("SELECT * FROM person ORDER BY name").setLocal(true)).getAll(), SqlMemoryQuotaExceededException.class, (String)"SQL query ran out of memory: Query quota was exceeded.");
        this.grid(1).cache("default").query(new SqlFieldsQuery("SELECT * FROM person ORDER BY name").setLocal(true)).getAll();
    }

    private void setGlobalQuota(String newQuota) {
        for (Ignite node : G.allGrids()) {
            QueryMemoryManager memMgr = this.memoryManager((IgniteEx)node);
            memMgr.setGlobalQuota(newQuota);
        }
    }

    private void setDefaultQueryQuota(String newQuota) {
        for (Ignite node : G.allGrids()) {
            QueryMemoryManager memMgr = this.memoryManager((IgniteEx)node);
            memMgr.setQueryQuota(newQuota);
        }
    }

    private void setOffloadingEnabled(boolean enabled) {
        for (Ignite node : G.allGrids()) {
            QueryMemoryManager memMgr = this.memoryManager((IgniteEx)node);
            memMgr.setOffloadingEnabled(enabled);
        }
    }
}

