/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.oom;

import org.apache.ignite.Ignite;
import org.apache.ignite.cache.query.exceptions.SqlMemoryQuotaExceededException;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.processors.cache.query.IgniteQueryErrorCode;
import org.apache.ignite.internal.processors.query.h2.H2ManagedLocalResult;
import org.apache.ignite.internal.processors.query.h2.IgniteH2Indexing;
import org.apache.ignite.internal.processors.query.h2.QueryMemoryManager;
import org.apache.ignite.internal.processors.query.oom.AbstractQueryMemoryTrackerSelfTest;
import org.apache.ignite.internal.util.typedef.G;
import org.apache.ignite.internal.util.typedef.X;
import org.junit.Test;

public class MemoryQuotaDynamicConfigurationTest
extends AbstractQueryMemoryTrackerSelfTest {
    private static final long GLOBAL_QUOTA = 51200L;

    @Override
    protected boolean isLocal() {
        return false;
    }

    @Override
    protected long globalQuotaSize() {
        return 51200L;
    }

    @Override
    protected boolean startClient() {
        return true;
    }

    @Test
    public void testGlobalQuota() throws Exception {
        this.maxMem = 0L;
        this.setGlobalQuota(51200L);
        this.checkQueryExpectOOM("select * from K ORDER BY K.indexed", false);
        MemoryQuotaDynamicConfigurationTest.assertEquals((int)1, (int)localResults.size());
        MemoryQuotaDynamicConfigurationTest.assertTrue((((H2ManagedLocalResult)localResults.get(0)).memoryReserved() < 51200L ? 1 : 0) != 0);
        this.clearResults();
        this.setGlobalQuota(0L);
        this.execQuery("select * from K ORDER BY K.indexed", false);
        MemoryQuotaDynamicConfigurationTest.assertEquals((int)2, (int)localResults.size());
        MemoryQuotaDynamicConfigurationTest.assertTrue((((H2ManagedLocalResult)localResults.get(0)).memoryReserved() > 51200L ? 1 : 0) != 0);
        this.clearResults();
        this.setGlobalQuota(51200L);
        this.checkQueryExpectOOM("select * from K ORDER BY K.indexed", false);
        MemoryQuotaDynamicConfigurationTest.assertEquals((int)1, (int)localResults.size());
        MemoryQuotaDynamicConfigurationTest.assertTrue((((H2ManagedLocalResult)localResults.get(0)).memoryReserved() < 51200L ? 1 : 0) != 0);
    }

    @Test
    public void testDefaultQueryQuota() throws Exception {
        this.maxMem = 0L;
        this.setGlobalQuota(0L);
        this.execQuery("select * from K ORDER BY K.indexed", false);
        MemoryQuotaDynamicConfigurationTest.assertEquals((int)2, (int)localResults.size());
        MemoryQuotaDynamicConfigurationTest.assertTrue((((H2ManagedLocalResult)localResults.get(0)).memoryReserved() > 51200L ? 1 : 0) != 0);
        this.clearResults();
        this.setDefaultQueryQuota(100L);
        this.checkQueryExpectOOM("select * from K ORDER BY K.indexed", false);
        MemoryQuotaDynamicConfigurationTest.assertEquals((int)1, (int)localResults.size());
        this.clearResults();
        this.setOffloadingEnabled(true);
        this.execQuery("select * from K ORDER BY K.indexed", false);
        MemoryQuotaDynamicConfigurationTest.assertEquals((int)2, (int)localResults.size());
        MemoryQuotaDynamicConfigurationTest.assertTrue((((H2ManagedLocalResult)localResults.get(0)).memoryReserved() < 100L ? 1 : 0) != 0);
        this.clearResults();
        this.setOffloadingEnabled(false);
        this.checkQueryExpectOOM("select * from K ORDER BY K.indexed", false);
        MemoryQuotaDynamicConfigurationTest.assertEquals((int)1, (int)localResults.size());
        this.clearResults();
        this.setDefaultQueryQuota(0L);
        this.execQuery("select * from K ORDER BY K.indexed", false);
        MemoryQuotaDynamicConfigurationTest.assertEquals((int)2, (int)localResults.size());
        MemoryQuotaDynamicConfigurationTest.assertTrue((((H2ManagedLocalResult)localResults.get(0)).memoryReserved() > 51200L ? 1 : 0) != 0);
    }

    private void setGlobalQuota(long newQuota) {
        for (Ignite node : G.allGrids()) {
            QueryMemoryManager memMgr = MemoryQuotaDynamicConfigurationTest.memoryManager((IgniteEx)node);
            memMgr.setGlobalQuota(String.valueOf(newQuota));
        }
    }

    private void setDefaultQueryQuota(long newQuota) {
        for (Ignite node : G.allGrids()) {
            QueryMemoryManager memMgr = MemoryQuotaDynamicConfigurationTest.memoryManager((IgniteEx)node);
            memMgr.setQueryQuota(String.valueOf(newQuota));
        }
    }

    private void setOffloadingEnabled(boolean enabled) {
        for (Ignite node : G.allGrids()) {
            QueryMemoryManager memMgr = MemoryQuotaDynamicConfigurationTest.memoryManager((IgniteEx)node);
            memMgr.setOffloadingEnabled(enabled);
        }
    }

    private static QueryMemoryManager memoryManager(IgniteEx node) {
        return ((IgniteH2Indexing)node.context().query().getIndexing()).memoryManager();
    }

    @Override
    protected void checkQueryExpectOOM(String sql, boolean lazy) {
        try {
            this.execQuery(sql, lazy);
            MemoryQuotaDynamicConfigurationTest.fail((String)"Exception is not thrown.");
        }
        catch (SqlMemoryQuotaExceededException e) {
            MemoryQuotaDynamicConfigurationTest.assertTrue((boolean)e.getMessage().contains("SQL query ran out of memory: "));
            MemoryQuotaDynamicConfigurationTest.assertEquals((int)3015, (int)e.statusCode());
            MemoryQuotaDynamicConfigurationTest.assertEquals((String)IgniteQueryErrorCode.codeToSqlState((int)3015), (String)e.sqlState());
        }
        catch (Exception e) {
            MemoryQuotaDynamicConfigurationTest.fail((String)("Wrong exception: " + X.getFullStackTrace((Throwable)e)));
        }
    }
}

