/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.oom;

import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cache.query.exceptions.SqlMemoryQuotaExceededException;
import org.apache.ignite.internal.processors.query.h2.H2MemoryTracker;
import org.apache.ignite.internal.processors.query.h2.QueryMemoryTracker;
import org.apache.ignite.testframework.GridTestUtils;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.junit.Test;

public class GridQueryMemoryMetricProviderSelfTest
extends GridCommonAbstractTest {
    @Test
    public void testInitialState() {
        QueryMemoryTracker tracker = new QueryMemoryTracker(null, 128L, 256L, true);
        GridQueryMemoryMetricProviderSelfTest.assertEquals((long)0L, (long)tracker.reserved());
        GridQueryMemoryMetricProviderSelfTest.assertEquals((long)0L, (long)tracker.maxReserved());
        GridQueryMemoryMetricProviderSelfTest.assertEquals((long)0L, (long)tracker.writtenOnDisk());
        GridQueryMemoryMetricProviderSelfTest.assertEquals((long)0L, (long)tracker.maxWrittenOnDisk());
        GridQueryMemoryMetricProviderSelfTest.assertEquals((long)0L, (long)tracker.totalWrittenOnDisk());
    }

    @Test
    public void testMemoryReservation() {
        QueryMemoryTracker tracker = new QueryMemoryTracker(null, 128L, 256L, true);
        GridQueryMemoryMetricProviderSelfTest.assertTrue((boolean)tracker.reserve(52L));
        GridQueryMemoryMetricProviderSelfTest.assertEquals((long)52L, (long)tracker.reserved());
        GridQueryMemoryMetricProviderSelfTest.assertEquals((long)52L, (long)tracker.maxReserved());
        GridQueryMemoryMetricProviderSelfTest.assertTrue((boolean)tracker.reserve(30L));
        GridQueryMemoryMetricProviderSelfTest.assertEquals((long)82L, (long)tracker.reserved());
        GridQueryMemoryMetricProviderSelfTest.assertEquals((long)82L, (long)tracker.maxReserved());
        tracker.release(30L);
        GridQueryMemoryMetricProviderSelfTest.assertEquals((long)52L, (long)tracker.reserved());
        GridQueryMemoryMetricProviderSelfTest.assertEquals((long)82L, (long)tracker.maxReserved());
        GridQueryMemoryMetricProviderSelfTest.assertTrue((boolean)tracker.reserve(10L));
        GridQueryMemoryMetricProviderSelfTest.assertEquals((long)62L, (long)tracker.reserved());
        GridQueryMemoryMetricProviderSelfTest.assertEquals((long)82L, (long)tracker.maxReserved());
        GridQueryMemoryMetricProviderSelfTest.assertFalse((boolean)tracker.reserve(200L));
        GridQueryMemoryMetricProviderSelfTest.assertEquals((long)262L, (long)tracker.reserved());
        GridQueryMemoryMetricProviderSelfTest.assertEquals((long)262L, (long)tracker.maxReserved());
        GridTestUtils.assertThrows((IgniteLogger)log, () -> new QueryMemoryTracker(null, 128L, 256L, false).reserve(512L), SqlMemoryQuotaExceededException.class, (String)"SQL query ran out of memory: Query quota was exceeded.");
    }

    @Test
    public void testDiskOffloading() {
        QueryMemoryTracker tracker = new QueryMemoryTracker(null, 128L, 256L, true);
        tracker.spill(52L);
        GridQueryMemoryMetricProviderSelfTest.assertEquals((long)52L, (long)tracker.writtenOnDisk());
        GridQueryMemoryMetricProviderSelfTest.assertEquals((long)52L, (long)tracker.maxWrittenOnDisk());
        GridQueryMemoryMetricProviderSelfTest.assertEquals((long)52L, (long)tracker.totalWrittenOnDisk());
        tracker.spill(30L);
        GridQueryMemoryMetricProviderSelfTest.assertEquals((long)82L, (long)tracker.writtenOnDisk());
        GridQueryMemoryMetricProviderSelfTest.assertEquals((long)82L, (long)tracker.maxWrittenOnDisk());
        GridQueryMemoryMetricProviderSelfTest.assertEquals((long)82L, (long)tracker.totalWrittenOnDisk());
        tracker.unspill(30L);
        GridQueryMemoryMetricProviderSelfTest.assertEquals((long)52L, (long)tracker.writtenOnDisk());
        GridQueryMemoryMetricProviderSelfTest.assertEquals((long)82L, (long)tracker.maxWrittenOnDisk());
        GridQueryMemoryMetricProviderSelfTest.assertEquals((long)82L, (long)tracker.totalWrittenOnDisk());
        tracker.spill(10L);
        GridQueryMemoryMetricProviderSelfTest.assertEquals((long)62L, (long)tracker.writtenOnDisk());
        GridQueryMemoryMetricProviderSelfTest.assertEquals((long)82L, (long)tracker.maxWrittenOnDisk());
        GridQueryMemoryMetricProviderSelfTest.assertEquals((long)92L, (long)tracker.totalWrittenOnDisk());
    }

    @Test
    public void testParentTracker() {
        final AtomicBoolean shouldFail = new AtomicBoolean();
        final AtomicBoolean quotaExceeded = new AtomicBoolean();
        H2MemoryTracker parent = new H2MemoryTracker(){
            private long reserved;

            public boolean reserve(long size) {
                if (shouldFail.get()) {
                    throw new IgniteException("Test exception");
                }
                if (quotaExceeded.get()) {
                    return false;
                }
                this.reserved += size;
                return true;
            }

            public void release(long size) {
                this.reserved -= size;
            }

            public long writtenOnDisk() {
                return 0L;
            }

            public long totalWrittenOnDisk() {
                return 0L;
            }

            public long reserved() {
                return this.reserved;
            }

            public void spill(long size) {
            }

            public void unspill(long size) {
            }

            public void incrementFilesCreated() {
            }

            public H2MemoryTracker createChildTracker() {
                return null;
            }

            public void onChildClosed(H2MemoryTracker child) {
            }

            public boolean closed() {
                return false;
            }

            public void close() {
            }
        };
        long blockSize = 256L;
        long quota = 3L * blockSize + 16L;
        QueryMemoryTracker tracker = new QueryMemoryTracker(parent, quota, blockSize, true);
        GridQueryMemoryMetricProviderSelfTest.assertTrue((boolean)tracker.reserve(42L));
        GridQueryMemoryMetricProviderSelfTest.assertEquals((long)blockSize, (long)parent.reserved());
        GridQueryMemoryMetricProviderSelfTest.assertTrue((boolean)tracker.reserve(42L));
        GridQueryMemoryMetricProviderSelfTest.assertEquals((long)256L, (long)parent.reserved());
        GridQueryMemoryMetricProviderSelfTest.assertTrue((boolean)tracker.reserve(500L));
        GridQueryMemoryMetricProviderSelfTest.assertEquals((long)584L, (long)parent.reserved());
        GridQueryMemoryMetricProviderSelfTest.assertTrue((boolean)tracker.reserve(42L));
        GridQueryMemoryMetricProviderSelfTest.assertEquals((long)784L, (long)parent.reserved());
        tracker.release(200L);
        GridQueryMemoryMetricProviderSelfTest.assertEquals((long)426L, (long)parent.reserved());
        quotaExceeded.set(true);
        GridQueryMemoryMetricProviderSelfTest.assertFalse((boolean)tracker.reserve(42L));
        shouldFail.set(true);
        GridTestUtils.assertThrows((IgniteLogger)log, () -> tracker.reserve(42L), IgniteException.class, (String)"Test exception");
    }

    @Test
    public void testChildTracker() {
        QueryMemoryTracker tracker = new QueryMemoryTracker(null, 1024L, 0L, false);
        H2MemoryTracker child1 = tracker.createChildTracker();
        H2MemoryTracker child2 = tracker.createChildTracker();
        GridQueryMemoryMetricProviderSelfTest.assertTrue((boolean)child1.reserve(200L));
        GridQueryMemoryMetricProviderSelfTest.assertEquals((long)200L, (long)child1.reserved());
        GridQueryMemoryMetricProviderSelfTest.assertEquals((long)0L, (long)child2.reserved());
        GridQueryMemoryMetricProviderSelfTest.assertEquals((long)200L, (long)tracker.reserved());
        GridQueryMemoryMetricProviderSelfTest.assertTrue((boolean)child2.reserve(800L));
        GridQueryMemoryMetricProviderSelfTest.assertEquals((long)200L, (long)child1.reserved());
        GridQueryMemoryMetricProviderSelfTest.assertEquals((long)800L, (long)child2.reserved());
        GridQueryMemoryMetricProviderSelfTest.assertEquals((long)1000L, (long)tracker.reserved());
        GridTestUtils.assertThrowsWithCause(() -> child1.reserve(200L), SqlMemoryQuotaExceededException.class);
        GridQueryMemoryMetricProviderSelfTest.assertEquals((long)400L, (long)child1.reserved());
        GridQueryMemoryMetricProviderSelfTest.assertEquals((long)800L, (long)child2.reserved());
        GridQueryMemoryMetricProviderSelfTest.assertEquals((long)1200L, (long)tracker.reserved());
        child1.release(300L);
        GridQueryMemoryMetricProviderSelfTest.assertEquals((long)100L, (long)child1.reserved());
        GridQueryMemoryMetricProviderSelfTest.assertEquals((long)800L, (long)child2.reserved());
        GridQueryMemoryMetricProviderSelfTest.assertEquals((long)900L, (long)tracker.reserved());
        child2.spill(200L);
        GridQueryMemoryMetricProviderSelfTest.assertEquals((long)0L, (long)child1.writtenOnDisk());
        GridQueryMemoryMetricProviderSelfTest.assertEquals((long)200L, (long)child2.writtenOnDisk());
        GridQueryMemoryMetricProviderSelfTest.assertEquals((long)200L, (long)tracker.writtenOnDisk());
        child2.close();
        GridQueryMemoryMetricProviderSelfTest.assertEquals((long)100L, (long)child1.reserved());
        GridQueryMemoryMetricProviderSelfTest.assertEquals((long)0L, (long)child2.reserved());
        GridQueryMemoryMetricProviderSelfTest.assertEquals((long)100L, (long)tracker.reserved());
        GridQueryMemoryMetricProviderSelfTest.assertEquals((long)0L, (long)child1.writtenOnDisk());
        GridQueryMemoryMetricProviderSelfTest.assertEquals((long)0L, (long)child2.writtenOnDisk());
        GridQueryMemoryMetricProviderSelfTest.assertEquals((long)0L, (long)tracker.writtenOnDisk());
        GridQueryMemoryMetricProviderSelfTest.assertFalse((boolean)child1.closed());
        GridQueryMemoryMetricProviderSelfTest.assertTrue((boolean)child2.closed());
        GridQueryMemoryMetricProviderSelfTest.assertFalse((boolean)tracker.closed());
        child2 = tracker.createChildTracker();
        tracker.close();
        GridQueryMemoryMetricProviderSelfTest.assertTrue((boolean)child1.closed());
        GridQueryMemoryMetricProviderSelfTest.assertTrue((boolean)child2.closed());
        GridQueryMemoryMetricProviderSelfTest.assertTrue((boolean)tracker.closed());
    }
}

