/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.oom;

import java.util.ArrayList;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.processors.query.GridQueryMemoryMetricProvider;
import org.apache.ignite.internal.processors.query.h2.QueryMemoryManager;
import org.apache.ignite.internal.processors.query.oom.DiskSpillingAbstractTest;
import org.apache.ignite.testframework.GridTestUtils;
import org.junit.Test;

public class DiskSpillingMemoryTrackerTest
extends DiskSpillingAbstractTest {
    @Test
    public void testOffloadedDataTrackedByMemoryTracker() {
        IgniteEx ignite = this.grid(0);
        final ArrayList<GridQueryMemoryMetricProvider> trackers = new ArrayList<GridQueryMemoryMetricProvider>();
        GridTestUtils.setFieldValue((Object)ignite.context().query().getIndexing(), (String)"memoryMgr", (Object)new QueryMemoryManager(ignite.context()){

            public GridQueryMemoryMetricProvider createQueryMemoryTracker(long maxQryMemory) {
                GridQueryMemoryMetricProvider tracker = super.createQueryMemoryTracker(maxQryMemory);
                trackers.add(tracker);
                return tracker;
            }
        });
        String sql = "SELECT * FROM person";
        this.runSql(sql, false, Long.MAX_VALUE);
        DiskSpillingMemoryTrackerTest.assertFalse((boolean)trackers.isEmpty());
        for (GridQueryMemoryMetricProvider tr2 : trackers) {
            DiskSpillingMemoryTrackerTest.assertEquals((long)0L, (long)tr2.maxWrittenOnDisk());
            DiskSpillingMemoryTrackerTest.assertEquals((long)0L, (long)tr2.totalWrittenOnDisk());
        }
        int ind = 0;
        for (int i = 1; i < trackers.size(); ++i) {
            if (((GridQueryMemoryMetricProvider)trackers.get(i)).maxReserved() <= ((GridQueryMemoryMetricProvider)trackers.get(ind)).maxReserved()) continue;
            ind = i;
        }
        long memLimit = ((GridQueryMemoryMetricProvider)trackers.get(ind)).maxReserved() / 2L;
        trackers.clear();
        this.runSql(sql, false, memLimit);
        trackers.removeIf(tr -> tr.maxWrittenOnDisk() == 0L);
        DiskSpillingMemoryTrackerTest.assertFalse((boolean)trackers.isEmpty());
        for (GridQueryMemoryMetricProvider tr3 : trackers) {
            DiskSpillingMemoryTrackerTest.assertTrue((tr3.maxWrittenOnDisk() <= tr3.totalWrittenOnDisk() ? 1 : 0) != 0);
        }
    }
}

