/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.oom;

import org.apache.ignite.Ignite;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.processors.query.h2.QueryMemoryManager;
import org.apache.ignite.internal.processors.query.oom.DiskSpillingAbstractTest;
import org.apache.ignite.internal.util.typedef.G;
import org.apache.ignite.testframework.GridTestUtils;
import org.apache.ignite.testframework.ListeningTestLogger;
import org.apache.ignite.testframework.LogListener;
import org.junit.Test;

public class DiskSpillingLoggingTest
extends DiskSpillingAbstractTest {
    @Override
    protected boolean startClient() {
        return false;
    }

    @Test
    public void testLogsWithOffloading() {
        LogListener logLsnr = LogListener.matches((String)"User's query started").andMatches("Offloading started for query").andMatches("Created spill file").andMatches("Deleted spill file").andMatches("User's query completed").build();
        this.setRootLoggerDebugLevel();
        this.testLog(this.grid(0)).registerListener(logLsnr);
        this.setGlobalQuota("60%");
        this.setDefaultQueryQuota(4096L);
        this.setOffloadingEnabled(true);
        this.checkQuery(DiskSpillingAbstractTest.Result.SUCCESS_WITH_OFFLOADING, "SELECT depId, code, age, COUNT(*), SUM(salary),  LISTAGG(uuid) FROM person GROUP BY age, depId, code ");
        DiskSpillingLoggingTest.assertTrue((boolean)logLsnr.check());
    }

    @Test
    public void testLogsNoOffloading() {
        LogListener logLsnr = LogListener.matches((String)"User's query started").andMatches("User's query completed").build();
        this.setRootLoggerDebugLevel();
        this.testLog(this.grid(0)).registerListener(logLsnr);
        this.setGlobalQuota("60%");
        this.setDefaultQueryQuota(Long.MAX_VALUE);
        this.setOffloadingEnabled(true);
        this.checkQuery(DiskSpillingAbstractTest.Result.SUCCESS_NO_OFFLOADING, "SELECT depId, code, age, COUNT(*), SUM(salary),  LISTAGG(uuid) FROM person GROUP BY age, depId, code ");
        DiskSpillingLoggingTest.assertTrue((boolean)logLsnr.check());
    }

    @Test
    public void testLogsOnDynamicConfiguration() {
        LogListener logLsnr = LogListener.matches((String)"SQL query global quota was set to 20.").andMatches("SQL query memory quota was set to 10.").andMatches("SQL query query offloading enabled flag was set to false").build();
        this.testLog(this.grid(0)).registerListener(logLsnr);
        this.setGlobalQuota("20");
        this.setDefaultQueryQuota(10L);
        this.setOffloadingEnabled(false);
        DiskSpillingLoggingTest.assertTrue((boolean)logLsnr.check());
        logLsnr = LogListener.matches((String)"SQL query global quota was set to 21.").andMatches("SQL query memory quota was set to 11.").andMatches("SQL query query offloading enabled flag was set to true").build();
        this.testLog(this.grid(0)).registerListener(logLsnr);
        this.setGlobalQuota("21");
        this.setDefaultQueryQuota(11L);
        this.setOffloadingEnabled(true);
        DiskSpillingLoggingTest.assertTrue((boolean)logLsnr.check());
    }

    private ListeningTestLogger testLog(IgniteEx node) {
        ListeningTestLogger testLog = new ListeningTestLogger(true, log);
        GridTestUtils.setFieldValue((Object)this.memoryManager(node), (String)"log", (Object)testLog);
        GridTestUtils.setFieldValue((Object)this.runningQueryManager(node), (String)"log", (Object)testLog);
        return testLog;
    }

    private void setDefaultQueryQuota(long newQuota) {
        for (Ignite node : G.allGrids()) {
            QueryMemoryManager memMgr = this.memoryManager((IgniteEx)node);
            memMgr.setQueryQuota(String.valueOf(newQuota));
        }
    }

    private void setOffloadingEnabled(boolean enabled) {
        for (Ignite node : G.allGrids()) {
            QueryMemoryManager memMgr = this.memoryManager((IgniteEx)node);
            memMgr.setOffloadingEnabled(enabled);
        }
    }

    private void setGlobalQuota(String newQuota) {
        for (Ignite node : G.allGrids()) {
            QueryMemoryManager memMgr = this.memoryManager((IgniteEx)node);
            memMgr.setGlobalQuota(newQuota);
        }
    }
}

