/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.oom;

import java.io.File;
import java.io.IOException;
import java.nio.file.OpenOption;
import javax.cache.CacheException;
import org.apache.ignite.cache.query.FieldsQueryCursor;
import org.apache.ignite.internal.metric.SqlMemoryStatisticsHolder;
import org.apache.ignite.internal.processors.cache.persistence.file.AsyncFileIOFactory;
import org.apache.ignite.internal.processors.cache.persistence.file.FileIO;
import org.apache.ignite.internal.processors.cache.persistence.file.FileIOFactory;
import org.apache.ignite.internal.processors.cache.query.SqlFieldsQueryEx;
import org.apache.ignite.internal.processors.metric.GridMetricManager;
import org.apache.ignite.internal.processors.query.h2.H2MemoryTracker;
import org.apache.ignite.internal.processors.query.h2.IgniteH2Indexing;
import org.apache.ignite.internal.processors.query.h2.QueryMemoryManager;
import org.apache.ignite.internal.processors.query.h2.disk.TrackableFileIoFactory;
import org.apache.ignite.internal.processors.query.oom.DiskSpillingAbstractTest;
import org.apache.ignite.testframework.GridTestUtils;
import org.junit.Test;

public class DiskSpillingIoErrorTest
extends DiskSpillingAbstractTest {
    private static final H2MemoryTracker NO_OP_TRACKER = new H2MemoryTracker(){

        public boolean reserve(long size) {
            return false;
        }

        public void release(long size) {
        }

        public long writtenOnDisk() {
            return -1L;
        }

        public long totalWrittenOnDisk() {
            return -1L;
        }

        public long reserved() {
            return -1L;
        }

        public void spill(long size) {
        }

        public void unspill(long size) {
        }

        public void close() {
        }

        public void incrementFilesCreated() {
        }

        public H2MemoryTracker createChildTracker() {
            return NO_OP_TRACKER;
        }

        public void onChildClosed(H2MemoryTracker child) {
        }

        public boolean closed() {
            return false;
        }
    };

    @Override
    protected boolean persistence() {
        return false;
    }

    @Override
    protected int nodeCount() {
        return 1;
    }

    @Override
    protected void beforeTestsStarted() throws Exception {
    }

    @Override
    protected void beforeTest() throws Exception {
        super.beforeTest();
        this.initGrid();
    }

    @Override
    protected void afterTest() throws Exception {
        super.afterTest();
        this.destroyGrid();
    }

    @Test
    public void testSpillFilesDeletedOnErrorOnFirstCreation() {
        this.checkSpillFilesCleanedOnFileCreation(1);
    }

    @Test
    public void testSpillFilesDeletedOnErrorOnSecondCreation() {
        this.checkSpillFilesCleanedOnFileCreation(2);
    }

    private void checkSpillFilesCleanedOnFileCreation(int crashOnCreateCnt) {
        QueryMemoryManager memMgr = ((IgniteH2Indexing)this.grid(0).context().query().getIndexing()).memoryManager();
        BrokenIoFactory ioFactory = new BrokenIoFactory(crashOnCreateCnt, this.grid(0).context().metric(), memMgr);
        GridTestUtils.setFieldValue((Object)memMgr, (String)"fileIOFactory", (Object)((Object)ioFactory));
        try (FieldsQueryCursor cur = this.grid(0).cache("default").query(new SqlFieldsQueryEx("SELECT id, name, code, depId FROM person WHERE depId >= 0  EXCEPT SELECT id, name, code, depId FROM person WHERE depId > 5 ", null).setMaxMemory(4096L).setLazy(true));){
            cur.iterator();
            DiskSpillingIoErrorTest.fail((String)"Exception is not thrown.");
        }
        catch (CacheException e) {
            DiskSpillingIoErrorTest.assertNotNull((Object)e.getMessage());
        }
        DiskSpillingIoErrorTest.assertEquals((int)0, (int)ioFactory.crashOnCreateCnt);
        this.assertWorkDirClean();
        this.checkMemoryManagerState();
    }

    private static class BrokenIoFactory
    extends TrackableFileIoFactory {
        private int crashOnCreateCnt;

        BrokenIoFactory(int crashOnCreateCnt, GridMetricManager metric, QueryMemoryManager memMgr) {
            super((FileIOFactory)new AsyncFileIOFactory(), new SqlMemoryStatisticsHolder(memMgr, metric));
            this.crashOnCreateCnt = crashOnCreateCnt;
        }

        public FileIO create(File file, H2MemoryTracker tracker, OpenOption ... modes) throws IOException {
            if (--this.crashOnCreateCnt == 0) {
                throw new IOException("Test crash.");
            }
            return super.create(file, NO_OP_TRACKER, modes);
        }
    }
}

