/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.oom;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.cache.query.exceptions.SqlMemoryQuotaExceededException;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.DataRegionConfiguration;
import org.apache.ignite.configuration.DataStorageConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.configuration.SqlConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.processors.cache.query.SqlFieldsQueryEx;
import org.apache.ignite.internal.processors.query.RunningQueryManager;
import org.apache.ignite.internal.processors.query.h2.IgniteH2Indexing;
import org.apache.ignite.internal.processors.query.h2.QueryMemoryManager;
import org.apache.ignite.internal.util.typedef.G;
import org.apache.ignite.internal.util.typedef.X;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.testframework.junits.SystemPropertiesList;
import org.apache.ignite.testframework.junits.WithSystemProperty;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;

@SystemPropertiesList(value={@WithSystemProperty(key="IGNITE_SQL_MEMORY_RESERVATION_BLOCK_SIZE", value="2048"), @WithSystemProperty(key="IGNITE_SQL_ENABLE_CONNECTION_MEMORY_QUOTA", value="true")})
public abstract class DiskSpillingAbstractTest
extends GridCommonAbstractTest {
    protected static final int PERS_CNT = 1002;
    private static final int DEPS_CNT = 100;
    protected static final long SMALL_MEM_LIMIT = 4096L;
    protected static final long HUGE_MEM_LIMIT = Long.MAX_VALUE;
    protected boolean checkSortOrder;
    protected boolean checkGroupsSpilled;
    protected List<Integer> listAggs;

    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(igniteInstanceName);
        cfg.setSqlConfiguration(new SqlConfiguration().setSqlOffloadingEnabled(true));
        CacheConfiguration cache = DiskSpillingAbstractTest.defaultCacheConfiguration();
        cfg.setCacheConfiguration(new CacheConfiguration[]{cache});
        if (this.persistence()) {
            DataStorageConfiguration storageCfg = new DataStorageConfiguration();
            DataRegionConfiguration regionCfg = new DataRegionConfiguration();
            regionCfg.setPersistenceEnabled(true);
            storageCfg.setDefaultDataRegionConfiguration(regionCfg);
            cfg.setDataStorageConfiguration(storageCfg);
        }
        return cfg;
    }

    protected void beforeTestsStarted() throws Exception {
        this.initGrid();
    }

    protected void afterTestsStopped() throws Exception {
        this.destroyGrid();
    }

    void initGrid() throws Exception {
        super.beforeTestsStarted();
        this.cleanPersistenceDir();
        this.startGrids(this.nodeCount());
        if (this.persistence()) {
            this.grid(0).cluster().active(true);
        }
        CacheConfiguration personCache = DiskSpillingAbstractTest.defaultCacheConfiguration();
        personCache.setQueryParallelism(this.queryParallelism());
        personCache.setName("person");
        personCache.setCacheMode(CacheMode.PARTITIONED);
        personCache.setBackups(1);
        this.grid(0).addCacheConfiguration(personCache);
        CacheConfiguration orgCache = DiskSpillingAbstractTest.defaultCacheConfiguration();
        orgCache.setQueryParallelism(this.queryParallelism());
        orgCache.setName("organization");
        orgCache.setCacheMode(CacheMode.PARTITIONED);
        orgCache.setBackups(1);
        this.grid(0).addCacheConfiguration(orgCache);
        if (this.startClient()) {
            this.startGrid(this.getConfiguration("client").setClientMode(true));
        }
        this.populateData();
    }

    protected boolean startClient() {
        return true;
    }

    void destroyGrid() throws Exception {
        super.afterTestsStopped();
        this.stopAllGrids();
        this.cleanPersistenceDir();
    }

    protected int nodeCount() {
        return 1;
    }

    protected boolean persistence() {
        return false;
    }

    protected int queryParallelism() {
        return 1;
    }

    protected boolean fromClient() {
        return false;
    }

    protected boolean localQuery() {
        return false;
    }

    protected void beforeTest() throws Exception {
        super.beforeTest();
        FileUtils.cleanDirectory((File)this.getWorkDir().toFile());
        this.checkSortOrder = false;
        this.checkGroupsSpilled = false;
        this.listAggs = null;
    }

    protected void afterTest() throws Exception {
        super.afterTest();
        this.checkMemoryManagerState();
        FileUtils.cleanDirectory((File)this.getWorkDir().toFile());
    }

    protected void assertInMemoryAndOnDiskSameResults(boolean lazy, String sql) {
        WatchService watchSvc = null;
        try {
            Path workDir = this.getWorkDir();
            if (log.isInfoEnabled()) {
                log.info("workDir=" + workDir.toString());
            }
            watchSvc = FileSystems.getDefault().newWatchService();
            WatchKey watchKey = workDir.register(watchSvc, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE);
            long startInMem = System.currentTimeMillis();
            if (log.isInfoEnabled()) {
                log.info("Run query in memory.");
            }
            watchKey.reset();
            List<List<?>> inMemRes = this.runSql(sql, lazy, Long.MAX_VALUE);
            DiskSpillingAbstractTest.assertFalse((String)"In-memory result is empty.", (boolean)inMemRes.isEmpty());
            this.assertWorkDirClean();
            this.checkMemoryManagerState();
            List<WatchEvent<?>> dirEvts = watchKey.pollEvents();
            DiskSpillingAbstractTest.assertTrue((String)("Disk events is not empty for in-memory query: :" + dirEvts.stream().map(e -> e.kind().toString()).collect(Collectors.joining(", "))), (boolean)dirEvts.isEmpty());
            if (log.isInfoEnabled()) {
                log.info("Run query with disk offloading.");
            }
            long startOnDisk = System.currentTimeMillis();
            watchKey.reset();
            List<List<?>> onDiskRes = this.runSql(sql, lazy, 4096L);
            DiskSpillingAbstractTest.assertFalse((String)"On disk result is empty.", (boolean)onDiskRes.isEmpty());
            long finish = System.currentTimeMillis();
            dirEvts = watchKey.pollEvents();
            DiskSpillingAbstractTest.assertFalse((String)"Disk events is empty for on-disk query. ", (boolean)dirEvts.isEmpty());
            this.assertWorkDirClean();
            this.checkMemoryManagerState();
            if (log.isInfoEnabled()) {
                log.info("Spill files events (created + deleted): " + dirEvts.size());
            }
            if (!this.checkSortOrder) {
                this.fixSortOrder(onDiskRes);
                this.fixSortOrder(inMemRes);
            }
            if (this.listAggs != null) {
                this.fixListAggsSort(onDiskRes);
                this.fixListAggsSort(inMemRes);
            }
            if (log.isInfoEnabled()) {
                log.info("In-memory time=" + (startOnDisk - startInMem) + ", on-disk time=" + (finish - startOnDisk));
            }
            if (log.isDebugEnabled()) {
                log.debug("In-memory result:\n" + inMemRes + "\nOn disk result:\n" + onDiskRes);
            }
            DiskSpillingAbstractTest.assertEqualsCollections(inMemRes, onDiskRes);
            this.checkMemoryManagerState();
        }
        catch (IOException e2) {
            try {
                throw new RuntimeException(e2);
            }
            catch (Throwable throwable) {
                U.closeQuiet(watchSvc);
                throw throwable;
            }
        }
        U.closeQuiet((AutoCloseable)watchSvc);
    }

    private void fixListAggsSort(List<List<?>> res) {
        for (List<?> row : res) {
            for (Integer idx : this.listAggs) {
                String listAgg = (String)row.get(idx);
                Object[] strings = listAgg.split(",");
                Arrays.sort(strings);
                String newListAgg = Arrays.stream(strings).collect(Collectors.joining(","));
                row.set(idx, newListAgg);
            }
        }
    }

    private void populateData() {
        int i;
        this.runDdlDml("CREATE TABLE person (id BIGINT PRIMARY KEY, name VARCHAR, depId SMALLINT, code CHAR(3),male BOOLEAN,age TINYINT,height SMALLINT,salary INT,tax DECIMAL(4,4),weight DOUBLE,temperature REAL,time TIME,date DATE,timestamp TIMESTAMP,uuid UUID, nulls INT) WITH \"TEMPLATE=person\"", new Object[0]);
        for (i = 0; i < 1002; ++i) {
            this.runDdlDml("INSERT INTO person (id, name, depId,  code, male, age, height, salary, tax, weight, temperature,time,date,timestamp,uuid, nulls) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)", i, "Vasya" + i, i % 100, "p" + i % 31, i % 2, i % 100, 150 + i % 50, 50000 + i, (double)i / 1000.0, 50.0 + (double)(i % 501), i % 10 == 0 ? null : Double.valueOf(36.6 + (double)(i % 5)), "20:00:" + i % 60, "2019-04-" + (i % 29 + 1), "2019-04-04 04:20:08." + i % 900, "736bc956-090c-40d2-94da-916f2161cda" + i % 10, null);
        }
        this.runDdlDml("CREATE TABLE department (id INT PRIMARY KEY, title VARCHAR_IGNORECASE) WITH \"TEMPLATE=organization\"", new Object[0]);
        for (i = 0; i < 100; ++i) {
            this.runDdlDml("INSERT INTO department (id, title) VALUES (?, ?)", i, "IT" + i);
        }
    }

    protected List<List<?>> runSql(String sql, boolean lazy, long memLimit) {
        IgniteEx node = this.fromClient() ? this.grid("client") : this.grid(0);
        return node.cache("default").query(new SqlFieldsQueryEx(sql, null).setMaxMemory(memLimit).setLazy(lazy).setLocal(this.localQuery())).getAll();
    }

    protected List<List<?>> runDdlDml(String sql, Object ... args) {
        return this.grid(0).cache("default").query((SqlFieldsQuery)new SqlFieldsQueryEx(sql, null).setArgs(args)).getAll();
    }

    private void fixSortOrder(List<List<?>> res) {
        Collections.sort(res, new Comparator<List<?>>(){

            @Override
            public int compare(List<?> l1, List<?> l2) {
                for (int i = 0; i < l1.size(); ++i) {
                    Object o1 = l1.get(i);
                    Object o2 = l2.get(i);
                    if (o1 == null || o2 == null) {
                        if (o1 == null && o2 == null) {
                            return 0;
                        }
                        return o1 == null ? 1 : -1;
                    }
                    if (o1.hashCode() == o2.hashCode()) continue;
                    return o1.hashCode() > o2.hashCode() ? 1 : -1;
                }
                return 0;
            }
        });
    }

    protected Path getWorkDir() {
        Path workDir;
        try {
            workDir = Paths.get(U.defaultWorkDirectory(), "tmp/spill");
        }
        catch (IgniteCheckedException ex) {
            throw new IgniteException((Throwable)ex);
        }
        workDir.toFile().mkdir();
        return workDir;
    }

    protected void assertWorkDirClean() {
        List<String> spillFiles = this.listOfSpillFiles();
        DiskSpillingAbstractTest.assertEquals((String)("Files are not deleted: " + spillFiles), (int)0, (int)spillFiles.size());
    }

    protected List<String> listOfSpillFiles() {
        Path workDir = this.getWorkDir();
        DiskSpillingAbstractTest.assertTrue((boolean)workDir.toFile().isDirectory());
        return Arrays.asList(workDir.toFile().list());
    }

    protected void checkMemoryManagerState() {
        for (Ignite node : G.allGrids()) {
            QueryMemoryManager memoryManager = this.memoryManager((IgniteEx)node);
            DiskSpillingAbstractTest.assertEquals((long)0L, (long)memoryManager.reserved());
        }
    }

    protected QueryMemoryManager memoryManager(IgniteEx node) {
        IgniteH2Indexing h2 = (IgniteH2Indexing)node.context().query().getIndexing();
        return h2.memoryManager();
    }

    protected RunningQueryManager runningQueryManager(IgniteEx node) {
        IgniteH2Indexing h2 = (IgniteH2Indexing)node.context().query().getIndexing();
        return h2.runningQueryManager();
    }

    protected void checkQuery(Result res, String sql) {
        this.checkQuery(res, sql, 1, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected void checkQuery(Result res, String sql, int threadNum, int iterations) {
        WatchService watchSvc = null;
        WatchKey watchKey = null;
        watchSvc = FileSystems.getDefault().newWatchService();
        Path workDir = this.getWorkDir();
        watchKey = workDir.register(watchSvc, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE);
        AtomicBoolean oomExThrown = new AtomicBoolean();
        this.multithreaded(() -> {
            try {
                for (int i = 0; i < iterations; ++i) {
                    IgniteEx grid = this.fromClient() ? this.grid("client") : this.grid(0);
                    grid.cache("default").query(new SqlFieldsQuery(sql)).getAll();
                }
            }
            catch (SqlMemoryQuotaExceededException e) {
                oomExThrown.set(true);
                DiskSpillingAbstractTest.assertFalse((String)("Unexpected exception:" + X.getFullStackTrace((Throwable)e)), (boolean)res.success);
                if (res == Result.ERROR_GLOBAL_QUOTA) {
                    DiskSpillingAbstractTest.assertTrue((String)("Wrong message:" + X.getFullStackTrace((Throwable)e)), (boolean)e.getMessage().contains("Global quota was exceeded."));
                } else {
                    DiskSpillingAbstractTest.assertTrue((String)("Wrong message:" + X.getFullStackTrace((Throwable)e)), (boolean)e.getMessage().contains("Query quota was exceeded."));
                }
            }
            catch (Throwable t) {
                log.error("Caught exception:" + X.getFullStackTrace((Throwable)t));
                throw t;
            }
        }, threadNum);
        DiskSpillingAbstractTest.assertEquals((String)("Exception expected=" + !res.success + ", exception thrown=" + oomExThrown.get()), (!res.success ? 1 : 0) != 0, (boolean)oomExThrown.get());
        try {
            if (watchKey != null) {
                List<WatchEvent<?>> dirEvts = watchKey.pollEvents();
                DiskSpillingAbstractTest.assertEquals((String)("Disk spilling " + (res.offload ? "not" : "") + " happened."), (boolean)res.offload, (!dirEvts.isEmpty() ? 1 : 0) != 0);
            }
            this.assertWorkDirClean();
            this.checkMemoryManagerState();
        }
        finally {
            U.closeQuiet((AutoCloseable)watchSvc);
        }
        catch (Exception e) {
            try {
                DiskSpillingAbstractTest.fail((String)X.getFullStackTrace((Throwable)e));
            }
            catch (Throwable throwable) {
                try {
                    if (watchKey != null) {
                        List<WatchEvent<?>> dirEvts = watchKey.pollEvents();
                        DiskSpillingAbstractTest.assertEquals((String)("Disk spilling " + (res.offload ? "not" : "") + " happened."), (boolean)res.offload, (!dirEvts.isEmpty() ? 1 : 0) != 0);
                    }
                    this.assertWorkDirClean();
                    this.checkMemoryManagerState();
                }
                finally {
                    U.closeQuiet((AutoCloseable)watchSvc);
                }
                throw throwable;
            }
            try {
                if (watchKey != null) {
                    List<WatchEvent<?>> dirEvts = watchKey.pollEvents();
                    DiskSpillingAbstractTest.assertEquals((String)("Disk spilling " + (res.offload ? "not" : "") + " happened."), (boolean)res.offload, (!dirEvts.isEmpty() ? 1 : 0) != 0);
                }
                this.assertWorkDirClean();
                this.checkMemoryManagerState();
            }
            finally {
                U.closeQuiet((AutoCloseable)watchSvc);
            }
        }
    }

    public static enum Result {
        SUCCESS_WITH_OFFLOADING(true, true),
        SUCCESS_NO_OFFLOADING(false, true),
        ERROR_GLOBAL_QUOTA(false, false),
        ERROR_QUERY_QUOTA(false, false);

        final boolean offload;
        final boolean success;

        private Result(boolean offload, boolean success) {
            this.offload = offload;
            this.success = success;
        }
    }
}

