/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.twostep;

import java.util.List;
import javax.cache.CacheException;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteException;
import org.apache.ignite.cache.query.Query;
import org.apache.ignite.cache.query.SqlQuery;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteInterruptedCheckedException;
import org.apache.ignite.internal.managers.communication.GridIoMessage;
import org.apache.ignite.internal.processors.cache.index.AbstractIndexingCommonTest;
import org.apache.ignite.internal.processors.query.h2.twostep.JoinSqlTestHelper;
import org.apache.ignite.internal.processors.query.h2.twostep.msg.GridH2IndexRangeRequest;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteInClosure;
import org.apache.ignite.plugin.extensions.communication.Message;
import org.apache.ignite.spi.IgniteSpiException;
import org.apache.ignite.spi.communication.CommunicationSpi;
import org.apache.ignite.spi.communication.tcp.TcpCommunicationSpi;
import org.apache.ignite.testframework.junits.WithSystemProperty;
import org.junit.Test;

@WithSystemProperty(key="IGNITE_SQL_RETRY_TIMEOUT", value="500")
public class NonCollocatedRetryMessageSelfTest
extends AbstractIndexingCommonTest {
    private static final int NODES_COUNT = 2;
    private static final String ORG = "org";
    private IgniteCache<String, JoinSqlTestHelper.Person> personCache;

    @Test
    public void testNonCollocatedRetryMessage() {
        SqlQuery qry = new SqlQuery(JoinSqlTestHelper.Person.class, "select * from Person, \"org\".Organization as org where Person.orgId = org.id and lower(org.name) = lower(?)").setArgs(new Object[]{"Organization #0"});
        qry.setDistributedJoins(true);
        try {
            List prsns = this.personCache.query((Query)qry).getAll();
            NonCollocatedRetryMessageSelfTest.fail((String)("No CacheException emitted. Collection size=" + prsns.size()));
        }
        catch (CacheException e) {
            NonCollocatedRetryMessageSelfTest.assertTrue((String)e.getMessage(), (boolean)e.getMessage().contains("Failed to execute non-collocated query"));
        }
    }

    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(igniteInstanceName);
        cfg.setCommunicationSpi((CommunicationSpi)new TestTcpCommunication());
        return cfg;
    }

    protected void beforeTest() throws Exception {
        this.startGridsMultiThreaded(2, false);
        CacheConfiguration ccfg1 = new CacheConfiguration("pers");
        ccfg1.setBackups(1);
        ccfg1.setQueryEntities(JoinSqlTestHelper.personQueryEntity());
        this.personCache = this.ignite(0).getOrCreateCache(ccfg1);
        CacheConfiguration ccfg2 = new CacheConfiguration(ORG);
        ccfg2.setBackups(1);
        ccfg2.setQueryEntities(JoinSqlTestHelper.organizationQueryEntity());
        IgniteCache orgCache = this.ignite(0).getOrCreateCache(ccfg2);
        this.awaitPartitionMapExchange();
        JoinSqlTestHelper.populateDataIntoOrg((IgniteCache<String, JoinSqlTestHelper.Organization>)orgCache);
        JoinSqlTestHelper.populateDataIntoPerson(this.personCache);
    }

    protected void afterTest() {
        this.stopAllGrids();
    }

    private class TestTcpCommunication
    extends TcpCommunicationSpi {
        private TestTcpCommunication() {
        }

        public void sendMessage(ClusterNode node, Message msg, IgniteInClosure<IgniteException> ackC) {
            GridIoMessage gridMsg;
            assert (msg != null);
            if (this.igniteInstanceName.equals(NonCollocatedRetryMessageSelfTest.this.getTestIgniteInstanceName(1)) && GridIoMessage.class.isAssignableFrom(msg.getClass()) && GridH2IndexRangeRequest.class.isAssignableFrom((gridMsg = (GridIoMessage)msg).message().getClass())) {
                try {
                    U.sleep((long)Long.getLong("IGNITE_SQL_RETRY_TIMEOUT"));
                }
                catch (IgniteInterruptedCheckedException e) {
                    NonCollocatedRetryMessageSelfTest.fail((String)"Test was interrupted.");
                }
                throw new IgniteSpiException("Test exception.");
            }
            super.sendMessage(node, msg, ackC);
        }
    }
}

