/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.twostep;

import java.util.Collection;
import java.util.Collections;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.cache.QueryEntity;
import org.apache.ignite.cache.query.annotations.QuerySqlField;

public class JoinSqlTestHelper {
    static final String ORG = "org";
    static final int ORG_COUNT = 100;
    private static final int PERSON_PER_ORG_COUNT = 10;
    static final String JOIN_SQL = "select * from Person, \"org\".Organization as org where Person.orgId = org.id and lower(org.name) = lower(?)";

    static Collection<QueryEntity> organizationQueryEntity() {
        QueryEntity entity = new QueryEntity(String.class, Organization.class);
        entity.setKeyFieldName("ID");
        entity.getFields().put("ID", String.class.getName());
        return Collections.singletonList(entity);
    }

    static Collection<QueryEntity> personQueryEntity() {
        QueryEntity entity = new QueryEntity(String.class, Person.class);
        entity.setKeyFieldName("ID");
        entity.getFields().put("ID", String.class.getName());
        return Collections.singletonList(entity);
    }

    static void populateDataIntoOrg(IgniteCache<String, Organization> cache) {
        for (int i = 0; i < 100; ++i) {
            Organization org = new Organization();
            org.setName("Organization #" + i);
            cache.put((Object)(ORG + i), (Object)org);
        }
    }

    static void populateDataIntoPerson(IgniteCache<String, Person> cache) {
        int personId = 0;
        for (int i = 0; i < 100; ++i) {
            String orgId = ORG + i;
            for (int j = 0; j < 10; ++j) {
                Person prsn = new Person();
                prsn.setOrgId(orgId);
                prsn.setName("Person name #" + personId);
                cache.put((Object)("pers" + personId), (Object)prsn);
                ++personId;
            }
        }
    }

    public static class Organization {
        @QuerySqlField(index=true)
        private String name;
        @QuerySqlField
        private Integer debtCapital;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public Integer debtCapital() {
            return this.debtCapital;
        }

        public void debtCapital(Integer debtCapital) {
            this.debtCapital = debtCapital;
        }
    }

    public static class Person {
        @QuerySqlField(index=true)
        private String orgId;
        @QuerySqlField(index=true)
        private String name;

        public String getOrgId() {
            return this.orgId;
        }

        public void setOrgId(String orgId) {
            this.orgId = orgId;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }
    }
}

