/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.twostep;

import java.util.Collections;
import java.util.Map;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.cache.QueryEntity;
import org.apache.ignite.cache.query.Query;
import org.apache.ignite.cache.query.QueryCursor;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.cache.query.annotations.QuerySqlField;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.processors.cache.index.AbstractIndexingCommonTest;
import org.apache.ignite.internal.processors.query.h2.IgniteH2Indexing;
import org.apache.ignite.internal.processors.query.h2.twostep.GridMapQueryExecutor;
import org.apache.ignite.internal.processors.query.h2.twostep.MapNodeResults;
import org.apache.ignite.testframework.GridTestUtils;
import org.junit.Test;

public class CacheQueryMemoryLeakTest
extends AbstractIndexingCommonTest {
    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        IgniteConfiguration igniteCfg = super.getConfiguration(igniteInstanceName);
        if (igniteInstanceName.equals("client")) {
            igniteCfg.setClientMode(true);
        }
        return igniteCfg;
    }

    protected void afterTest() throws Exception {
        this.stopAllGrids();
    }

    @Test
    public void testResultIsMultipleOfPage() throws Exception {
        int i;
        IgniteEx srv = this.startGrid("server");
        IgniteEx client = this.startGrid("client");
        IgniteCache<Integer, Person> cache = CacheQueryMemoryLeakTest.startPeopleCache((Ignite)client);
        int pages = 3;
        int pageSize = 1024;
        for (i = 0; i < pages * pageSize; ++i) {
            Person p = new Person("Person #" + i, 25);
            cache.put((Object)i, (Object)p);
        }
        for (i = 0; i < 100; ++i) {
            SqlFieldsQuery qry = new SqlFieldsQuery("select * from people");
            qry.setPageSize(pageSize);
            QueryCursor cursor = cache.query((Query)qry);
            cursor.getAll();
            cursor.close();
        }
        CacheQueryMemoryLeakTest.assertTrue((String)"MapNodeResults is not cleared on the map node.", (boolean)this.isMapNodeResultsEmpty(srv));
    }

    private boolean isMapNodeResultsEmpty(IgniteEx node) {
        IgniteH2Indexing idx = (IgniteH2Indexing)node.context().query().getIndexing();
        GridMapQueryExecutor mapQryExec = idx.mapQueryExecutor();
        Map qryRess = (Map)GridTestUtils.getFieldValue((Object)mapQryExec, GridMapQueryExecutor.class, (String)"qryRess");
        for (MapNodeResults nodeRess : qryRess.values()) {
            Map nodeQryRess = (Map)GridTestUtils.getFieldValue((Object)nodeRess, MapNodeResults.class, (String)"res");
            if (nodeQryRess.isEmpty()) continue;
            return false;
        }
        return true;
    }

    private static IgniteCache<Integer, Person> startPeopleCache(Ignite node) {
        CacheConfiguration cacheCfg = new CacheConfiguration("people");
        QueryEntity qe = new QueryEntity(Integer.class, Person.class);
        qe.setTableName("people");
        cacheCfg.setQueryEntities(Collections.singleton(qe));
        cacheCfg.setSqlSchema("PUBLIC");
        return node.getOrCreateCache(cacheCfg);
    }

    public static class Person {
        @QuerySqlField
        private String name;
        @QuerySqlField
        private int age;

        public Person(String name, int age) {
            this.name = name;
            this.age = age;
        }
    }
}

