/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.twostep;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import org.apache.ignite.IgniteException;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.configuration.DataRegionConfiguration;
import org.apache.ignite.configuration.DataStorageConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.managers.communication.GridIoMessage;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearTxQueryEnlistRequest;
import org.apache.ignite.internal.processors.query.h2.twostep.msg.GridH2QueryRequest;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.lang.IgniteInClosure;
import org.apache.ignite.plugin.extensions.communication.Message;
import org.apache.ignite.spi.communication.CommunicationSpi;
import org.apache.ignite.spi.communication.tcp.TcpCommunicationSpi;
import org.apache.ignite.spi.discovery.DiscoverySpi;
import org.apache.ignite.spi.discovery.tcp.TcpDiscoverySpi;
import org.apache.ignite.spi.discovery.tcp.ipfinder.TcpDiscoveryIpFinder;
import org.apache.ignite.spi.discovery.tcp.ipfinder.vm.TcpDiscoveryVmIpFinder;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;

public abstract class AbstractPartitionPruningBaseTest
extends GridCommonAbstractTest {
    private static final AtomicInteger INTERCEPTED_REQS = new AtomicInteger();
    private static final ConcurrentSkipListSet<Integer> INTERCEPTED_PARTS = new ConcurrentSkipListSet();
    private static final ConcurrentSkipListSet<ClusterNode> INTERCEPTED_NODES = new ConcurrentSkipListSet();
    private static final TcpDiscoveryVmIpFinder IP_FINDER = new TcpDiscoveryVmIpFinder().setShared(true);
    protected static final String REGION_MEM = "mem";
    protected static final String REGION_DISK = "disk";
    private static final String CLI_NAME = "cli";

    protected void beforeTestsStarted() throws Exception {
        super.beforeTestsStarted();
        this.cleanPersistenceDir();
        this.startGrid(this.getConfiguration("srv1"));
        this.startGrid(this.getConfiguration("srv2"));
        this.startGrid(this.getConfiguration("srv3"));
        this.startGrid(this.getConfiguration(CLI_NAME).setClientMode(true));
        this.client().cluster().active(true);
    }

    protected void beforeTest() throws Exception {
        super.beforeTest();
        IgniteEx cli = this.client();
        cli.destroyCaches(cli.cacheNames());
    }

    protected void afterTestsStopped() throws Exception {
        this.stopAllGrids();
        this.cleanPersistenceDir();
        super.afterTestsStopped();
    }

    protected IgniteConfiguration getConfiguration(String name) throws Exception {
        return super.getConfiguration(name).setDiscoverySpi((DiscoverySpi)new TcpDiscoverySpi().setIpFinder((TcpDiscoveryIpFinder)IP_FINDER)).setCommunicationSpi((CommunicationSpi)new TrackingTcpCommunicationSpi()).setLocalHost("127.0.0.1").setDataStorageConfiguration(new DataStorageConfiguration().setDataRegionConfigurations(new DataRegionConfiguration[]{new DataRegionConfiguration().setName(REGION_DISK).setPersistenceEnabled(true)}).setDefaultDataRegionConfiguration(new DataRegionConfiguration().setName(REGION_MEM).setPersistenceEnabled(false)));
    }

    protected void createPartitionedTable(String name, Object ... cols) {
        this.createPartitionedTable(false, name, cols);
    }

    protected void createPartitionedTable(boolean mvcc, String name, Object ... cols) {
        this.createTable0(name, false, mvcc, cols);
    }

    protected void createReplicatedTable(String name, Object ... cols) {
        this.createReplicatedTable(false, name, cols);
    }

    protected void createReplicatedTable(boolean mvcc, String name, Object ... cols) {
        this.createTable0(name, true, mvcc, cols);
    }

    private void createTable0(String name, boolean replicated, boolean mvcc, Object ... cols) {
        ArrayList<String> pkCols = new ArrayList<String>();
        String affCol = null;
        StringBuilder sql = new StringBuilder("CREATE TABLE ").append(name).append("(");
        for (Object col : cols) {
            Column col0 = col instanceof Column ? (Column)col : new Column((String)col, false, false);
            sql.append(col0.name()).append(" VARCHAR, ");
            if (col0.pk()) {
                pkCols.add(col0.name());
            }
            if (!col0.affinity()) continue;
            if (affCol != null) {
                throw new IllegalStateException("Only one affinity column is allowed: " + col0.name());
            }
            affCol = col0.name();
        }
        if (pkCols.isEmpty()) {
            throw new IllegalStateException("No PKs!");
        }
        sql.append("PRIMARY KEY (");
        boolean firstPkCol = true;
        for (String pkCol : pkCols) {
            if (firstPkCol) {
                firstPkCol = false;
            } else {
                sql.append(", ");
            }
            sql.append(pkCol);
        }
        sql.append(")");
        sql.append(") WITH \"template=" + (replicated ? "replicated" : "partitioned"));
        sql.append(", CACHE_NAME=" + name);
        if (affCol != null) {
            sql.append(", AFFINITY_KEY=" + affCol);
            sql.append(", KEY_TYPE=" + name + "_key");
        }
        if (mvcc) {
            sql.append(", atomicity=TRANSACTIONAL_SNAPSHOT");
        }
        sql.append("\"");
        this.executeSql(sql.toString(), new Object[0]);
    }

    public void execute(String sql, Consumer<List<List<?>>> resConsumer, Object ... args) {
        System.out.println(">>> TEST COMBINATION: " + sql);
        List<List<?>> res = this.executeSingle(sql, args);
        resConsumer.accept(res);
        if (args != null && args.length > 0) {
            this.executeCombinations0(sql, resConsumer, new HashSet<String>(), args);
        }
        System.out.println();
    }

    private void executeCombinations0(String sql, Consumer<List<List<?>>> resConsumer, Set<String> executedSqls, Object ... args) {
        int paramPos;
        assert (args != null && args.length > 0);
        ArrayList<Integer> paramPoss = new ArrayList<Integer>();
        int pos = 0;
        while ((paramPos = sql.indexOf(63, pos)) != -1) {
            paramPoss.add(paramPos);
            pos = paramPos + 1;
        }
        for (int i = 0; i < args.length; ++i) {
            int paramPos2 = (Integer)paramPoss.get(i);
            String newSql = sql.substring(0, paramPos2) + args[i] + sql.substring(paramPos2 + 1);
            Object[] newArgs = new Object[args.length - 1];
            int newArgsPos = 0;
            for (int j = 0; j < args.length; ++j) {
                if (j == i) continue;
                newArgs[newArgsPos++] = args[j];
            }
            if (executedSqls.add(newSql)) {
                List<List<?>> res = this.executeSingle(newSql, newArgs);
                resConsumer.accept(res);
            }
            if (newArgs.length <= 0) continue;
            this.executeCombinations0(newSql, resConsumer, executedSqls, newArgs);
        }
    }

    protected List<List<?>> executeSingle(String sql, Object ... args) {
        AbstractPartitionPruningBaseTest.clearIoState();
        return this.executeSql(sql, args);
    }

    protected List<List<?>> executeSql(String sql, Object ... args) {
        if (args == null || args.length == 0) {
            System.out.println(">>> " + sql);
        } else {
            System.out.println(">>> " + sql + " " + Arrays.toString(args));
        }
        SqlFieldsQuery qry = new SqlFieldsQuery(sql);
        if (args != null && args.length > 0) {
            qry.setArgs(args);
        }
        return this.executeSqlFieldsQuery(qry);
    }

    protected List<List<?>> executeSqlFieldsQuery(SqlFieldsQuery qry) {
        return this.client().context().query().querySqlFields(qry, false).getAll();
    }

    protected IgniteEx client() {
        return this.grid(CLI_NAME);
    }

    protected static void clearIoState() {
        INTERCEPTED_REQS.set(0);
        INTERCEPTED_PARTS.clear();
        INTERCEPTED_NODES.clear();
    }

    protected static void assertPartitions(int ... expParts) {
        TreeSet<Integer> expParts0 = new TreeSet<Integer>();
        for (int expPart : expParts) {
            expParts0.add(expPart);
        }
        AbstractPartitionPruningBaseTest.assertPartitions(expParts0);
    }

    protected static void assertPartitions(Collection<Integer> expParts) {
        TreeSet<Integer> expParts0 = new TreeSet<Integer>(expParts);
        TreeSet<Integer> actualParts = new TreeSet<Integer>((SortedSet<Integer>)INTERCEPTED_PARTS);
        AbstractPartitionPruningBaseTest.assertEquals((String)("Unexpected partitions [exp=" + expParts + ", actual=" + actualParts + ']'), expParts0, actualParts);
    }

    protected static void assertNoPartitions() {
        AbstractPartitionPruningBaseTest.assertTrue((String)"No requests were sent.", (INTERCEPTED_REQS.get() > 0 ? 1 : 0) != 0);
        AbstractPartitionPruningBaseTest.assertTrue((String)("Partitions are not empty: " + INTERCEPTED_PARTS), (boolean)INTERCEPTED_PARTS.isEmpty());
    }

    protected static void assertNoRequests() {
        AbstractPartitionPruningBaseTest.assertEquals((String)("Requests were sent: " + INTERCEPTED_REQS.get()), (int)0, (int)INTERCEPTED_REQS.get());
    }

    protected int partition(String cacheName, Object key) {
        return this.client().affinity(cacheName).partition(key);
    }

    protected static void assertNodes(ClusterNode ... expNodes) {
        TreeSet<ClusterNode> expNodes0 = new TreeSet<ClusterNode>();
        for (ClusterNode expNode : expNodes) {
            expNodes0.add(expNode);
        }
        AbstractPartitionPruningBaseTest.assertNodes(expNodes0);
    }

    protected static void assertNodes(Collection<ClusterNode> expNodes) {
        TreeSet<ClusterNode> expNodes0 = new TreeSet<ClusterNode>(expNodes);
        TreeSet<ClusterNode> actualNodes = new TreeSet<ClusterNode>((SortedSet<ClusterNode>)INTERCEPTED_NODES);
        AbstractPartitionPruningBaseTest.assertEquals((String)("Unexpected nodes [exp=" + expNodes + ", actual=" + actualNodes + ']'), expNodes0, actualNodes);
    }

    protected ClusterNode node(String cacheName, Object key) {
        return this.client().affinity(cacheName).mapKeyToNode(key);
    }

    public Column pkColumn(String name) {
        return new Column(name, true, false);
    }

    public Column affinityColumn(String name) {
        return new Column(name, true, true);
    }

    private static class Column {
        private final String name;
        private final boolean pk;
        private final boolean aff;

        public Column(String name, boolean pk, boolean aff) {
            this.name = name;
            this.pk = pk;
            this.aff = aff;
        }

        public String name() {
            return this.name;
        }

        public boolean pk() {
            return this.pk;
        }

        public boolean affinity() {
            return this.aff;
        }
    }

    private static class TrackingTcpCommunicationSpi
    extends TcpCommunicationSpi {
        private TrackingTcpCommunicationSpi() {
        }

        public void sendMessage(ClusterNode node, Message msg, IgniteInClosure<IgniteException> ackC) {
            if (msg instanceof GridIoMessage) {
                GridIoMessage msg0 = (GridIoMessage)msg;
                if (msg0.message() instanceof GridH2QueryRequest) {
                    INTERCEPTED_NODES.add(node);
                    INTERCEPTED_REQS.incrementAndGet();
                    GridH2QueryRequest req = (GridH2QueryRequest)msg0.message();
                    int[] parts = req.queryPartitions();
                    if (!F.isEmpty((int[])parts)) {
                        for (int part : parts) {
                            INTERCEPTED_PARTS.add(part);
                        }
                    }
                } else if (msg0.message() instanceof GridNearTxQueryEnlistRequest) {
                    INTERCEPTED_NODES.add(node);
                    INTERCEPTED_REQS.incrementAndGet();
                    GridNearTxQueryEnlistRequest req = (GridNearTxQueryEnlistRequest)msg0.message();
                    int[] parts = req.partitions();
                    if (!F.isEmpty((int[])parts)) {
                        for (int part : parts) {
                            INTERCEPTED_PARTS.add(part);
                        }
                    }
                }
            }
            super.sendMessage(node, msg, ackC);
        }
    }
}

