/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.sql;

import java.util.List;
import org.apache.ignite.Ignite;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.processors.cache.index.AbstractIndexingCommonTest;
import org.apache.ignite.internal.processors.query.IgniteSQLException;
import org.apache.ignite.internal.util.typedef.X;
import org.apache.ignite.testframework.GridTestUtils;
import org.junit.Test;

public class SqlUnsupportedSelfTest
extends AbstractIndexingCommonTest {
    private boolean local;

    protected void beforeTest() throws Exception {
        super.beforeTest();
        this.cleanPersistenceDir();
        this.startGrid();
        this.startGrid(1);
    }

    protected void afterTest() throws Exception {
        this.stopAllGrids();
        this.cleanPersistenceDir();
    }

    @Test
    public void testUnsupportedTypes() {
        this.assertSqlUnsupported("CREATE TABLE test (id integer PRIMARY KEY, val TIMESTAMP WITH TIME ZONE)");
        this.assertSqlUnsupported("CREATE TABLE test (id integer PRIMARY KEY, val ENUM ('A', 'B', 'C'))");
        this.execSql("CREATE TABLE test (id integer PRIMARY KEY, val TIMESTAMP)", new Object[0]);
        this.assertSqlUnsupported("SELECT CAST (val as TIMESTAMP WITH TIME ZONE) FROM test ");
    }

    @Test
    public void testUnsupportedCreateTable() {
        this.assertSqlUnsupported("CREATE MEMORY TABLE unsupported_tbl0 (id integer primary key, val integer)", "MEMORY and NOT PERSISTENT keywords are not supported");
        this.assertSqlUnsupported("CREATE GLOBAL TEMPORARY TABLE unsupported_tbl1 (id integer primary key, val integer)", "GLOBAL TEMPORARY keyword is not supported");
        this.assertSqlUnsupported("CREATE LOCAL TEMPORARY TABLE unsupported_tbl2 (id integer primary key, val integer)", "TEMPORARY keyword is not supported");
        this.assertSqlUnsupported("CREATE TEMPORARY TABLE unsupported_tbl3 (id integer primary key, val integer)", "TEMPORARY keyword is not supported");
        this.assertSqlUnsupported("CREATE TABLE unsupported_tbl4 (id integer primary key, val integer) HIDDEN", "HIDDEN keyword is not supported");
    }

    @Test
    public void testUnsupportedCreateIndex() {
        this.execSql("CREATE TABLE test ( id integer PRIMARY KEY, val varchar DEFAULT 'test_val')", new Object[0]);
        this.assertSqlUnsupported("CREATE INDEX test_idx ON test (val NULLS FIRST)");
        this.assertSqlUnsupported("CREATE INDEX test_idx ON test (val NULLS LAST)");
        this.assertSqlUnsupported("CREATE UNIQUE INDEX test_idx ON test (val)");
        this.assertSqlUnsupported("CREATE HASH INDEX test_idx ON test (val)");
    }

    @Test
    public void testUnsupportedDefault() {
        this.execSql("CREATE TABLE test ( id integer PRIMARY KEY, val varchar DEFAULT 'test_val')", new Object[0]);
        this.assertSqlUnsupported("INSERT INTO test (id, val) VALUES (0, DEFAULT)");
        this.assertSqlUnsupported("MERGE INTO test (id, val) VALUES (0, DEFAULT)");
        this.assertSqlUnsupported("UPDATE test SET val=DEFAULT");
    }

    @Test
    public void testUnsupportedAlterTableColumn() {
        this.execSql("CREATE TABLE test ( id integer PRIMARY KEY, val varchar DEFAULT 'test_val')", new Object[0]);
        this.assertSqlUnsupported("ALTER TABLE test ALTER COLUMN val SELECTIVITY 1");
        this.assertSqlUnsupported("ALTER TABLE test ALTER COLUMN val SET DEFAULT 'new val'");
        this.assertSqlUnsupported("ALTER TABLE test ALTER COLUMN val DROP DEFAULT");
        this.assertSqlUnsupported("ALTER TABLE test ALTER COLUMN val SET ON UPDATE 'new val'");
        this.assertSqlUnsupported("ALTER TABLE test ALTER COLUMN val DROP ON UPDATE");
        this.assertSqlUnsupported("ALTER TABLE test ALTER COLUMN val SET NULL");
        this.assertSqlUnsupported("ALTER TABLE test ALTER COLUMN val SET NOT NULL");
        this.assertSqlUnsupported("ALTER TABLE test ALTER COLUMN val SET VISIBLE");
        this.assertSqlUnsupported("ALTER TABLE test ALTER COLUMN val SET INVISIBLE");
        this.assertSqlUnsupported("ALTER TABLE test ADD COLUMN (q integer) FIRST", "FIRST keyword is not supported");
        this.assertSqlUnsupported("ALTER TABLE test ADD COLUMN (q integer) BEFORE val", "BEFORE keyword is not supported");
        this.assertSqlUnsupported("ALTER TABLE test ADD COLUMN (q integer) AFTER val", "AFTER keyword is not supported");
    }

    @Test
    public void testUnsupportedCTE() {
        this.execSql("WITH temp (A, B) AS (SELECT 1, 2) SELECT * FROM temp", new Object[0]);
        this.assertSqlUnsupported("WITH RECURSIVE temp (n, fact) AS (SELECT 0, 1 UNION ALL SELECT n+1, (n+1)*fact FROM temp WHERE n < 9) SELECT * FROM temp;");
        this.execSql("CREATE TABLE test ( id integer primary key, parent integer DEFAULT 0, nm varchar)", new Object[0]);
        this.assertSqlUnsupported("WITH RECURSIVE tree (nm, id, level, pathstr) AS (SELECT nm, id, 0, CAST('' AS text) FROM test WHERE parent IS NULL UNION ALL SELECT test.nm, test.id, tree.level + 1, tree.pathstr + test.nm FROM TEST INNER JOIN tree ON tree.id = test.parent) SELECT id, space( level ) + nm AS nm FROM tree ORDER BY pathstr");
    }

    @Test
    public void testUnsupportedSqlStatements() {
        this.execSql("CREATE TABLE test ( id integer PRIMARY KEY, val varchar DEFAULT 'test_val')", new Object[0]);
        this.assertSqlUnsupported("CREATE SCHEMA my_schema");
        this.assertSqlUnsupported("DROP SCHEMA my_schema");
        this.assertSqlUnsupported("ALTER SCHEMA public RENAME TO private");
        this.assertSqlUnsupported("ALTER TABLE test ADD CONSTRAINT c0 UNIQUE(val)");
        this.assertSqlUnsupported("ALTER TABLE test RENAME CONSTRAINT c0 TO c1");
        this.assertSqlUnsupported("ALTER TABLE test DROP CONSTRAINT c0");
        this.assertSqlUnsupported("ALTER TABLE test RENAME TO new_test");
        this.assertSqlUnsupported("ALTER TABLE test SET REFERENTIAL_INTEGRITY FALSE");
        this.assertSqlUnsupported("ANALYZE TABLE test");
        this.assertSqlUnsupported("ALTER INDEX idx0 RENAME TO idx1");
        this.assertSqlUnsupported("CREATE VIEW test_view AS SELECT * FROM test WHERE id < 100");
        this.assertSqlUnsupported("DROP VIEW test_view");
        this.assertSqlUnsupported("CREATE SEQUENCE SEQ_0");
        this.assertSqlUnsupported("ALTER SEQUENCE SEQ_ID RESTART WITH 1000");
        this.assertSqlUnsupported("DROP SEQUENCE SEQ_0");
        this.assertSqlUnsupported("CREATE ROLE newRole");
        this.assertSqlUnsupported("DROP ROLE newRole");
        this.assertSqlUnsupported("RUNSCRIPT FROM 'q.sql'");
        this.assertSqlUnsupported("SCRIPT NODATA");
        this.assertSqlUnsupported("BACKUP TO 'q.bak'");
        this.assertSqlUnsupported("CALL 15*25");
        this.assertSqlUnsupported("COMMENT ON TABLE test IS 'Table used for testing'");
        this.assertSqlUnsupported("CREATE AGGREGATE testAgg FOR \"class_name\"");
        this.assertSqlUnsupported("CREATE ALIAS my_sqrt FOR \"java.lang.Math.sqrt\"");
        this.assertSqlUnsupported("DROP ALIAS my_sqrt");
        this.assertSqlUnsupported("CREATE CONSTANT ONE VALUE 1");
        this.assertSqlUnsupported("DROP CONSTANT ONE");
        this.assertSqlUnsupported("CREATE DOMAIN EMAIL AS VARCHAR(255) CHECK (POSITION('@', VALUE) > 1)");
        this.assertSqlUnsupported("DROP DOMAIN EMAIL");
        this.assertSqlUnsupported("CREATE LINKED TABLE link('', '', '', '', '(SELECT * FROM test WHERE ID>0)');");
        this.assertSqlUnsupported("DROP ALL OBJECTS");
        this.assertSqlUnsupported("TRUNCATE TABLE test");
        this.assertSqlUnsupported("COMMIT TRANSACTION t0");
        this.assertSqlUnsupported("SAVEPOINT sp0");
        this.assertSqlUnsupported("SET LOG 1");
        this.assertSqlUnsupported("SHOW SCHEMAS");
        this.assertSqlUnsupported("SHOW TABLES");
        this.assertSqlUnsupported("SHOW COLUMNS FROM test");
        this.assertSqlUnsupported("HELP SELECT");
        this.assertSqlUnsupported("GRANT SELECT ON test TO PUBLIC");
        this.assertSqlUnsupported("REVOKE SELECT ON test FROM PUBLIC");
    }

    private List<List<?>> execSql(Ignite ignite, String sql, Object ... args) {
        SqlFieldsQuery qry = new SqlFieldsQuery(sql).setLocal(this.local);
        if (args != null && args.length > 0) {
            qry.setArgs(args);
        }
        return ((IgniteEx)ignite).context().query().querySqlFields(qry, false).getAll();
    }

    private List<List<?>> execSql(String sql, Object ... args) {
        return this.execSql((Ignite)this.grid(), sql, args);
    }

    private void assertSqlUnsupported(String sql) {
        this.assertSqlUnsupported(sql, "");
    }

    private void assertSqlUnsupported(String sql, String msg) {
        try {
            this.local = false;
            this.assertSqlUnsupported0(sql, msg);
            this.local = true;
            this.assertSqlUnsupported0(sql, msg);
        }
        finally {
            this.local = false;
        }
    }

    private void assertSqlUnsupported0(String sql, String msg) {
        Throwable t = GridTestUtils.assertThrowsWithCause(() -> {
            this.execSql(sql, new Object[0]);
            return null;
        }, IgniteSQLException.class);
        IgniteSQLException sqlE = (IgniteSQLException)X.cause((Throwable)t, IgniteSQLException.class);
        assert (sqlE != null);
        if (1002 != sqlE.statusCode() || !sqlE.getMessage().contains(msg)) {
            log.error("Unexpected exception", t);
            SqlUnsupportedSelfTest.fail((String)"Unexpected exception. See above");
        }
    }
}

