/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.sql;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import org.apache.ignite.Ignite;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.processors.query.IgniteSQLException;
import org.apache.ignite.internal.util.typedef.X;
import org.apache.ignite.testframework.GridTestUtils;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.gridgain.internal.h2.api.Trigger;
import org.junit.Test;

public class SqlDisabledFeaturesSelfTest
extends GridCommonAbstractTest {
    private boolean local;

    protected void beforeTest() throws Exception {
        super.beforeTest();
        this.cleanPersistenceDir();
        this.startGrid();
        this.startGrid(1);
    }

    protected void afterTest() throws Exception {
        this.stopAllGrids();
        this.cleanPersistenceDir();
    }

    @Test
    public void testUnsupportedTrigers() {
        this.execSql("CREATE TABLE test ( id integer PRIMARY KEY, val varchar DEFAULT 'test_val')", new Object[0]);
        this.assertCantBeParsed("CREATE TRIGGER trig_0 BEFORE INSERT ON TEST FOR EACH ROW CALL \"" + TestTrigger.class.getName() + "\"", "Failed to parse query. Syntax error in SQL statement \"CREATE TRIGGER[*]");
        this.assertCantBeParsed("DROP TRIGGER trig_0", "Failed to parse query. Syntax error in SQL statement \"DROP TRIGGER[*]");
    }

    private List<List<?>> execSql(Ignite ignite, String sql, Object ... args) {
        SqlFieldsQuery qry = new SqlFieldsQuery(sql).setLocal(this.local);
        if (args != null && args.length > 0) {
            qry.setArgs(args);
        }
        return ((IgniteEx)ignite).context().query().querySqlFields(qry, false).getAll();
    }

    private List<List<?>> execSql(String sql, Object ... args) {
        return this.execSql((Ignite)this.grid(), sql, args);
    }

    private void assertCantBeParsed(String sql, String msg) {
        try {
            this.local = false;
            this.assertCantBeParsed0(sql, msg);
            this.local = true;
            this.assertCantBeParsed0(sql, msg);
        }
        finally {
            this.local = false;
        }
    }

    private void assertCantBeParsed0(String sql, String msg) {
        Throwable t = GridTestUtils.assertThrowsWithCause(() -> {
            this.execSql(sql, new Object[0]);
            return null;
        }, IgniteSQLException.class);
        IgniteSQLException sqlE = (IgniteSQLException)X.cause((Throwable)t, IgniteSQLException.class);
        assert (sqlE != null);
        if (1001 != sqlE.statusCode() || !sqlE.getMessage().contains(msg)) {
            log.error("Unexpected exception", t);
            SqlDisabledFeaturesSelfTest.fail((String)"Unexpected exception. See above");
        }
    }

    private static class TestTrigger
    implements Trigger {
        private TestTrigger() {
        }

        public void init(Connection conn, String schemaName, String triggerName, String tableName, boolean before, int type) throws SQLException {
        }

        public void fire(Connection conn, Object[] oldRow, Object[] newRow) throws SQLException {
        }

        public void close() throws SQLException {
        }

        public void remove() throws SQLException {
        }
    }
}

