/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import javax.cache.Cache;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cache.CachePeekMode;
import org.apache.ignite.cache.affinity.AffinityFunction;
import org.apache.ignite.cache.affinity.rendezvous.RendezvousAffinityFunction;
import org.apache.ignite.cache.query.FieldsQueryCursor;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.cache.query.annotations.QuerySqlField;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.DataRegionConfiguration;
import org.apache.ignite.configuration.DataStorageConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.processors.query.IgniteSQLException;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.G;
import org.apache.ignite.testframework.GridTestUtils;
import org.apache.ignite.testframework.junits.WithSystemProperty;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.junit.Test;

public class TableWithImplicitPkTest
extends GridCommonAbstractTest {
    private static final int NODES_CNT = 3;

    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        return super.getConfiguration(igniteInstanceName).setCacheConfiguration(new CacheConfiguration[]{this.cacheCfg()}).setDataStorageConfiguration(new DataStorageConfiguration().setDefaultDataRegionConfiguration(new DataRegionConfiguration().setPersistenceEnabled(true)));
    }

    private CacheConfiguration<?, ?> cacheCfg() {
        return new CacheConfiguration("default").setAffinity((AffinityFunction)new RendezvousAffinityFunction(false, 16)).setBackups(1);
    }

    protected void beforeTestsStarted() throws Exception {
        this.cleanPersistenceDir();
        this.startGridsMultiThreaded(3).addCacheConfiguration(this.cacheCfg());
    }

    protected void beforeTest() throws Exception {
        List cachesToDestroy = this.grid(0).cacheNames().stream().filter(name -> !"default".equals(name)).collect(Collectors.toList());
        if (!cachesToDestroy.isEmpty()) {
            this.grid(0).destroyCaches(cachesToDestroy);
            this.awaitPartitionMapExchange();
        }
    }

    @Test
    @WithSystemProperty(key="IGNITE_SQL_ALLOW_IMPLICIT_PK", value="true")
    public void testBasicOperations() {
        GridTestUtils.assertThrows((IgniteLogger)log, () -> this.querySql("CREATE TABLE integers(i INTEGER) WITH \"wrap_key=true\"", new Object[0]), IgniteSQLException.class, null);
        GridTestUtils.assertThrows((IgniteLogger)log, () -> this.querySql("CREATE TABLE integers()", new Object[0]), IgniteSQLException.class, (String)"Table must have at least one non PRIMARY KEY column");
        this.querySql("CREATE TABLE integers(i INTEGER)", new Object[0]);
        int rowsCnt = 5;
        HashSet<Integer> expNums = new HashSet<Integer>();
        for (int n = 0; n < rowsCnt; ++n) {
            expNums.add(n);
            this.querySql("INSERT INTO integers VALUES(?)", n);
        }
        List<List<?>> rows = this.querySql("SELECT * FROM integers", new Object[0]);
        TableWithImplicitPkTest.assertEquals((int)rowsCnt, (int)rows.size());
        HashSet<Integer> resSet = new HashSet<Integer>();
        for (List<?> row : rows) {
            TableWithImplicitPkTest.assertEquals((int)1, (int)row.size());
            resSet.add((Integer)row.get(0));
        }
        TableWithImplicitPkTest.assertEquals(expNums, resSet);
    }

    @Test
    @WithSystemProperty(key="IGNITE_SQL_ALLOW_IMPLICIT_PK", value="true")
    public void testCacheApiCompatibility() {
        int i;
        this.querySql("CREATE TABLE person(name VARCHAR, age INT) WITH \"value_type=" + Person.class.getName() + "\"", new Object[0]);
        IgniteCache cache = this.grid(0).cache("SQL_PUBLIC_PERSON");
        String[] names = new String[]{"Hektor", "Emma", "Tom", "Gloria", "Brad", "Ann", "Will", "Courtney"};
        ArrayList<Person> persons = new ArrayList<Person>(names.length);
        for (String name : names) {
            persons.add(new Person(name, ThreadLocalRandom.current().nextInt(100)));
        }
        HashSet<UUID> expKeys = new HashSet<UUID>();
        for (i = 0; i < names.length / 2; ++i) {
            UUID id = UUID.randomUUID();
            expKeys.add(id);
            cache.put((Object)id, persons.get(i));
        }
        for (i = names.length / 2; i < names.length; ++i) {
            Person person = (Person)persons.get(i);
            this.querySql("INSERT INTO person VALUES(?, ?)", person.getName(), person.getAge());
        }
        List<List<?>> rows = this.querySql("SELECT _key, * FROM person", new Object[0]);
        TableWithImplicitPkTest.assertEquals((int)names.length, (int)cache.size(new CachePeekMode[0]));
        TableWithImplicitPkTest.assertEquals((int)names.length, (int)rows.size());
        Map<UUID, Person> sqlPersons = rows.stream().collect(Collectors.toMap(l -> (UUID)l.get(0), l -> new Person((String)l.get(1), (Integer)l.get(2))));
        TableWithImplicitPkTest.assertEquals(new HashSet(persons), new HashSet<Person>(sqlPersons.values()));
        TableWithImplicitPkTest.assertTrue((boolean)sqlPersons.keySet().containsAll(expKeys));
        HashMap<Object, Object> cachePersons = new HashMap<Object, Object>();
        for (Cache.Entry e : cache) {
            cachePersons.put(e.getKey(), e.getValue());
        }
        TableWithImplicitPkTest.assertEquals(sqlPersons, cachePersons);
        TableWithImplicitPkTest.assertTrue((boolean)cachePersons.keySet().containsAll(expKeys));
        for (Map.Entry<UUID, Person> p : sqlPersons.entrySet()) {
            TableWithImplicitPkTest.assertEquals((Object)cache.get((Object)p.getKey()), (Object)p.getValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @WithSystemProperty(key="IGNITE_SQL_ALLOW_IMPLICIT_PK", value="true")
    public void testNodeRestart() throws Exception {
        this.querySql("CREATE TABLE uuids(i UUID) with \"template=default\"", new Object[0]);
        int dataCnt = 100;
        HashSet expRows = new HashSet();
        BiConsumer<Integer, Integer> fillData = (off, cnt) -> {
            for (int i = off.intValue(); i < cnt; ++i) {
                UUID id = UUID.randomUUID();
                expRows.add(id);
                this.querySql("INSERT INTO uuids(i) VALUES(?)", id);
            }
        };
        fillData.accept(0, dataCnt / 2);
        this.stopAllGrids();
        System.clearProperty("IGNITE_SQL_ALLOW_IMPLICIT_PK");
        this.startGridsMultiThreaded(3);
        GridTestUtils.assertThrows((IgniteLogger)log, () -> this.querySql("CREATE TABLE test(i INT)", new Object[0]), IgniteSQLException.class, null);
        fillData.accept(dataCnt / 2, dataCnt);
        this.stopGrid(0);
        try {
            List<List<?>> rows = this.querySql("SELECT * FROM uuids", new Object[0]);
            TableWithImplicitPkTest.assertEquals((int)dataCnt, (int)rows.size());
            Set resRows = rows.stream().map(l -> (UUID)l.get(0)).collect(Collectors.toSet());
            TableWithImplicitPkTest.assertEquals(expRows, resRows);
        }
        finally {
            this.startGrid(0);
        }
    }

    private List<List<?>> querySql(String sql, Object ... args) {
        IgniteCache cache = ((Ignite)F.first((List)G.allGrids())).cache("default");
        try (FieldsQueryCursor cur = cache.query(new SqlFieldsQuery(sql).setArgs(args));){
            TableWithImplicitPkTest.assertNotNull((Object)cur);
            List list = cur.getAll();
            return list;
        }
    }

    private static class Person
    implements Serializable {
        @QuerySqlField
        private final String name;
        @QuerySqlField
        private final Integer age;

        public Person(String name, Integer age) {
            this.name = name;
            this.age = age;
        }

        public String getName() {
            return this.name;
        }

        public Integer getAge() {
            return this.age;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Person person = (Person)o;
            return Objects.equals(this.name, person.name) && Objects.equals(this.age, person.age);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.age);
        }

        public String toString() {
            return "Person{name='" + this.name + '\'' + ", age=" + this.age + '}';
        }
    }
}

