/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2;

import java.util.List;
import java.util.regex.Pattern;
import org.apache.ignite.cache.query.FieldsQueryCursor;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.processors.cache.index.AbstractIndexingCommonTest;
import org.apache.ignite.testframework.GridTestUtils;
import org.junit.Test;

public class StatementCacheTest
extends AbstractIndexingCommonTest {
    private static final int SIZE_BIG = 1000;
    private static final int SIZE_SMALL = 10;
    private boolean enforceJoinOrder;
    private boolean local;
    private boolean distributedJoin;
    private boolean collocatedGroupBy;

    protected void beforeTest() throws Exception {
        super.beforeTest();
        this.local = false;
        this.enforceJoinOrder = false;
        this.distributedJoin = false;
        this.collocatedGroupBy = false;
    }

    protected void afterTest() throws Exception {
        this.stopAllGrids();
        super.afterTest();
    }

    @Test
    public void testEnforceJoinOrderFlag() throws Exception {
        this.startGrids(1);
        this.sql("CREATE TABLE TBL0 (ID INT PRIMARY KEY, JID INT, VAL INT)", new Object[0]);
        this.sql("CREATE TABLE TBL1 (ID INT PRIMARY KEY, JID INT, VAL INT)", new Object[0]);
        this.sql("CREATE INDEX IDX_TBL1_JID ON TBL1(JID)", new Object[0]);
        this.sql("INSERT INTO TBL0 VALUES (0, 0, 0)", new Object[0]);
        for (int i = 0; i < 1000; ++i) {
            this.sql("INSERT INTO TBL1 VALUES (?, ?, ?)", i, i + 1, i);
        }
        this.local = true;
        this.sql("EXPLAIN SELECT TBL1.ID FROM TBL1, TBL0 WHERE TBL0.JID=TBL1.JID", new Object[0]).getAll();
        this.enforceJoinOrder = true;
        String plan = (String)((List)this.sql("EXPLAIN SELECT TBL1.ID FROM TBL1, TBL0 WHERE TBL0.JID=TBL1.JID", new Object[0]).getAll().get(0)).get(0);
        StatementCacheTest.assertTrue((String)("Invalid join order: " + plan), (boolean)Pattern.compile("\"PUBLIC\".\"TBL1\"[\\n\\w\\W]+\"PUBLIC\".\"TBL0\"", 8).matcher(plan).find());
    }

    @Test
    public void testDistributedJoinFlag() throws Exception {
        int i;
        this.startGrids(3);
        this.sql("CREATE TABLE TBL0 (ID INT PRIMARY KEY, JID INT, VAL INT)", new Object[0]);
        this.sql("CREATE TABLE TBL1 (ID INT PRIMARY KEY, JID INT, VAL INT)", new Object[0]);
        this.sql("CREATE INDEX IDX_TBL0_JID ON TBL0(JID)", new Object[0]);
        this.sql("CREATE INDEX IDX_TBL1_JID ON TBL1(JID)", new Object[0]);
        for (i = 0; i < 10; ++i) {
            this.sql("INSERT INTO TBL0 VALUES (?, ?, ?)", i + 1, i + 1, i + 1);
        }
        for (i = 0; i < 1000; ++i) {
            this.sql("INSERT INTO TBL1 VALUES (?, ?, ?)", i, i + 1, i);
        }
        this.distributedJoin = false;
        GridTestUtils.runMultiThreaded(() -> {
            for (int i = 0; i < 100; ++i) {
                this.sql("SELECT TBL1.ID FROM TBL1, TBL0 WHERE TBL0.JID=TBL1.JID", new Object[0]).getAll();
            }
        }, (int)20, (String)"statements-cache-warmup");
        int size = this.sql("SELECT TBL1.ID FROM TBL1, TBL0 WHERE TBL0.JID=TBL1.JID", new Object[0]).getAll().size();
        this.distributedJoin = true;
        int distSize = this.sql("SELECT TBL1.ID FROM TBL1, TBL0 WHERE TBL0.JID=TBL1.JID", new Object[0]).getAll().size();
        StatementCacheTest.assertEquals((String)"Invalid result set size of distributed join", (int)10, (int)distSize);
        StatementCacheTest.assertTrue((String)("Invalid result set size of collocated join: " + size), (size > 0 && size < distSize ? 1 : 0) != 0);
    }

    @Test
    public void testCollocatedFlag() throws Exception {
        this.startGrids(3);
        Object[][] rows = new Object[][]{{1, "Bob", 10, "Shank"}, {2, "Bob", 10, "Shank"}, {3, "Bob", 10, "Shank"}, {4, "Bill", 10, "Shank"}, {5, "Bill", 10, "Shank"}, {6, "Bill", 10, "Shank"}};
        this.sql("CREATE TABLE TEST(ID INT PRIMARY KEY, NAME0 VARCHAR, AGE INT, NAME1 VARCHAR)", new Object[0]);
        for (Object[] row : rows) {
            this.sql("INSERT INTO TEST VALUES (?, ?, ?, ?)", row);
        }
        this.collocatedGroupBy = false;
        GridTestUtils.runMultiThreaded(() -> {
            for (int i = 0; i < 100; ++i) {
                this.sql("SELECT SUM(AGE), NAME0 FROM TEST GROUP BY name0", new Object[0]).getAll();
                this.sql("SELECT SUM(AGE), NAME1 FROM TEST GROUP BY name1", new Object[0]).getAll();
            }
        }, (int)20, (String)"statements-cache-warmup");
        int size = this.sql("SELECT SUM(AGE), NAME0 FROM TEST GROUP BY name0", new Object[0]).getAll().size();
        this.collocatedGroupBy = true;
        int collSize = this.sql("SELECT SUM(AGE), NAME0 FROM TEST GROUP BY name0", new Object[0]).getAll().size();
        StatementCacheTest.assertEquals((String)"Invalid group by results", (int)2, (int)size);
        StatementCacheTest.assertTrue((String)"Result set of collocated query must be invalid on not collocated data", (collSize > size ? 1 : 0) != 0);
        this.collocatedGroupBy = false;
        size = this.sql("SELECT SUM(AGE), NAME1 FROM TEST GROUP BY name1", new Object[0]).getAll().size();
        this.collocatedGroupBy = true;
        collSize = this.sql("SELECT SUM(AGE), NAME1 FROM TEST GROUP BY name1", new Object[0]).getAll().size();
        StatementCacheTest.assertEquals((String)"Invalid group by results", (int)1, (int)size);
        StatementCacheTest.assertTrue((String)"Result set of collocated query must be invalid on not collocated data", (collSize > size ? 1 : 0) != 0);
    }

    private FieldsQueryCursor<List<?>> sql(String sql, Object ... args) {
        return this.sql(this.grid(0), sql, args);
    }

    private FieldsQueryCursor<List<?>> sql(IgniteEx ign, String sql, Object ... args) {
        return ign.context().query().querySqlFields(new SqlFieldsQuery(sql).setLocal(this.local).setEnforceJoinOrder(this.enforceJoinOrder).setDistributedJoins(this.distributedJoin).setCollocated(this.collocatedGroupBy).setArgs(args), false);
    }
}

