/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2;

import java.util.List;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.cache.query.FieldsQueryCursor;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.cache.query.annotations.QuerySqlField;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.processors.cache.index.AbstractIndexingCommonTest;
import org.junit.Test;

public class IgniteSqlQueryMinMaxTest
extends AbstractIndexingCommonTest {
    private static final String CACHE_NAME = "intCache";
    private static final String CACHE_NAME_2 = "valCache";

    protected void beforeTest() throws Exception {
        super.beforeTest();
        this.startGrids(4);
    }

    protected void afterTest() throws Exception {
        super.afterTest();
        this.awaitPartitionMapExchange(true, false, null);
        this.stopAllGrids();
    }

    protected IgniteConfiguration getConfiguration(String gridName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(gridName);
        CacheConfiguration ccfg = new CacheConfiguration("default");
        ccfg.setIndexedTypes(new Class[]{Integer.class, Integer.class});
        ccfg.setName(CACHE_NAME);
        CacheConfiguration ccfg2 = new CacheConfiguration("default");
        ccfg2.setIndexedTypes(new Class[]{Integer.class, ValueObj.class});
        ccfg2.setName(CACHE_NAME_2);
        cfg.setCacheConfiguration(new CacheConfiguration[]{ccfg, ccfg2});
        if ("client".equals(gridName)) {
            cfg.setClientMode(true);
        }
        return cfg;
    }

    @Test
    public void testQueryMinMax() throws Exception {
        try (IgniteEx client = this.startGrid("client");){
            IgniteCache cache = client.cache(CACHE_NAME_2);
            int count = 1000;
            for (int idx = 0; idx < count; ++idx) {
                cache.put((Object)idx, (Object)new ValueObj(count - idx - 1, 0));
            }
            long start = System.currentTimeMillis();
            FieldsQueryCursor cursor = cache.query(new SqlFieldsQuery("select min(_key), max(_key) from ValueObj"));
            List result = cursor.getAll();
            IgniteSqlQueryMinMaxTest.assertEquals((int)1, (int)result.size());
            IgniteSqlQueryMinMaxTest.assertEquals((Object)0, ((List)result.get(0)).get(0));
            IgniteSqlQueryMinMaxTest.assertEquals((Object)(count - 1), ((List)result.get(0)).get(1));
            if (log.isDebugEnabled()) {
                log.debug("Elapsed(1): " + (System.currentTimeMillis() - start));
            }
            start = System.currentTimeMillis();
            cursor = cache.query(new SqlFieldsQuery("select min(idxVal), max(idxVal) from ValueObj"));
            result = cursor.getAll();
            IgniteSqlQueryMinMaxTest.assertEquals((int)1, (int)result.size());
            IgniteSqlQueryMinMaxTest.assertEquals((Object)0, ((List)result.get(0)).get(0));
            IgniteSqlQueryMinMaxTest.assertEquals((Object)(count - 1), ((List)result.get(0)).get(1));
            if (log.isDebugEnabled()) {
                log.debug("Elapsed(2): " + (System.currentTimeMillis() - start));
            }
            start = System.currentTimeMillis();
            cursor = cache.query(new SqlFieldsQuery("select min(nonIdxVal), max(nonIdxVal) from ValueObj"));
            result = cursor.getAll();
            IgniteSqlQueryMinMaxTest.assertEquals((int)1, (int)result.size());
            IgniteSqlQueryMinMaxTest.assertEquals((Object)0, ((List)result.get(0)).get(0));
            IgniteSqlQueryMinMaxTest.assertEquals((Object)(count - 1), ((List)result.get(0)).get(1));
            if (log.isDebugEnabled()) {
                log.debug("Elapsed(3): " + (System.currentTimeMillis() - start));
            }
        }
    }

    @Test
    public void testQueryMinMaxEmptyCache() throws Exception {
        try (IgniteEx client = this.startGrid("client");){
            IgniteCache cache = client.cache(CACHE_NAME_2);
            FieldsQueryCursor cursor = cache.query(new SqlFieldsQuery("select min(idxVal), max(idxVal) from ValueObj"));
            List result = cursor.getAll();
            IgniteSqlQueryMinMaxTest.assertEquals((int)1, (int)result.size());
            IgniteSqlQueryMinMaxTest.assertEquals((int)2, (int)((List)result.get(0)).size());
            IgniteSqlQueryMinMaxTest.assertNull(((List)result.get(0)).get(0));
            IgniteSqlQueryMinMaxTest.assertNull(((List)result.get(0)).get(1));
        }
    }

    @Test
    public void testMinMaxQueryPlanOnKey() throws Exception {
        try (IgniteEx client = this.startGrid("client");){
            IgniteCache cache = client.cache(CACHE_NAME_2);
            FieldsQueryCursor cursor = cache.query(new SqlFieldsQuery("explain select min(_key), max(_key) from ValueObj"));
            List result = cursor.getAll();
            IgniteSqlQueryMinMaxTest.assertEquals((int)2, (int)result.size());
            IgniteSqlQueryMinMaxTest.assertTrue((boolean)((String)((List)result.get(0)).get(0)).toLowerCase().contains("_key_pk"));
            IgniteSqlQueryMinMaxTest.assertTrue((boolean)((String)((List)result.get(0)).get(0)).toLowerCase().contains("direct lookup"));
        }
    }

    @Test
    public void testMinMaxQueryPlanOnFields() throws Exception {
        try (IgniteEx client = this.startGrid("client");){
            IgniteCache cache = client.cache(CACHE_NAME_2);
            FieldsQueryCursor cursor = cache.query(new SqlFieldsQuery("explain select min(idxVal), max(idxVal) from ValueObj"));
            List result = cursor.getAll();
            IgniteSqlQueryMinMaxTest.assertEquals((int)2, (int)result.size());
            IgniteSqlQueryMinMaxTest.assertTrue((boolean)((String)((List)result.get(0)).get(0)).toLowerCase().contains("idxval_idx"));
            IgniteSqlQueryMinMaxTest.assertTrue((boolean)((String)((List)result.get(0)).get(0)).toLowerCase().contains("direct lookup"));
        }
    }

    @Test
    public void testSimpleMinMaxQueryPlanOnKey() throws Exception {
        try (IgniteEx client = this.startGrid("client");){
            IgniteCache cache = client.cache(CACHE_NAME);
            FieldsQueryCursor cursor = cache.query(new SqlFieldsQuery("explain select min(_key), max(_key) from Integer"));
            List result = cursor.getAll();
            IgniteSqlQueryMinMaxTest.assertEquals((int)2, (int)result.size());
            String res = ((String)((List)result.get(0)).get(0)).toLowerCase();
            IgniteSqlQueryMinMaxTest.assertTrue((String)res, (boolean)res.contains("_key_pk"));
            IgniteSqlQueryMinMaxTest.assertTrue((String)res, (boolean)res.contains("direct lookup"));
        }
    }

    @Test
    public void testSimpleMinMaxQueryPlanOnValue() throws Exception {
        try (IgniteEx client = this.startGrid("client");){
            IgniteCache cache = client.cache(CACHE_NAME);
            FieldsQueryCursor cursor = cache.query(new SqlFieldsQuery("explain select min(_val), max(_val) from Integer"));
            List result = cursor.getAll();
            IgniteSqlQueryMinMaxTest.assertEquals((int)2, (int)result.size());
            IgniteSqlQueryMinMaxTest.assertTrue((boolean)((String)((List)result.get(0)).get(0)).toLowerCase().contains("_val_idx"));
            IgniteSqlQueryMinMaxTest.assertTrue((boolean)((String)((List)result.get(0)).get(0)).toLowerCase().contains("direct lookup"));
        }
    }

    @Test
    public void testGroupMinMax() throws Exception {
        try (IgniteEx client = this.startGrid("client");){
            IgniteCache cache = client.cache(CACHE_NAME_2);
            int count = 1000;
            int groupSize = 100;
            for (int idx = 0; idx < count; ++idx) {
                cache.put((Object)idx, (Object)new ValueObj(count - idx - 1, groupSize));
            }
            FieldsQueryCursor cursor = cache.query(new SqlFieldsQuery("select groupVal, min(idxVal), max(idxVal), min(nonIdxVal), max(nonIdxVal)  from ValueObj group by groupVal order by groupVal"));
            List result = cursor.getAll();
            IgniteSqlQueryMinMaxTest.assertEquals((int)(count / groupSize), (int)result.size());
            for (int idx = 0; idx < result.size(); ++idx) {
                IgniteSqlQueryMinMaxTest.assertEquals((Object)idx, ((List)result.get(idx)).get(0));
                int min = idx * groupSize;
                int max = (idx + 1) * groupSize - 1;
                IgniteSqlQueryMinMaxTest.assertEquals((Object)min, ((List)result.get(idx)).get(1));
                IgniteSqlQueryMinMaxTest.assertEquals((Object)max, ((List)result.get(idx)).get(2));
                IgniteSqlQueryMinMaxTest.assertEquals((Object)min, ((List)result.get(idx)).get(3));
                IgniteSqlQueryMinMaxTest.assertEquals((Object)max, ((List)result.get(idx)).get(4));
            }
        }
    }

    @Test
    public void testGroupHavingMinMax() throws Exception {
        try (IgniteEx client = this.startGrid("client");){
            IgniteCache cache = client.cache(CACHE_NAME_2);
            int count = 1000;
            int groupSize = 100;
            for (int idx = 0; idx < count; ++idx) {
                cache.put((Object)idx, (Object)new ValueObj(count - idx - 1, groupSize));
            }
            FieldsQueryCursor cursor = cache.query(new SqlFieldsQuery("select groupVal, min(idxVal), max(idxVal), min(nonIdxVal), max(nonIdxVal) from ValueObj group by groupVal having min(idxVal) = ?").setArgs(new Object[]{0}));
            List result = cursor.getAll();
            IgniteSqlQueryMinMaxTest.assertEquals((int)1, (int)result.size());
            IgniteSqlQueryMinMaxTest.assertEquals((Object)0, ((List)result.get(0)).get(0));
            IgniteSqlQueryMinMaxTest.assertEquals((Object)0, ((List)result.get(0)).get(1));
            IgniteSqlQueryMinMaxTest.assertEquals((Object)(groupSize - 1), ((List)result.get(0)).get(2));
            IgniteSqlQueryMinMaxTest.assertEquals((Object)0, ((List)result.get(0)).get(3));
            IgniteSqlQueryMinMaxTest.assertEquals((Object)(groupSize - 1), ((List)result.get(0)).get(4));
            cursor = cache.query(new SqlFieldsQuery("select groupVal, min(idxVal), max(idxVal), min(nonIdxVal), max(nonIdxVal) from ValueObj group by groupVal having max(idxVal) = ?").setArgs(new Object[]{count - 1}));
            result = cursor.getAll();
            IgniteSqlQueryMinMaxTest.assertEquals((int)1, (int)result.size());
            IgniteSqlQueryMinMaxTest.assertEquals((Object)((count - 1) / groupSize), ((List)result.get(0)).get(0));
            IgniteSqlQueryMinMaxTest.assertEquals((Object)(count - groupSize), ((List)result.get(0)).get(1));
            IgniteSqlQueryMinMaxTest.assertEquals((Object)(count - 1), ((List)result.get(0)).get(2));
            IgniteSqlQueryMinMaxTest.assertEquals((Object)(count - groupSize), ((List)result.get(0)).get(3));
            IgniteSqlQueryMinMaxTest.assertEquals((Object)(count - 1), ((List)result.get(0)).get(4));
        }
    }

    @Test
    public void testJoinGroupMinMax() throws Exception {
        try (IgniteEx client = this.startGrid("client");){
            int revMax;
            int revMin;
            int max;
            int min;
            int idx;
            IgniteCache cache = client.cache(CACHE_NAME);
            IgniteCache cache2 = client.cache(CACHE_NAME_2);
            int count = 1000;
            int groupSize = 100;
            for (int idx2 = 0; idx2 < count; ++idx2) {
                cache.put((Object)idx2, (Object)idx2);
                cache2.put((Object)idx2, (Object)new ValueObj(count - idx2 - 1, groupSize));
            }
            FieldsQueryCursor cursor = cache.query(new SqlFieldsQuery("select b.groupVal, min(a._key), max(a._key), min(a._val), max(a._val), min(b._key), max(b._key), min(b.idxVal), max(b.idxVal), min(b.nonIdxVal), max(b.nonIdxVal) from \"intCache\".Integer a, \"valCache\".ValueObj b where a._key = b._key group by b.groupVal order by b.groupVal"));
            List result = cursor.getAll();
            IgniteSqlQueryMinMaxTest.assertEquals((int)(count / groupSize), (int)result.size());
            for (idx = 0; idx < result.size(); ++idx) {
                IgniteSqlQueryMinMaxTest.assertEquals((Object)idx, ((List)result.get(idx)).get(0));
                min = idx * groupSize;
                max = (idx + 1) * groupSize - 1;
                revMin = count - max - 1;
                revMax = count - min - 1;
                IgniteSqlQueryMinMaxTest.assertEquals((Object)revMin, ((List)result.get(idx)).get(1));
                IgniteSqlQueryMinMaxTest.assertEquals((Object)revMax, ((List)result.get(idx)).get(2));
                IgniteSqlQueryMinMaxTest.assertEquals((Object)revMin, ((List)result.get(idx)).get(3));
                IgniteSqlQueryMinMaxTest.assertEquals((Object)revMax, ((List)result.get(idx)).get(4));
                IgniteSqlQueryMinMaxTest.assertEquals((Object)revMin, ((List)result.get(idx)).get(5));
                IgniteSqlQueryMinMaxTest.assertEquals((Object)revMax, ((List)result.get(idx)).get(6));
                IgniteSqlQueryMinMaxTest.assertEquals((Object)min, ((List)result.get(idx)).get(7));
                IgniteSqlQueryMinMaxTest.assertEquals((Object)max, ((List)result.get(idx)).get(8));
                IgniteSqlQueryMinMaxTest.assertEquals((Object)min, ((List)result.get(idx)).get(9));
                IgniteSqlQueryMinMaxTest.assertEquals((Object)max, ((List)result.get(idx)).get(10));
            }
            cursor = cache.query(new SqlFieldsQuery("select b.groupVal, min(a._key), max(a._key), min(a._val), max(a._val), min(b._key), max(b._key), min(b.idxVal), max(b.idxVal), min(b.nonIdxVal), max(b.nonIdxVal) from \"intCache\".Integer a, \"valCache\".ValueObj b where a._key = b.idxVal group by b.groupVal order by b.groupVal").setDistributedJoins(true));
            result = cursor.getAll();
            IgniteSqlQueryMinMaxTest.assertEquals((int)(count / groupSize), (int)result.size());
            for (idx = 0; idx < result.size(); ++idx) {
                IgniteSqlQueryMinMaxTest.assertEquals((Object)idx, ((List)result.get(idx)).get(0));
                min = idx * groupSize;
                max = (idx + 1) * groupSize - 1;
                revMin = count - max - 1;
                revMax = count - min - 1;
                IgniteSqlQueryMinMaxTest.assertEquals((Object)min, ((List)result.get(idx)).get(1));
                IgniteSqlQueryMinMaxTest.assertEquals((Object)max, ((List)result.get(idx)).get(2));
                IgniteSqlQueryMinMaxTest.assertEquals((Object)min, ((List)result.get(idx)).get(3));
                IgniteSqlQueryMinMaxTest.assertEquals((Object)max, ((List)result.get(idx)).get(4));
                IgniteSqlQueryMinMaxTest.assertEquals((Object)revMin, ((List)result.get(idx)).get(5));
                IgniteSqlQueryMinMaxTest.assertEquals((Object)revMax, ((List)result.get(idx)).get(6));
                IgniteSqlQueryMinMaxTest.assertEquals((Object)min, ((List)result.get(idx)).get(7));
                IgniteSqlQueryMinMaxTest.assertEquals((Object)max, ((List)result.get(idx)).get(8));
                IgniteSqlQueryMinMaxTest.assertEquals((Object)min, ((List)result.get(idx)).get(9));
                IgniteSqlQueryMinMaxTest.assertEquals((Object)max, ((List)result.get(idx)).get(10));
            }
        }
    }

    public class ValueObj {
        @QuerySqlField(index=true)
        private final int idxVal;
        @QuerySqlField
        private final int nonIdxVal;
        @QuerySqlField
        private final int groupVal;

        public ValueObj(int v, int g) {
            this.idxVal = v;
            this.nonIdxVal = v;
            this.groupVal = g == 0 ? v : v / g;
        }

        public int hashCode() {
            return this.idxVal;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ValueObj)) {
                return false;
            }
            ValueObj other = (ValueObj)o;
            return this.idxVal == other.idxVal && this.nonIdxVal == other.nonIdxVal && this.groupVal == other.groupVal;
        }
    }
}

