/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2;

import javax.cache.processor.MutableEntry;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.processors.query.h2.DmlStatementsProcessor;
import org.apache.ignite.lang.IgniteInClosure;
import org.apache.ignite.lang.IgniteProductVersion;
import org.apache.ignite.testframework.GridTestNode;
import org.junit.Assert;
import org.junit.Test;

public class DmlStatementsProcessorTest {
    @Test
    public void testRemoveEntryModifierCompatibilityOld() throws Exception {
        this.checkRemoveClosureByAnonymousPosition(4);
    }

    @Test
    public void testRemoveEntryModifierCompatibilityNew() throws Exception {
        this.checkRemoveClosureByAnonymousPosition(5);
    }

    @Test
    public void testRemoveEntryModifierClassName() {
        String oldClsName = DmlStatementsProcessor.class.getName() + "$" + 4;
        String newClsName = DmlStatementsProcessor.class.getName() + "$" + 5;
        this.checkRemoveEntryClassName("2.4.0", oldClsName);
        this.checkRemoveEntryClassName("2.5.0", oldClsName);
        this.checkRemoveEntryClassName("2.6.0", oldClsName);
        this.checkRemoveEntryClassName("2.7.0", newClsName);
        this.checkRemoveEntryClassName("2.8.0", newClsName);
    }

    private void checkRemoveEntryClassName(final String ver, String expClsName) {
        GridTestNode node = new GridTestNode(){

            public IgniteProductVersion version() {
                return IgniteProductVersion.fromString((String)ver);
            }
        };
        IgniteInClosure rmvC = DmlStatementsProcessor.getRemoveClosure((ClusterNode)node, (Object)0);
        Assert.assertNotNull((String)"Check remove-closure", (Object)rmvC);
        Assert.assertEquals((String)("Check remove-closure class name for version " + ver), (Object)expClsName, (Object)rmvC.getClass().getName());
    }

    private void checkRemoveClosureByAnonymousPosition(int position) throws Exception {
        Class<?> cls = Class.forName(DmlStatementsProcessor.class.getName() + "$" + position);
        IgniteInClosure rmvC = (IgniteInClosure)cls.newInstance();
        CustomMutableEntry entry = new CustomMutableEntry();
        rmvC.apply(entry);
        Assert.assertTrue((String)"Entry should be removed", (boolean)entry.isRemoved());
    }

    private static class CustomMutableEntry<K, V>
    implements MutableEntry<K, V> {
        private boolean rmvd;

        private CustomMutableEntry() {
        }

        private boolean isRemoved() {
            return this.rmvd;
        }

        public boolean exists() {
            return false;
        }

        public void remove() {
            this.rmvd = true;
        }

        public void setValue(V v) {
        }

        public K getKey() {
            return null;
        }

        public V getValue() {
            return null;
        }

        public <T> T unwrap(Class<T> aCls) {
            return null;
        }
    }
}

