/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query;

import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.TimeZone;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteException;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.cluster.ClusterGroup;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.configuration.DataRegionConfiguration;
import org.apache.ignite.configuration.DataStorageConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.processors.cache.index.AbstractIndexingCommonTest;
import org.apache.ignite.internal.processors.odbc.SqlListenerUtils;
import org.apache.ignite.internal.processors.query.GridQueryProcessor;
import org.apache.ignite.internal.processors.query.h2.DistributedSqlConfiguration;
import org.apache.ignite.internal.processors.query.h2.IgniteH2Indexing;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteRunnable;
import org.apache.ignite.resources.IgniteInstanceResource;
import org.apache.ignite.spi.discovery.tcp.TcpDiscoverySpi;
import org.apache.ignite.testframework.junits.multijvm.IgniteProcessProxy;
import org.junit.Test;

public class UseOneTimeZoneForClusterTest
extends AbstractIndexingCommonTest {
    protected static final String INIT_NODE_NAME = "init-node";
    private static final int KEYS_CNT = 1024;
    private static final String[] TIME_ZONES = new String[]{"EST5EDT", "IST", "Europe/Moscow"};
    private boolean persistence;
    private String tzId;

    protected void beforeTest() throws Exception {
        super.beforeTest();
        this.cleanPersistenceDir();
    }

    protected void afterTest() throws Exception {
        this.stopAllGrids();
        super.afterTest();
    }

    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(igniteInstanceName);
        if (INIT_NODE_NAME.equals(igniteInstanceName)) {
            ((TcpDiscoverySpi)cfg.getDiscoverySpi()).setForceServerMode(true);
            cfg.setClientMode(true);
        }
        if (this.persistence) {
            cfg.setDataStorageConfiguration(new DataStorageConfiguration().setDefaultDataRegionConfiguration(new DataRegionConfiguration().setPersistenceEnabled(true)));
        }
        return cfg.setClientMode(igniteInstanceName.startsWith("cli"));
    }

    protected List<String> additionalRemoteJvmArgs() {
        return Collections.singletonList("-Duser.timezone=" + this.tzId);
    }

    private Ignite startRemoteGrid(String name, String tzId) throws Exception {
        this.tzId = tzId;
        return this.startRemoteGrid(name, this.optimize(this.getConfiguration(name)), null);
    }

    @Test
    public void testServerNodes() throws Exception {
        this.persistence = true;
        IgniteEx ignInit = this.startGrid(INIT_NODE_NAME);
        for (String tz : TIME_ZONES) {
            this.startRemoteGrid("tz-" + tz, tz);
        }
        ignInit.cluster().active(true);
        this.sql("DROP TABLE IF EXISTS TZ_TEST", Collections.emptyList());
        this.sql("CREATE TABLE IF NOT EXISTS TZ_TEST (id int, dateVal DATE, timeVal TIME, tsVal TIMESTAMP, PRIMARY KEY (id))", Collections.emptyList());
        this.fillData();
        this.checkDates();
    }

    @Test
    public void testClientsInDifferentTimeZones() throws Exception {
        this.persistence = true;
        IgniteEx ignInit = this.startGrid(INIT_NODE_NAME);
        for (String tz : TIME_ZONES) {
            this.startRemoteGrid("tz-" + tz, tz);
        }
        ignInit.cluster().active(true);
        this.sql("DROP TABLE IF EXISTS TZ_TEST", Collections.emptyList());
        this.sql("CREATE TABLE IF NOT EXISTS TZ_TEST (id int, dateVal DATE, timeVal TIME, tsVal TIMESTAMP, PRIMARY KEY (id))", Collections.emptyList());
        ArrayList<ClusterGroup> clients = new ArrayList<ClusterGroup>();
        for (String tz : TIME_ZONES) {
            Ignite c = this.startRemoteGrid("cli-tz-" + tz, tz);
            clients.add(ignInit.cluster().forNode(c.cluster().localNode(), new ClusterNode[0]));
        }
        int i = 0;
        while (i < 1024) {
            ClusterGroup rmtCli = (ClusterGroup)clients.get(i % clients.size());
            final int id = i++;
            ignInit.compute(rmtCli).run(new IgniteRunnable(){
                @IgniteInstanceResource
                Ignite ign;

                public void run() {
                    try {
                        UseOneTimeZoneForClusterTest.sql(this.ign, "INSERT INTO TZ_TEST (id, dateVal, timeVal, tsVal) VALUES (?, CAST(? AS DATE), CAST(? AS TIME), CAST(? AS TIMESTAMP))", Arrays.asList(id, "2019-09-09", "09:09:09", "2019-09-09 09:09:09.909"));
                    }
                    catch (Exception e) {
                        throw new IgniteException((Throwable)e);
                    }
                }
            });
        }
        this.checkDates();
    }

    @Test
    public void testPersistence() throws Exception {
        this.persistence = true;
        IgniteEx ignInit = this.startGrid(INIT_NODE_NAME);
        Ignite ignPrev = this.startRemoteGrid("tz-" + TIME_ZONES[0], TIME_ZONES[0]);
        ignInit.cluster().active(true);
        this.sql("DROP TABLE IF EXISTS TZ_TEST", Collections.emptyList());
        this.sql("CREATE TABLE IF NOT EXISTS TZ_TEST (id int, dateVal DATE, timeVal TIME, tsVal TIMESTAMP, PRIMARY KEY (id)) WITH \"TEMPLATE=REPLICATED\"", Collections.emptyList());
        this.fillData();
        for (int i = 1; i < TIME_ZONES.length; ++i) {
            String tz = TIME_ZONES[i];
            this.startRemoteGrid("tz-" + tz, tz);
            ignInit.cluster().setBaselineTopology(ignInit.cluster().topologyVersion());
            this.awaitPartitionMapExchange(false, true, Collections.singleton(ignInit.localNode()), false);
            IgniteProcessProxy.stop((String)ignPrev.name(), (boolean)false);
            this.checkDates();
        }
    }

    @Test
    public void testChangeTimeZone() throws Exception {
        this.persistence = false;
        IgniteEx cli = this.startGrid(INIT_NODE_NAME);
        this.startGrid(0);
        cli.cluster().active(true);
        this.sql("DROP TABLE IF EXISTS TZ_TEST", Collections.emptyList());
        this.sql("CREATE TABLE IF NOT EXISTS TZ_TEST (id int, dateVal DATE, timeVal TIME, tsVal TIMESTAMP, PRIMARY KEY (id)) WITH \"TEMPLATE=REPLICATED\"", Collections.emptyList());
        this.fillData();
        DistributedSqlConfiguration cliSqlDistrCfg = ((IgniteH2Indexing)cli.context().query().getIndexing()).distributedConfiguration();
        TimeZone initTz = cliSqlDistrCfg.timeZone();
        SimpleDateFormat fmtDate = new SimpleDateFormat("yyyy-MM-dd");
        SimpleDateFormat fmtTime = new SimpleDateFormat("HH:mm:ss");
        SimpleDateFormat fmtTs = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        Date date = new Date(119, 8, 9);
        Time time = new Time(9, 9, 9);
        Timestamp ts = new Timestamp(119, 8, 9, 9, 9, 9, 909000000);
        for (int i = 0; i < TIME_ZONES.length; ++i) {
            TimeZone tz = TimeZone.getTimeZone(TIME_ZONES[i]);
            cliSqlDistrCfg.updateTimeZone(tz).get();
            String strDate = fmtDate.format(SqlListenerUtils.convertWithTimeZone((java.util.Date)date, (TimeZone)tz, (TimeZone)initTz));
            String strTime = fmtTime.format(SqlListenerUtils.convertWithTimeZone((Time)time, (TimeZone)tz, (TimeZone)initTz));
            String strTs = fmtTs.format(SqlListenerUtils.convertWithTimeZone((Timestamp)ts, (TimeZone)tz, (TimeZone)initTz));
            this.checkDates(strDate, strTime, strTs);
        }
        cliSqlDistrCfg.updateTimeZone(initTz).get();
        this.checkDates();
    }

    @Test
    public void testChangeTimeZonePersistence() throws Exception {
        this.persistence = true;
        IgniteEx cli = this.startGrid(INIT_NODE_NAME);
        Ignite ignPrev = this.startRemoteGrid("srv", TIME_ZONES[0]);
        cli.cluster().active(true);
        this.sql("DROP TABLE IF EXISTS TZ_TEST", Collections.emptyList());
        this.sql("CREATE TABLE IF NOT EXISTS TZ_TEST (id int, dateVal DATE, timeVal TIME, tsVal TIMESTAMP, PRIMARY KEY (id)) WITH \"TEMPLATE=REPLICATED\"", Collections.emptyList());
        this.fillData();
        this.checkDates();
        for (int i = 1; i < TIME_ZONES.length; ++i) {
            log.info("+++ STOP " + ignPrev.name());
            IgniteProcessProxy.stop((String)"srv", (boolean)false);
            log.info("+++ STOPPED");
            U.sleep((long)2000L);
            ignPrev = this.startRemoteGrid("srv", TIME_ZONES[i]);
            this.checkDates();
        }
    }

    private void fillData() throws Exception {
        for (int i = 0; i < 1024; ++i) {
            this.sql("INSERT INTO TZ_TEST (id, dateVal, timeVal, tsVal) VALUES (?, CAST(? AS DATE), CAST(? AS TIME), CAST(? AS TIMESTAMP))", Arrays.asList(i, "2019-09-09", "09:09:09", "2019-09-09 09:09:09.909"));
        }
    }

    protected void checkDates() throws Exception {
        this.checkDates("2019-09-09", "09:09:09", "2019-09-09 09:09:09.909");
    }

    protected void checkDates(String date, String time, String ts) throws Exception {
        List<List<?>> res = this.sql("SELECT id, CAST(dateVal AS VARCHAR), CAST(timeVal AS VARCHAR), CAST(tsVal AS VARCHAR) FROM TZ_TEST ORDER BY id", Collections.emptyList());
        UseOneTimeZoneForClusterTest.assertEquals((int)1024, (int)res.size());
        for (List<?> row : res) {
            UseOneTimeZoneForClusterTest.assertEquals((Object)date, row.get(1));
            UseOneTimeZoneForClusterTest.assertEquals((Object)time, row.get(2));
            UseOneTimeZoneForClusterTest.assertEquals((Object)ts, row.get(3));
        }
    }

    protected List<List<?>> sql(String sql, List<Object> params) throws Exception {
        return UseOneTimeZoneForClusterTest.sql((Ignite)this.grid(INIT_NODE_NAME), sql, params);
    }

    public static List<List<?>> sql(Ignite ign, String sql, List<Object> params) throws Exception {
        GridQueryProcessor qryProc = ((IgniteEx)ign).context().query();
        SqlFieldsQuery qry = new SqlFieldsQuery(sql).setSchema("PUBLIC").setArgs(params.toArray());
        return qryProc.querySqlFields(qry, true).getAll();
    }
}

