/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.affinity.AffinityFunction;
import org.apache.ignite.cache.affinity.rendezvous.RendezvousAffinityFunction;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.cluster.ClusterState;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.DataRegionConfiguration;
import org.apache.ignite.configuration.DataStorageConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.TestRecordingCommunicationSpi;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.GridDhtPartitionSupplyMessage;
import org.apache.ignite.internal.processors.cache.index.AbstractIndexingCommonTest;
import org.apache.ignite.internal.processors.query.h2.IgniteH2Indexing;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2Table;
import org.apache.ignite.internal.processors.query.h2.opt.TableStatistics;
import org.apache.ignite.internal.util.typedef.G;
import org.apache.ignite.lang.IgniteBiPredicate;
import org.apache.ignite.lang.IgnitePredicate;
import org.apache.ignite.plugin.extensions.communication.Message;
import org.apache.ignite.spi.communication.CommunicationSpi;
import org.apache.ignite.testframework.GridTestUtils;
import org.junit.Test;

public class SqlQueriesTopologyMappingTest
extends AbstractIndexingCommonTest {
    private static boolean persistence;

    protected void beforeTest() throws Exception {
        super.beforeTest();
        persistence = false;
        this.cleanPersistenceDir();
    }

    protected void afterTest() throws Exception {
        this.stopAllGrids();
        super.afterTest();
        this.cleanPersistenceDir();
    }

    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(igniteInstanceName).setCommunicationSpi((CommunicationSpi)new TestRecordingCommunicationSpi());
        if (persistence) {
            DataRegionConfiguration dataReg = new DataRegionConfiguration();
            dataReg.setMaxSize(0x10000000L);
            dataReg.setPersistenceEnabled(true);
            cfg.setDataStorageConfiguration(new DataStorageConfiguration().setDefaultDataRegionConfiguration(dataReg));
        }
        return cfg;
    }

    @Test
    public void testPartitionedQueryWithRebalance() throws Exception {
        this.checkQueryWithRebalance(CacheMode.PARTITIONED);
    }

    @Test
    public void testReplicatedQueryWithRebalance() throws Exception {
        this.checkQueryWithRebalance(CacheMode.REPLICATED);
    }

    @Test
    public void testPartitionedQueryStatUpdateWithRebalance() throws Exception {
        this.checkSqlStatWithRebalance(CacheMode.PARTITIONED);
    }

    @Test
    public void testReplicatedQueryStatUpdateWithRebalance() throws Exception {
        this.checkSqlStatWithRebalance(CacheMode.REPLICATED);
    }

    @Test
    public void testPartitionedQueryWithNodeFilter() throws Exception {
        this.checkQueryWithNodeFilter(CacheMode.PARTITIONED);
    }

    @Test
    public void testReplicatedQueryWithNodeFilter() throws Exception {
        this.checkQueryWithNodeFilter(CacheMode.REPLICATED);
    }

    @Test
    public void testLocalCacheQueryMapping() throws Exception {
        IgniteEx ign0 = this.startGrid(0);
        IgniteCache cache = ign0.createCache(new CacheConfiguration("default").setCacheMode(CacheMode.LOCAL).setSqlSchema("PUBLIC").setIndexedTypes(new Class[]{Integer.class, Integer.class}));
        cache.put((Object)1, (Object)2);
        this.startGrid(1);
        SqlFieldsQuery qry = new SqlFieldsQuery("select * from Integer");
        List res0 = this.grid(0).cache("default").query(qry).getAll();
        SqlQueriesTopologyMappingTest.assertEquals((int)1, (int)res0.size());
        SqlQueriesTopologyMappingTest.assertEqualsCollections(Arrays.asList(1, 2), (Collection)((Collection)res0.get(0)));
        List res1 = this.grid(1).cache("default").query(qry).getAll();
        SqlQueriesTopologyMappingTest.assertTrue((boolean)res1.isEmpty());
    }

    private void checkQueryWithRebalance(CacheMode cacheMode) throws Exception {
        IgniteEx ign0 = this.startGrid(0);
        IgniteCache cache = ign0.createCache(new CacheConfiguration("default").setCacheMode(cacheMode).setIndexedTypes(new Class[]{Integer.class, Integer.class}));
        cache.put((Object)1, (Object)2);
        this.blockRebalanceSupplyMessages(ign0, "default", this.getTestIgniteInstanceName(1));
        this.startGrid(1);
        this.startClientGrid(10);
        for (Ignite ign : G.allGrids()) {
            List res = ign.cache("default").query(new SqlFieldsQuery("select * from Integer")).getAll();
            SqlQueriesTopologyMappingTest.assertEquals((int)1, (int)res.size());
            SqlQueriesTopologyMappingTest.assertEqualsCollections(Arrays.asList(1, 2), (Collection)((Collection)res.get(0)));
        }
    }

    private void checkQueryWithNodeFilter(CacheMode cacheMode) throws Exception {
        IgniteEx ign0 = this.startGrid(0);
        String name0 = ign0.name();
        IgniteCache cache = ign0.createCache(new CacheConfiguration("default").setCacheMode(cacheMode).setNodeFilter((IgnitePredicate & Serializable)node -> name0.equals(node.attribute("org.apache.ignite.ignite.name"))).setIndexedTypes(new Class[]{Integer.class, Integer.class}));
        cache.put((Object)1, (Object)2);
        this.startGrid(1);
        this.startClientGrid(10);
        for (Ignite ign : G.allGrids()) {
            List res = ign.cache("default").query(new SqlFieldsQuery("select * from Integer")).getAll();
            SqlQueriesTopologyMappingTest.assertEquals((int)1, (int)res.size());
            SqlQueriesTopologyMappingTest.assertEqualsCollections(Arrays.asList(1, 2), (Collection)((Collection)res.get(0)));
        }
    }

    private void checkSqlStatWithRebalance(CacheMode cacheMode) throws Exception {
        persistence = true;
        int partitions = 1024;
        IgniteEx ign0 = (IgniteEx)this.startGridsMultiThreaded(2);
        ign0.cluster().state(ClusterState.ACTIVE);
        IgniteCache cache = ign0.createCache(new CacheConfiguration("default").setCacheMode(cacheMode).setAffinity((AffinityFunction)new RendezvousAffinityFunction(false, partitions)).setBackups(1).setIndexedTypes(new Class[]{Integer.class, Integer.class}));
        for (int i = 0; i < partitions; ++i) {
            cache.put((Object)i, (Object)i);
        }
        IgniteEx cli = this.startClientGrid(10);
        IgniteH2Indexing idx = (IgniteH2Indexing)ign0.context().query().getIndexing();
        GridH2Table tbl = idx.schemaManager().dataTable("default", "INTEGER");
        double statUpdTreshold = (Double)GridTestUtils.getFieldValue((Object)tbl, (String[])new String[]{"STATS_UPDATE_THRESHOLD"});
        List newKeys = this.backupKeys(cache, (int)(statUpdTreshold * (double)partitions / 2.0 + 10.0), 2 * partitions);
        this.stopGrid(1);
        this.blockRebalanceSupplyMessages(ign0, "default", this.getTestIgniteInstanceName(1));
        Iterator iterator = newKeys.iterator();
        while (iterator.hasNext()) {
            int key = (Integer)iterator.next();
            cache.put((Object)key, (Object)key);
        }
        IgniteEx ign1 = this.startGrid(1);
        List res = cli.cache("default").query(new SqlFieldsQuery("SELECT COUNT(*) FROM Integer")).getAll();
        SqlQueriesTopologyMappingTest.assertEquals((Object)((long)partitions + (long)newKeys.size()), ((List)res.get(0)).get(0));
        idx = (IgniteH2Indexing)ign1.context().query().getIndexing();
        tbl = idx.schemaManager().dataTable("default", "INTEGER");
        TableStatistics stat = (TableStatistics)GridTestUtils.getFieldValue((Object)tbl, (String[])new String[]{"tblStats"});
        SqlQueriesTopologyMappingTest.assertFalse((stat.primaryRowCount() == 0L ? 1 : 0) != 0);
    }

    private void blockRebalanceSupplyMessages(IgniteEx sndNode, String cacheName, final String dstNodeName) {
        final int grpId = sndNode.cachex(cacheName).context().groupId();
        TestRecordingCommunicationSpi comm0 = (TestRecordingCommunicationSpi)sndNode.configuration().getCommunicationSpi();
        comm0.blockMessages((IgniteBiPredicate)new IgniteBiPredicate<ClusterNode, Message>(){

            public boolean apply(ClusterNode node, Message msg) {
                String dstName = (String)node.attribute("org.apache.ignite.ignite.name");
                if (dstNodeName.equals(dstName) && msg instanceof GridDhtPartitionSupplyMessage) {
                    GridDhtPartitionSupplyMessage msg0 = (GridDhtPartitionSupplyMessage)msg;
                    return msg0.groupId() == grpId;
                }
                return false;
            }
        });
    }
}

