/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query;

import com.google.common.collect.ImmutableSet;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.cache.QueryEntity;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.cache.query.annotations.QuerySqlField;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.junit.Test;

public class SqlPartOfComplexPkLookupTest
extends GridCommonAbstractTest {
    protected void afterTest() throws Exception {
        this.stopAllGrids();
    }

    @Test
    public void testPartOfComplexPkLookupDdl() throws Exception {
        IgniteEx ign = this.startGrid(0);
        IgniteCache cache = ign.getOrCreateCache(new CacheConfiguration("default"));
        cache.query(new SqlFieldsQuery("CREATE TABLE Person(\n  id int,\n  city_id int,\n  name varchar,\n  PRIMARY KEY (id, city_id)\n);"));
        cache.query(new SqlFieldsQuery("INSERT INTO Person (id, city_id, name) VALUES (1, 3, 'John Doe');"));
        cache.query(new SqlFieldsQuery("INSERT INTO Person (id, city_id, name) VALUES (1, 4, 'John Dean');"));
        this.checkPartialPkLookup((IgniteCache<Object, Object>)cache);
    }

    @Test
    public void testPartOfComplexPkLookupQueryEntity() throws Exception {
        IgniteEx ign = this.startGrid(0);
        IgniteCache cache = ign.getOrCreateCache(new CacheConfiguration("default").setQueryEntities(Collections.singleton(new QueryEntity(TestPk.class, String.class).setTableName("Person").addQueryField("name", String.class.getName(), "name").setValueFieldName("name"))));
        cache.put((Object)new TestPk(1, 3), (Object)"John Doe");
        cache.put((Object)new TestPk(1, 4), (Object)"John Dean");
        this.checkPartialPkLookup((IgniteCache<Object, Object>)cache);
    }

    private void checkPartialPkLookup(IgniteCache<Object, Object> cache) {
        SqlPartOfComplexPkLookupTest.assertTrue((boolean)cache.query(new SqlFieldsQuery("SELECT name FROM Person WHERE id = 1 and city_id is null")).getAll().isEmpty());
        SqlPartOfComplexPkLookupTest.assertTrue((boolean)cache.query(new SqlFieldsQuery("SELECT name FROM Person WHERE id = 1 and city_id = null")).getAll().isEmpty());
        List rows = cache.query(new SqlFieldsQuery("SELECT name FROM Person WHERE id = 1")).getAll();
        SqlPartOfComplexPkLookupTest.assertEquals((int)2, (int)rows.size());
        SqlPartOfComplexPkLookupTest.assertEquals((Object)ImmutableSet.of((Object)"John Doe", (Object)"John Dean"), rows.stream().map(row -> (String)row.get(0)).collect(Collectors.toSet()));
        List rows2 = cache.query(new SqlFieldsQuery("SELECT name FROM Person WHERE id = 1 AND city_id = 3")).getAll();
        SqlPartOfComplexPkLookupTest.assertEquals((int)1, (int)rows2.size());
        SqlPartOfComplexPkLookupTest.assertEquals((Object)"John Doe", ((List)rows2.get(0)).get(0));
    }

    public static class TestPk {
        @QuerySqlField(name="id")
        private final int id;
        @QuerySqlField(name="city_id")
        private final int cityId;

        public TestPk(int id, int cityId) {
            this.id = id;
            this.cityId = cityId;
        }
    }
}

