/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query;

import java.util.Arrays;
import java.util.List;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.processors.cache.index.AbstractIndexingCommonTest;
import org.apache.ignite.internal.processors.query.GridQueryProcessor;
import org.apache.ignite.internal.processors.query.h2.IgniteH2Indexing;
import org.apache.ignite.testframework.GridTestUtils;
import org.apache.ignite.testframework.ListeningTestLogger;
import org.apache.ignite.testframework.LogListener;
import org.junit.Test;

public class SqlMergeTest
extends AbstractIndexingCommonTest {
    private static IgniteEx srv;
    protected IgniteEx node;

    protected void beforeTestsStarted() throws Exception {
        super.beforeTestsStarted();
        srv = this.startGrid(0);
    }

    protected void afterTest() throws Exception {
        for (String cache : srv.cacheNames()) {
            srv.cache(cache).destroy();
        }
        super.afterTest();
    }

    protected void beforeTest() throws Exception {
        super.beforeTest();
        this.node = srv;
    }

    @Test
    public void test() throws Exception {
        this.sql("CREATE TABLE test1 (id INT, id2 INT, name VARCHAR, PRIMARY KEY (id, id2))");
        this.checkMergeQuery("MERGE INTO test1 (id, id2, name) VALUES (1, 2, 'Kyle')", 1L);
        this.checkSqlResults("SELECT id, id2, name FROM test1 WHERE id = 1", Arrays.asList(1, 2, "Kyle"));
        this.checkMergeQuery("MERGE INTO test1 (id2, id, name) VALUES (3, 2, 'Santa Claus')", 1L);
        this.checkSqlResults("SELECT id, id2, name FROM test1 WHERE id = 2", Arrays.asList(2, 3, "Santa Claus"));
        this.checkMergeQuery("MERGE INTO test1 (name, id, id2) VALUES ('Holy Jesus', 1, 2), ('Kartman', 3, 4)", 2L);
        this.checkSqlResults("SELECT id, id2, name FROM test1 WHERE id = 1", Arrays.asList(1, 2, "Holy Jesus"));
        this.checkSqlResults("SELECT id, id2, name FROM test1 WHERE id = 3", Arrays.asList(3, 4, "Kartman"));
        this.checkMergeQuery("MERGE INTO test1 (id, id2, name) SELECT id, id2 * 1000, UPPER(name) FROM test1 WHERE id < 2", 1L);
        this.checkSqlResults("SELECT id, id2, name FROM test1 WHERE id = 1 AND id2 = 2000", Arrays.asList(1, 2000, "HOLY JESUS"));
    }

    @Test
    public void testCheckKeysWarning() throws Exception {
        LogListener logLsnr = LogListener.matches((String)"The search row by explicit KEY isn't supported. The primary key is always used to search row").build();
        ListeningTestLogger listeningTestLogger = this.testLog();
        listeningTestLogger.registerListener(logLsnr);
        this.sql("CREATE TABLE test2 (id INT, id2 INT, name VARCHAR, PRIMARY KEY (id, id2))");
        this.checkMergeQuery("MERGE INTO test2 (id, id2, name) VALUES (100, 1, 'Boba')", 1L);
        this.checkSqlResults("SELECT id, id2, name FROM test2 WHERE id = 100", Arrays.asList(100, 1, "Boba"));
        SqlMergeTest.assertFalse((boolean)logLsnr.check());
        logLsnr.reset();
        this.checkMergeQuery("MERGE INTO test2 (id, id2, name) KEY(_key) VALUES (100, 1, 'Bob')", 1L);
        this.checkSqlResults("SELECT id, id2, name FROM test2 WHERE id = 100", Arrays.asList(100, 1, "Bob"));
        SqlMergeTest.assertTrue((boolean)logLsnr.check());
        logLsnr.reset();
        this.checkMergeQuery("MERGE INTO test2 (id2, id, name) KEY(_key) VALUES (2, 100, 'Alice')", 1L);
        this.checkSqlResults("SELECT id, id2, name FROM test2 WHERE id = 100 AND id2 = 2", Arrays.asList(100, 2, "Alice"));
        SqlMergeTest.assertTrue((boolean)logLsnr.check());
        logLsnr.reset();
        this.checkMergeQuery("MERGE INTO test2 (id, id2, name) KEY(id, id2) VALUES (3, 5, 'Stan')", 1L);
        this.checkSqlResults("SELECT id, id2, name FROM test2 WHERE id = 3", Arrays.asList(3, 5, "Stan"));
        SqlMergeTest.assertTrue((boolean)logLsnr.check());
        logLsnr.reset();
        this.checkMergeQuery("MERGE INTO test2 (id, id2, name) KEY(id2, id) VALUES (1, 100, 'Satan')", 1L);
        this.checkSqlResults("SELECT id, id2, name FROM test2 WHERE id = 1", Arrays.asList(1, 100, "Satan"));
        SqlMergeTest.assertTrue((boolean)logLsnr.check());
        logLsnr.reset();
        this.checkMergeQuery("MERGE INTO test2 (id2, id, name) KEY(id) VALUES (15, 32, 'Kyle')", 1L);
        this.checkSqlResults("SELECT id, id2, name FROM test2 WHERE id = 32", Arrays.asList(32, 15, "Kyle"));
        SqlMergeTest.assertTrue((boolean)logLsnr.check());
        logLsnr.reset();
        this.checkMergeQuery("MERGE INTO test2 (name, id, id2) KEY(id2) VALUES ('Morlock', 13, 12)", 1L);
        this.checkSqlResults("SELECT id, id2, name FROM test2 WHERE id = 13", Arrays.asList(13, 12, "Morlock"));
        SqlMergeTest.assertTrue((boolean)logLsnr.check());
        logLsnr.reset();
        this.checkMergeQuery("MERGE INTO test2 (id, name, id2) KEY(_key, id) VALUES (10, 'Warlock', 52)", 1L);
        this.checkSqlResults("SELECT id, id2, name FROM test2 WHERE id = 10", Arrays.asList(10, 52, "Warlock"));
        SqlMergeTest.assertTrue((boolean)logLsnr.check());
        logLsnr.reset();
        this.checkMergeQuery("MERGE INTO test2 (id, id2, name) KEY(name) VALUES (10, -11, 'Sherlock')", 1L);
        this.checkSqlResults("SELECT id, id2, name FROM test2 WHERE id = 10 and id2=-11", Arrays.asList(10, -11, "Sherlock"));
        SqlMergeTest.assertTrue((boolean)logLsnr.check());
        logLsnr.reset();
    }

    private void checkMergeQuery(String sql, long expectedUpdateCounts) throws Exception {
        List<List<?>> resMrg = this.sql(sql);
        SqlMergeTest.assertEquals((int)1, (int)resMrg.size());
        SqlMergeTest.assertEquals((int)1, (int)resMrg.get(0).size());
        SqlMergeTest.assertEquals((Object)expectedUpdateCounts, resMrg.get(0).get(0));
    }

    private void checkSqlResults(String sql, List<?> expectedRow) throws Exception {
        List<List<?>> res = this.sql(sql);
        SqlMergeTest.assertEquals((int)1, (int)res.size());
        SqlMergeTest.assertEquals(expectedRow, res.get(0));
    }

    protected List<List<?>> sql(String sql) throws Exception {
        GridQueryProcessor qryProc = this.node.context().query();
        SqlFieldsQuery qry = new SqlFieldsQuery(sql).setSchema("PUBLIC");
        return qryProc.querySqlFields(qry, true).getAll();
    }

    private ListeningTestLogger testLog() {
        ListeningTestLogger testLog = new ListeningTestLogger(false, log);
        GridTestUtils.setFieldValue((Object)((IgniteH2Indexing)this.node.context().query().getIndexing()).parser(), (String)"log", (Object)testLog);
        return testLog;
    }
}

